/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.VJoint;
import hmi.debug.animation.VJointDebugVisualisations;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Embodiment;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.SkeletonEmbodiment;
import hmi.environment.vhloader.impl.AnimationEnvironment;
import hmi.environment.vhloader.impl.HmiRenderBodyAndFaceEmbodiment;
import hmi.environment.vhloader.impl.HmiRenderBodyEmbodiment;
import hmi.environment.vhloader.impl.HmiRenderEnvironment;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.model.Head;
import hmi.faceanimation.model.HeadManager;
import hmi.faceanimation.model.LowerJaw;
import hmi.facegraphics.GLHead;
import hmi.facegraphics.HMIFaceController;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.util.HumanoidLoader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmiRenderEmbodimentLoader
implements EmbodimentLoader {
    private Logger logger = LoggerFactory.getLogger((String)HmiRenderEmbodimentLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private Embodiment embodiment = null;
    String id = "";
    private HumanoidLoader humanoidLoader = null;
    private HashMap<String, Float> permanentmorphtargets = new HashMap();
    private boolean includeFace = false;
    private ArrayList<String> faceExpressionMorphTargets = new ArrayList();
    private String fapDeformFile = null;
    private String fapDeformResources = null;
    private String fapDeformMesh = null;
    private float[] debugOffset = new float[]{0.0f, 0.0f, 0.0f};
    private String debugType = "sphere";
    private boolean addDebugTree = false;
    private HmiRenderEnvironment hre = null;
    private AnimationEnvironment ae = null;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        for (Environment e : environments) {
            if (e instanceof HmiRenderEnvironment) {
                this.hre = (HmiRenderEnvironment)e;
            }
            if (!(e instanceof AnimationEnvironment)) continue;
            this.ae = (AnimationEnvironment)e;
        }
        if (this.hre == null) {
            throw new RuntimeException("HmiRenderEmbodimentLoader requires an Environment of type HmiRenderEnvironment");
        }
        if (this.ae == null) {
            throw new RuntimeException("HmiRenderEmbodimentLoader requires an Environment of type AnimationEnvironment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEmbodiment(tokenizer, newId);
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("Body")) {
            String shaderDir;
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("Body");
            String textureDir = this.adapter.getOptionalAttribute("texturedir", attrMap);
            if (textureDir != null) {
                GLTextureLoader.addTextureDirectory((String)textureDir);
            }
            if ((shaderDir = this.adapter.getOptionalAttribute("shaderdir", attrMap)) != null) {
                GLTextureLoader.addTextureDirectory((String)shaderDir);
            }
            this.humanoidLoader = new HumanoidLoader(this.id, this.adapter.getOptionalAttribute("resourcedir", attrMap, ""), this.adapter.getRequiredAttribute("filename", attrMap, tokenizer), this.adapter.getOptionalAttribute("postprocessing", attrMap, "NONE"));
            tokenizer.takeETag("Body");
        } else if (tokenizer.atSTag("PermanentMorphs")) {
            tokenizer.takeSTag("PermanentMorphs");
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (!tag.equals("PermanentMorph")) {
                    throw new XMLScanException("Unknown tag in PermanentMorphs: " + tag);
                }
                HashMap attrMap2 = tokenizer.getAttributes();
                String target = this.adapter.getRequiredAttribute("target", attrMap2, tokenizer);
                float amount = this.adapter.getRequiredFloatAttribute("amount", attrMap2, tokenizer);
                this.permanentmorphtargets.put(target, new Float(amount));
                tokenizer.takeSTag(tag);
                tokenizer.takeETag(tag);
            }
            tokenizer.takeETag("PermanentMorphs");
        } else if (tokenizer.atSTag("Face")) {
            this.includeFace = true;
            tokenizer.takeSTag("Face");
            while (tokenizer.atSTag()) {
                HashMap attrMap2;
                if (tokenizer.atSTag("FapDeform")) {
                    attrMap2 = tokenizer.getAttributes();
                    this.fapDeformFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
                    this.fapDeformResources = this.adapter.getOptionalAttribute("resources", attrMap2, "");
                    this.fapDeformMesh = this.adapter.getRequiredAttribute("facemesh", attrMap2, tokenizer);
                    tokenizer.takeSTag("FapDeform");
                    tokenizer.takeETag("FapDeform");
                    continue;
                }
                if (!tokenizer.atSTag("FaceExpressionMorphTargets")) continue;
                tokenizer.takeSTag("FaceExpressionMorphTargets");
                while (tokenizer.atSTag()) {
                    attrMap2 = tokenizer.getAttributes();
                    tokenizer.takeSTag("Target");
                    this.faceExpressionMorphTargets.add(this.adapter.getRequiredAttribute("name", attrMap2, tokenizer));
                    tokenizer.takeETag("Target");
                }
                tokenizer.takeETag("FaceExpressionMorphTargets");
            }
            tokenizer.takeETag("Face");
        } else if (tokenizer.atSTag("DebugVJoints")) {
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("DebugVJoints");
            String offsetString = this.adapter.getOptionalAttribute("offset", attrMap, "0 0 0");
            this.debugOffset = XMLStructureAdapter.decodeFloatArray((String)offsetString);
            this.debugType = this.adapter.getOptionalAttribute("type", attrMap, "sphere");
            tokenizer.takeETag("DebugVJoints");
            this.addDebugTree = true;
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Embodiment content");
        }
    }

    private void constructEmbodiment(XMLTokenizer tokenizer, String newId) {
        if (this.humanoidLoader == null) {
            throw tokenizer.getXMLScanException("Missing Body tag in VHLoader data");
        }
        this.embodiment = this.fapDeformFile != null || this.faceExpressionMorphTargets.size() > 0 ? new HmiRenderBodyAndFaceEmbodiment() : new HmiRenderBodyEmbodiment();
        HmiRenderBodyEmbodiment bodyEmbodiment = (HmiRenderBodyEmbodiment)this.embodiment;
        bodyEmbodiment.setVGLNode(this.humanoidLoader.getAvatarRenderNode());
        bodyEmbodiment.setAnimationVJoint(bodyEmbodiment.getAnimationVJoint());
        bodyEmbodiment.setNextVJoint(bodyEmbodiment.getAnimationVJoint().copyTree("next-"));
        bodyEmbodiment.setCurrentVJoint(bodyEmbodiment.getAnimationVJoint().copyTree("curr-"));
        bodyEmbodiment.setPreviousVJoint(bodyEmbodiment.getAnimationVJoint().copyTree("prev-"));
        bodyEmbodiment.setPredictorVJoint(bodyEmbodiment.getAnimationVJoint().copyTree("pred-"));
        bodyEmbodiment.setGLScene(this.humanoidLoader.getGLScene());
        if (this.humanoidLoader.getGLScene() == null) {
            System.out.println("DERTFYGUTRFDGJHUYTGFH");
        }
        for (Map.Entry<String, Float> entry : this.permanentmorphtargets.entrySet()) {
            bodyEmbodiment.getGLScene().addMorphTargets(new String[]{entry.getKey()}, new float[]{entry.getValue().floatValue()});
        }
        if (this.fapDeformFile != null) {
            BufferedReader br = new Resources(this.fapDeformResources).getReader(this.fapDeformFile);
            HeadManager headManager = new HeadManager(br);
            headManager.setHead((Head)new GLHead());
            GLHead head = (GLHead)headManager.readXMLFile();
            if (head == null) {
                throw tokenizer.getXMLScanException("did not manage to load facemesh data from " + this.fapDeformFile);
            }
            GLRenderList geomList = this.getFaceShape(this.fapDeformMesh, bodyEmbodiment.getVGLNode(), tokenizer).getGeometryList();
            int geomListSize = geomList.size();
            if (geomListSize == 0) {
                return;
            }
            GLSkinnedMesh faceMesh = (GLSkinnedMesh)geomList.get(0);
            head.setFaceMesh(faceMesh);
            LowerJaw lowerJaw = new LowerJaw(bodyEmbodiment.getAnimationVJoint().getPart("temporomandibular"));
            head.setLowerJaw(lowerJaw);
            HMIFaceController fc = new HMIFaceController(bodyEmbodiment.getGLScene(), head);
            fc.setPossibleFaceMorphTargetNames(this.faceExpressionMorphTargets);
            ((HmiRenderBodyAndFaceEmbodiment)this.embodiment).setFaceController((FaceController)fc);
        }
        this.hre.addVisualisation(bodyEmbodiment.getVGLNode(), bodyEmbodiment.getGLScene());
        this.ae.addMixedDynamicsVJoints(bodyEmbodiment.getAnimationVJoint(), bodyEmbodiment.getNextVJoint(), bodyEmbodiment.getCurrentVJoint(), bodyEmbodiment.getPreviousVJoint(), bodyEmbodiment.getPredictorVJoint());
        if (this.addDebugTree) {
            this.addDebugVisualisation(this.debugType, this.debugOffset);
        }
    }

    @Override
    public void unload() {
        HmiRenderBodyEmbodiment bodyEmbodiment = (HmiRenderBodyEmbodiment)this.embodiment;
        this.logger.debug("Removing visualisation");
        this.hre.removeVisualisation(bodyEmbodiment.getVGLNode(), bodyEmbodiment.getGLScene());
        this.logger.debug("Removing from VJoint structures");
        this.ae.removeMixedDynamicsVJoints(bodyEmbodiment.getAnimationVJoint(), bodyEmbodiment.getNextVJoint(), bodyEmbodiment.getCurrentVJoint(), bodyEmbodiment.getPreviousVJoint(), bodyEmbodiment.getPredictorVJoint());
        this.logger.debug("Removing debug visualisation");
        if (this.addDebugTree) {
            this.removeDebugVisualisation();
        }
    }

    @Override
    public Embodiment getEmbodiment() {
        return this.embodiment;
    }

    private GLShape getFaceShape(String shapeId, VGLNode renderNode, XMLTokenizer tokenizer) {
        GLRenderList shapeList = renderNode.getGLShapeList();
        for (int i = 0; i < shapeList.size(); ++i) {
            GLShape shape = (GLShape)shapeList.get(i);
            if (shape.getId() == null || !shape.getId().equals(shapeId)) continue;
            return shape;
        }
        throw tokenizer.getXMLScanException("Cannot find face shape with id " + shapeId);
    }

    private void addDebugVisualisation(String type, float[] offset) {
        VGLNode debugViz = VJointDebugVisualisations.getColoredShapeDebugVisualisationTree((VJoint)((SkeletonEmbodiment)this.embodiment).getAnimationVJoint(), (String)type);
        VJoint move = new VJoint();
        move.setTranslation(offset);
        move.addChild(debugViz.getRoot());
        ((HmiRenderBodyEmbodiment)this.embodiment).addDebugVJoint(move);
        ((HmiRenderBodyEmbodiment)this.embodiment).addDebugVGLNode(debugViz);
        this.hre.addDebugVisualisation(debugViz);
        this.hre.addWorldRenderChild(move);
    }

    private void removeDebugVisualisation() {
        for (VGLNode vgln : ((HmiRenderBodyEmbodiment)this.embodiment).getDebugVGLNodes()) {
            this.hre.removeDebugVisualisation(vgln);
        }
        for (VJoint vj : ((HmiRenderBodyEmbodiment)this.embodiment).getDebugVJoints()) {
            this.hre.removeWorldRenderChild(vj);
        }
    }
}

