/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.planunit.MultiThreadedPlanPlayer;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.EngineLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.JComponentEmbodiment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.MPEG4Embodiment;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.converters.ui.EmotionConverterFrame;
import hmi.faceanimation.converters.ui.FACSConverterFrame;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FaceEngineLoader
implements EngineLoader {
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private MPEG4Embodiment m4e = null;
    private JComponentEmbodiment jce = null;
    private JPanel faceUIPanel = null;
    private boolean initUI = false;
    private Engine engine = null;
    private Player facePlayer = null;
    private EmotionConverter econv;
    private FACSConverter fconv;
    private PlanManager planManager = null;
    private String id = "";
    private FaceBinding facebinding = null;
    private ElckerlycRealizerLoader theRealizerLoader = null;

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theRealizerLoader = realizerLoader;
        for (Loader e : requiredLoaders) {
            if (e instanceof EmbodimentLoader && ((EmbodimentLoader)e).getEmbodiment() instanceof MPEG4Embodiment) {
                this.m4e = (MPEG4Embodiment)((EmbodimentLoader)e).getEmbodiment();
            }
            if (!(e instanceof EmbodimentLoader) || !(((EmbodimentLoader)e).getEmbodiment() instanceof JComponentEmbodiment)) continue;
            this.jce = (JComponentEmbodiment)((EmbodimentLoader)e).getEmbodiment();
        }
        if (this.m4e == null) {
            throw new RuntimeException("FaceEngineLoader requires an EmbodimentLoader containing a MPEG4Embodiment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEngine(tokenizer);
    }

    @Override
    public void unload() {
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("FaceBinding")) {
            attrMap = tokenizer.getAttributes();
            this.facebinding = new FaceBinding();
            try {
                this.facebinding.readXML((Reader)new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannnot load FaceBinding: " + e);
            }
            tokenizer.takeEmptyElement("FaceBinding");
        } else if (tokenizer.atSTag("FaceUI")) {
            if (this.jce == null) {
                throw tokenizer.getXMLScanException("Cannot add FaceUI when no JComponentEmbodiment is set");
            }
            this.initUI = true;
            tokenizer.takeSTag("FaceUI");
            tokenizer.takeETag("FaceUI");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    private void constructEngine(XMLTokenizer tokenizer) {
        if (this.facebinding == null) {
            throw tokenizer.getXMLScanException("facebinding is null, cannot build faceplanner ");
        }
        this.planManager = new PlanManager();
        this.facePlayer = new DefaultPlayer((PlanPlayer)new MultiThreadedPlanPlayer(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.planManager));
        this.econv = new EmotionConverter();
        this.fconv = new FACSConverter();
        FacePlanner facePlanner = new FacePlanner(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.m4e.getFaceController(), this.fconv, this.econv, this.facebinding, this.planManager);
        this.engine = new DefaultEngine((Planner)facePlanner, this.facePlayer, this.planManager);
        this.engine.setId(this.id);
        this.theRealizerLoader.getElckerlycRealizer().addEngine(this.engine);
        if (this.initUI) {
            this.faceUIPanel = new JPanel();
            JButton showFACSConverter = new JButton();
            showFACSConverter.setText("FACS Converter");
            showFACSConverter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new FACSConverterFrame(FaceEngineLoader.this.fconv, FaceEngineLoader.this.m4e.getFaceController());
                }
            });
            this.faceUIPanel.add(showFACSConverter);
            JButton showEmotionConverter = new JButton();
            showEmotionConverter.setText("Emotion Converter");
            showEmotionConverter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new EmotionConverterFrame(FaceEngineLoader.this.econv, FaceEngineLoader.this.m4e.getFaceController());
                }
            });
            this.faceUIPanel.add(showEmotionConverter);
            this.jce.addJComponent(this.faceUIPanel);
        }
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    public Player getFacePlayer() {
        return this.facePlayer;
    }

    public FaceController getFaceController() {
        return this.m4e.getFaceController();
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }
}

