/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader;

import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.FeedbackManagerImpl;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.SortedSmartBodySchedulingStrategy;
import hmi.environment.vhloader.CopyEmbodiment;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.EngineLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.impl.ActivateEngineLoader;
import hmi.environment.vhloader.impl.AnimationEngineLoader;
import hmi.environment.vhloader.impl.ElckerlycRealizerEnvironment;
import hmi.environment.vhloader.impl.InterruptEngineLoader;
import hmi.environment.vhloader.impl.ParameterValueChangeEngineLoader;
import hmi.environment.vhloader.impl.WaitEngineLoader;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ElckerlycVirtualHuman {
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private String name = "<no name>";
    private ElckerlycRealizerLoader theElckerlycRealizerLoader = null;
    private HashMap<String, Loader> loaders = new HashMap();
    private ArrayList<CopyEmbodiment> copyEmbodiments = new ArrayList();
    private ArrayList<Engine> playableEngines = new ArrayList();
    private ElckerlycRealizerEnvironment ere = null;
    private XMLTokenizer theTokenizer = null;
    private Environment[] allEnvironments = new Environment[0];
    private SchedulingClock theSchedulingClock = null;

    public void unload() {
        this.ere.removeVirtualHuman(this);
        this.theElckerlycRealizerLoader.unload();
        for (Map.Entry<String, Loader> loader : this.loaders.entrySet()) {
            loader.getValue().unload();
        }
    }

    public void load(String resources, String filename, String name, Environment[] environments, SchedulingClock sc) throws IOException {
        this.load(XMLTokenizer.forResource((String)resources, (String)filename), name, environments, sc);
    }

    public void load(XMLTokenizer tokenizer, String name, Environment[] environments, SchedulingClock sc) throws IOException {
        for (Environment e : environments) {
            if (!(e instanceof ElckerlycRealizerEnvironment)) continue;
            this.ere = (ElckerlycRealizerEnvironment)e;
        }
        if (this.ere == null) {
            throw new RuntimeException("ElckerlycVirtualHuman requires an realizerenvironment");
        }
        this.theTokenizer = tokenizer;
        this.allEnvironments = environments;
        this.theSchedulingClock = sc;
        this.name = name;
        try {
            String id;
            HashMap attrMap = null;
            this.theTokenizer.takeSTag("ElckerlycVirtualHuman");
            BMLBlockManager bmlBlockManager = new BMLBlockManager();
            FeedbackManagerImpl feedbackManager = new FeedbackManagerImpl(bmlBlockManager);
            BMLParser parser = new BMLParser();
            BMLScheduler scheduler = new BMLScheduler(parser, (FeedbackManager)feedbackManager, this.theSchedulingClock, (SchedulingStrategy)new SortedSmartBodySchedulingStrategy(), bmlBlockManager);
            ElckerlycRealizerLoader erl = null;
            attrMap = this.theTokenizer.getAttributes();
            String elckerlycLoaderClass = this.adapter.getRequiredAttribute("loader", attrMap, this.theTokenizer);
            try {
                erl = (ElckerlycRealizerLoader)Class.forName(elckerlycLoaderClass).newInstance();
            }
            catch (InstantiationException e) {
                throw this.theTokenizer.getXMLScanException("InstantiationException while starting ElckerlycRealizerLoader " + elckerlycLoaderClass);
            }
            catch (IllegalAccessException e) {
                throw this.theTokenizer.getXMLScanException("IllegalAccessException while starting ElckerlycRealizerLoader " + elckerlycLoaderClass);
            }
            catch (ClassNotFoundException e) {
                throw this.theTokenizer.getXMLScanException("ClassNotFoundException while starting ElckerlycRealizerLoader " + elckerlycLoaderClass);
            }
            catch (ClassCastException e) {
                throw this.theTokenizer.getXMLScanException("ClassCastException while starting ElckerlycRealizerLoader " + elckerlycLoaderClass);
            }
            this.theTokenizer.takeSTag("BMLRealizer");
            erl.loadBMLRealizer(name, this.theTokenizer, parser, (FeedbackManager)feedbackManager, this.theSchedulingClock, scheduler, bmlBlockManager, this.allEnvironments);
            this.theTokenizer.takeETag("BMLRealizer");
            this.theElckerlycRealizerLoader = erl;
            Loader loader = null;
            while (this.theTokenizer.atSTag("Loader")) {
                attrMap = this.theTokenizer.getAttributes();
                id = this.adapter.getRequiredAttribute("id", attrMap, this.theTokenizer);
                String loaderClass = this.adapter.getRequiredAttribute("loader", attrMap, this.theTokenizer);
                String requiredLoaderIds = this.adapter.getOptionalAttribute("requiredloaders", attrMap, "");
                ArrayList<Loader> requiredLoaders = new ArrayList<Loader>();
                if (!requiredLoaderIds.equals("")) {
                    for (String reqId : requiredLoaderIds.split(",")) {
                        if (!reqId.equals("") && this.loaders.get(reqId) == null) {
                            throw this.theTokenizer.getXMLScanException("Required loader not present: " + reqId);
                        }
                        requiredLoaders.add(this.loaders.get(reqId));
                    }
                }
                try {
                    loader = (Loader)Class.forName(loaderClass).newInstance();
                }
                catch (InstantiationException e) {
                    throw this.theTokenizer.getXMLScanException("InstantiationException while starting Loader " + loaderClass);
                }
                catch (IllegalAccessException e) {
                    throw this.theTokenizer.getXMLScanException("IllegalAccessException while starting Loader " + loaderClass);
                }
                catch (ClassNotFoundException e) {
                    throw this.theTokenizer.getXMLScanException("ClassNotFoundException while starting Loader " + loaderClass);
                }
                catch (ClassCastException e) {
                    throw this.theTokenizer.getXMLScanException("ClassCastException while starting Loader " + loaderClass);
                }
                this.theTokenizer.takeSTag("Loader");
                loader.readXML(this.theTokenizer, id, this, this.theElckerlycRealizerLoader, this.allEnvironments, requiredLoaders.toArray(new Loader[0]));
                this.theTokenizer.takeETag("Loader");
                this.loaders.put(id, loader);
                if (loader instanceof EmbodimentLoader && ((EmbodimentLoader)loader).getEmbodiment() instanceof CopyEmbodiment) {
                    this.copyEmbodiments.add((CopyEmbodiment)((EmbodimentLoader)loader).getEmbodiment());
                }
                if (!(loader instanceof EngineLoader) || loader instanceof AnimationEngineLoader) continue;
                this.playableEngines.add(((EngineLoader)loader).getEngine());
            }
            this.theTokenizer.takeETag("ElckerlycVirtualHuman");
            id = "waitengine";
            loader = new WaitEngineLoader();
            loader.readXML(null, id, this, this.theElckerlycRealizerLoader, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.playableEngines.add(((EngineLoader)loader).getEngine());
            id = "parametervaluechangeengine";
            loader = new ParameterValueChangeEngineLoader();
            loader.readXML(null, id, this, this.theElckerlycRealizerLoader, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.playableEngines.add(((EngineLoader)loader).getEngine());
            id = "activateengine";
            loader = new ActivateEngineLoader();
            loader.readXML(null, id, this, this.theElckerlycRealizerLoader, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.playableEngines.add(((EngineLoader)loader).getEngine());
            id = "interruptengine";
            loader = new InterruptEngineLoader();
            loader.readXML(null, id, this, this.theElckerlycRealizerLoader, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.playableEngines.add(((EngineLoader)loader).getEngine());
            this.ere.addVirtualHuman(this);
            if (this.theElckerlycRealizerLoader.getDefaultBmlScript() != null) {
                this.theElckerlycRealizerLoader.getRealizerBridge().performBML(this.theElckerlycRealizerLoader.getDefaultBmlScript());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ArrayList<CopyEmbodiment> getCopyEmbodiments() {
        return this.copyEmbodiments;
    }

    public ArrayList<Engine> getPlayableEngines() {
        return this.playableEngines;
    }

    public ElckerlycRealizerLoader getElckerlycRealizerLoader() {
        return this.theElckerlycRealizerLoader;
    }

    public String getName() {
        return this.name;
    }
}

