/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader;

import hmi.bml.bridge.RealizerPort;
import hmi.bml.bridge.TCPIPToBMLRealizerAdapter;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.bridge.LogPipe;
import hmi.elckerlyc.bridge.MultiThreadedElckerlycRealizerBridge;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizerLoader
implements Loader {
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycRealizerLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private ElckerlycRealizer elckerlycRealizer = null;
    private RealizerPort realizerBridge = null;
    private TCPIPToBMLRealizerAdapter theServer = null;
    private BMLBlockManager bmlBlockManager = null;
    private FeedbackManager feedbackManager = null;
    private BMLParser parser = null;
    private BMLScheduler bmlScheduler = null;
    private SchedulingClock schedulingClock = null;
    private String name = "<no name>";
    private String defaultBMLScript = null;
    private String id = "";

    public void loadBMLRealizer(String name, XMLTokenizer tokenizer, BMLParser p, FeedbackManager fb, SchedulingClock sc, BMLScheduler bmls, BMLBlockManager bmlbm, Environment[] environments) throws IOException {
        this.name = name;
        this.bmlScheduler = bmls;
        this.parser = p;
        this.bmlBlockManager = bmlbm;
        this.feedbackManager = fb;
        this.schedulingClock = sc;
        this.elckerlycRealizer = new ElckerlycRealizer(this.parser, this.feedbackManager, this.schedulingClock, this.bmlScheduler, new Engine[0]);
        this.realizerBridge = new MultiThreadedElckerlycRealizerBridge(this.elckerlycRealizer);
        while (!tokenizer.atETag("BMLRealizer")) {
            this.readSection(tokenizer);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void unload() {
        this.logger.debug("Stop emitters!");
        if (this.theServer != null) {
            this.theServer.shutdown();
            this.logger.debug("Attempting to shutdown server...");
        }
        this.elckerlycRealizer.shutdown();
        this.logger.debug("If any pipes or ports or adapters need to be shut down, it should be done here.");
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        throw new RuntimeException("Realizer is not yet loaded from XML, method not implemented...");
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("ServerAdapter")) {
            attrMap = tokenizer.getAttributes();
            String requestPort = this.adapter.getRequiredAttribute("requestport", attrMap, tokenizer);
            String feedbackPort = this.adapter.getRequiredAttribute("feedbackport", attrMap, tokenizer);
            this.theServer = new TCPIPToBMLRealizerAdapter(this.realizerBridge, Integer.valueOf(requestPort).intValue(), Integer.valueOf(feedbackPort).intValue());
            tokenizer.takeSTag("ServerAdapter");
            tokenizer.takeETag("ServerAdapter");
        } else if (tokenizer.atSTag("LogPipe")) {
            attrMap = tokenizer.getAttributes();
            String requestLog = this.adapter.getOptionalAttribute("requestlog", attrMap);
            String feedbackLog = this.adapter.getOptionalAttribute("feedbacklog", attrMap);
            Logger rl = null;
            Logger fl = null;
            if (requestLog != null) {
                rl = LoggerFactory.getLogger((String)requestLog);
            }
            if (feedbackLog != null) {
                fl = LoggerFactory.getLogger((String)feedbackLog);
            }
            this.realizerBridge = new LogPipe(rl, fl, this.realizerBridge, this.schedulingClock);
            tokenizer.takeSTag("LogPipe");
            tokenizer.takeETag("LogPipe");
        } else if (tokenizer.atSTag("DefaultScript")) {
            attrMap = tokenizer.getAttributes();
            String dsRes = this.adapter.getOptionalAttribute("resources", attrMap);
            String dsFile = this.adapter.getOptionalAttribute("filename", attrMap);
            if (dsRes == null) {
                dsRes = "";
            }
            if (dsFile != null) {
                this.defaultBMLScript = new Resources(dsRes).read(dsFile);
                this.logger.debug("Loading default scripts");
                if (this.defaultBMLScript == null || this.defaultBMLScript.equals("")) {
                    this.logger.warn("Cannot load default bml script from {}/{}", (Object)dsRes, (Object)dsFile);
                }
            }
            tokenizer.takeSTag("DefaultScript");
            tokenizer.takeETag("DefaultScript");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in BMLRealizer content");
        }
    }

    public RealizerPort getRealizerBridge() {
        return this.realizerBridge;
    }

    public ElckerlycRealizer getElckerlycRealizer() {
        return this.elckerlycRealizer;
    }

    public TCPIPToBMLRealizerAdapter getTCPIPRealizerBridgeServer() {
        return this.theServer;
    }

    public BMLScheduler getBMLScheduler() {
        return this.bmlScheduler;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultBmlScript() {
        return this.defaultBMLScript;
    }
}

