/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.environment.GraphicsEnvironment;
import hmi.environment.PoisonPillRunnable;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.ode.OdeJoint;
import hmi.physics.ode.OdeMass;
import hmi.physics.ode.OdeRigidBody;
import hmi.util.ClockListener;
import hmi.util.SystemClock;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import net.jcip.annotations.GuardedBy;
import org.odejava.Geom;
import org.odejava.GeomPlane;
import org.odejava.HashSpace;
import org.odejava.JointGroup;
import org.odejava.Odejava;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.OdeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalEnvironment
extends GraphicsEnvironment {
    private Logger logger = LoggerFactory.getLogger((String)PhysicalEnvironment.class.getName());
    public boolean runphysics = true;
    public long physicsLoopFrequency = 100L;
    public boolean collisionEnabled = false;
    protected float[] g = new float[]{0.0f, -9.8f, 0.0f};
    protected float timeStep = 0.003f;
    @GuardedBy(value="itself")
    protected List<Runnable> physicsRunners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="PhysicsSync.getSync()")
    protected World phworld;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected HashSpace space;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected JavaCollision collision;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected SystemClock physicsClock;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected double prevTime = 0.0;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected GeomPlane groundGeom;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected OdeRigidBody phsphere;
    protected VJoint sphereAnimationJoint;
    protected VJoint sphereRenderJoint;
    private static final float[] sphereDiffuse = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] sphereSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] sphereAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] sphereEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    @GuardedBy(value="PhysicsSync.getSync()")
    protected JointGroup glueJointGroup = null;

    protected void initToolbar(boolean collisionEnabledCheck, boolean runPhysicsCheck) {
        super.initToolbar();
        if (runPhysicsCheck) {
            JCheckBox checkPhysics = new JCheckBox("Physics", this.runphysics);
            checkPhysics.addActionListener(new PhysicsCheckListener());
            this.toolBar.add(checkPhysics);
        }
        if (collisionEnabledCheck) {
            JCheckBox checkCollision = new JCheckBox("Collision", this.collisionEnabled);
            checkCollision.addActionListener(new CollisionCheckListener());
            this.toolBar.add(checkCollision);
        }
        this.initThrowBallButton();
    }

    @Override
    protected void initToolbar() {
        this.initToolbar(true, true);
    }

    public void initThrowBallButton() {
        JButton throwBallButton = new JButton("Throw ball");
        throwBallButton.addActionListener(new ThrowBallListener());
        this.toolBar.add(throwBallButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicsRunner(Runnable r) {
        List<Runnable> list = this.physicsRunners;
        synchronized (list) {
            if (this.physicsRunners.isEmpty() || !(this.physicsRunners.get(this.physicsRunners.size() - 1) instanceof PoisonPillRunnable)) {
                this.physicsRunners.add(r);
            }
        }
    }

    @Override
    protected void initGraphicScene() {
        super.initGraphicScene();
        this.initGraphicSphere();
    }

    protected void initGraphicSphere() {
        this.sphereRenderJoint = new VJoint("Sphere render joint");
        GLShape sphereShape = new GLShape("Sphere shape");
        GLRenderList shapeList = new GLRenderList(1);
        SphereGeometry sphereGeometry = new SphereGeometry(0.2f, 25, 25);
        GLMaterial sphereState = new GLMaterial();
        sphereState.setDiffuseColor(sphereDiffuse);
        sphereState.setSpecularColor(sphereSpecular);
        sphereState.setAmbientColor(sphereAmbient);
        sphereState.setEmissionColor(sphereEmission);
        sphereShape.addGLGeometry((GLRenderObject)new NoTexture2DState());
        sphereShape.addGLGeometry((GLRenderObject)new GLFill());
        sphereShape.addGLGeometry((GLRenderObject)sphereState);
        sphereShape.addGLGeometry((GLRenderObject)sphereGeometry);
        sphereShape.linkToTransformMatrix(this.sphereRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)sphereShape);
        VGLNode vglSphere = new VGLNode(this.sphereRenderJoint, shapeList);
        this.sphereAnimationJoint = vglSphere.getRoot().masterCopyTree("master-");
        this.vjWorldAnimationRoot.addChild(this.sphereAnimationJoint);
        this.vjWorldRenderRoot.addChild(this.sphereRenderJoint);
        this.addVisualisation(vglSphere);
    }

    @Override
    public void startClocks() {
        super.startClocks();
        new Sleeper().start();
        this.prevTime = 0.0;
        this.physicsClock.start();
    }

    @Override
    protected void initQuickSettings() {
        this.frameTitle = "HMI Physics Demo Environment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.initWorldPhysics();
        }
        super.init();
        object = PhysicsSync.getSync();
        synchronized (object) {
            this.initSpherePhysics();
            this.initGroundPhysics();
        }
    }

    protected void initWorldPhysics() {
        Odejava.init();
        this.phworld = new World();
        this.phworld.setGravity(this.g[0], this.g[1], this.g[2]);
        this.phworld.setContactSurfaceThickness(0.001f);
        this.space = new HashSpace();
        this.collision = new JavaCollision(this.phworld);
        this.collision.setSurfaceMode(OdeConstants.dContactApprox1);
        this.collision.setSurfaceMu(0.9f);
        this.collision.setSurfaceBounce(0.9f);
        this.physicsClock = new SystemClock(1000L / this.physicsLoopFrequency, "PhysicsEnvironmentRenderClock");
        this.physicsClock.addClockListener((ClockListener)new PhysicsClockListener());
        this.glueJointGroup = new JointGroup();
    }

    protected void initSpherePhysics() {
        OdeMass m = new OdeMass();
        m.setFromSphere(0.05f, 1.0f);
        m.adjustMass(10.0f);
        this.phsphere = new OdeRigidBody("phsphere", this.phworld, (Space)this.space);
        this.phsphere.setMass(m);
        this.phsphere.addSphere(0.2f);
        this.phsphere.setTranslation(0.0f, 0.2f, 15.0f);
        this.phsphere.addRotationBuffer(this.sphereAnimationJoint.getRotationBuffer());
        this.phsphere.addTranslationBuffer(this.sphereAnimationJoint.getTranslationBuffer());
    }

    protected void initGroundPhysics() {
        this.groundGeom = new GeomPlane(0.0f, 1.0f, 0.0f, 0.0f);
        this.space.add((Geom)this.groundGeom);
    }

    protected void physicsTick(float delta) {
        if (this.collisionEnabled) {
            this.collision.collide((Space)this.space);
            this.collision.applyContacts();
        }
        this.phworld.step(delta);
    }

    protected void physicsRun(double currentTime) {
        double time = currentTime - this.prevTime;
        if (time < 0.0) {
            return;
        }
        while (time > (double)this.timeStep) {
            this.physicsTick(this.timeStep);
            time -= (double)this.timeStep;
            this.prevTime += (double)this.timeStep;
        }
    }

    protected void physicsCopy() {
        this.phsphere.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void physicsTime(double currentTime) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsRun(currentTime);
            List<Runnable> list = AnimationSync.getSync();
            synchronized (list) {
                this.physicsCopy();
            }
            list = this.physicsRunners;
            synchronized (list) {
                for (Runnable r : this.physicsRunners) {
                    r.run();
                }
                this.physicsRunners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOdeObjects() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.glueJointGroup.empty();
            this.glueJointGroup.delete();
            this.space.delete();
            this.collision.delete();
            this.phworld.delete();
            Odejava.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeFrame() throws InterruptedException, InvocationTargetException {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.terminate();
        }
        this.cleanUpOdeObjects();
        super.disposeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reset() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.collision.emptyContactGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pause() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void play() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.start();
        }
    }

    public void toggleCollision() {
        this.setCollisionEnabled(!this.collisionEnabled);
    }

    public void togglePhysics() {
        this.setPhysicsEnabled(!this.runphysics);
    }

    @Override
    public void prepareReset() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                PhysicalEnvironment.this.reset();
            }
        });
    }

    @Override
    public void prepareDispose() {
        this.prepareDispose(false);
    }

    @Override
    public void prepareDispose(final boolean exitAfterDispose) {
        this.render = false;
        this.logger.debug("Preparing dispose");
        this.addPhysicsRunner(new PoisonPillRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PhysicalEnvironment.this.logger.debug("Dispose Runner started");
                Object object = PhysicalEnvironment.this.shutdownSync;
                synchronized (object) {
                    try {
                        PhysicalEnvironment.this.disposeFrame();
                    }
                    catch (InterruptedException e) {
                        PhysicalEnvironment.this.logger.warn("Exception when disposing frame ", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        PhysicalEnvironment.this.logger.warn("Exception when disposing frame ", (Throwable)e);
                    }
                    finally {
                        PhysicalEnvironment.this.shutdown = true;
                        if (exitAfterDispose) {
                            PhysicalEnvironment.this.exit();
                        }
                    }
                }
            }
        });
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void glueFeetToFloor(PhysicalHumanoid pHuman) {
        float[] pos = new float[3];
        PhysicalSegment lAnkle = pHuman.getSegment("l_ankle");
        PhysicalSegment rAnkle = pHuman.getSegment("r_ankle");
        OdeJoint jl = new OdeJoint(JointType.FIXED, "l_ankleScrew", this.phworld, this.glueJointGroup);
        lAnkle.box.getTranslation(pos);
        jl.attach(lAnkle.box, null);
        jl.setAnchor(pos[0], pos[1], pos[2]);
        OdeJoint jr = new OdeJoint(JointType.FIXED, "r_ankleScrew", this.phworld, this.glueJointGroup);
        rAnkle.box.getTranslation(pos);
        jr.attach(rAnkle.box, null);
        jr.setAnchor(pos[0], pos[1], pos[2]);
    }

    public void setCollisionEnabled(boolean ce) {
        this.collisionEnabled = ce;
    }

    public void setPhysicsEnabled(boolean rp) {
        this.runphysics = rp;
    }

    class ThrowBallListener
    implements ActionListener {
        ThrowBallListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhysicalEnvironment.this.addPhysicsRunner(new Runnable(){

                @Override
                public void run() {
                    PhysicalEnvironment.this.phsphere.setAngularVelocity(0.0f, 0.0f, 0.0f);
                    PhysicalEnvironment.this.phsphere.setVelocity(0.0f, 0.0f, -5.0f);
                    PhysicalEnvironment.this.phsphere.setTorque(0.0f, 0.0f, 0.0f);
                    PhysicalEnvironment.this.phsphere.setTranslation(0.1f, 2.0f, 2.0f);
                }
            });
        }
    }

    class PhysicsCheckListener
    implements ActionListener {
        PhysicsCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhysicalEnvironment.this.togglePhysics();
        }
    }

    class CollisionCheckListener
    implements ActionListener {
        CollisionCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhysicalEnvironment.this.toggleCollision();
        }
    }

    static class Sleeper
    extends Thread {
        public Sleeper() {
            super("SleeperThread");
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Integer.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class PhysicsClockListener
    implements ClockListener {
        public void time(double currentTime) {
            PhysicalEnvironment.this.physicsTime(currentTime);
        }

        public void initTime(double initTime) {
        }
    }
}

