/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.environment.GLTextureWow;
import hmi.environment.WindowInitializer;
import hmi.graphics.jogl.JOGLContext;
import hmi.graphics.jogl.JOGLRenderer;
import hmi.graphics.opengl.GLBinding;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.renderobjects.GLNavigation2;
import hmi.graphics.opengl.renderobjects.LightBox;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.util.BufferUtil;
import hmi.graphics.util.basicobjects.Background;
import hmi.graphics.util.basicobjects.GLCheckerBoardGround;
import hmi.util.ClockListener;
import hmi.util.SystemClock;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsEnvironment
implements GLRenderObject,
KeyListener {
    private WindowInitializer windowInitializer = new JFrameInitializer();
    protected Object shutdownSync = new Object();
    protected volatile boolean shutdown = false;
    private static Logger logger = LoggerFactory.getLogger((String)GraphicsEnvironment.class.getName());
    public boolean laptop = false;
    public String frameTitle = "HMI Graphics Demo Environment";
    public boolean useVsync = true;
    public boolean showToolbar = true;
    public boolean debugJOGL = false;
    public volatile boolean renderDebugVisualisations = true;
    public volatile boolean render = true;
    public int numStencilBits = 1;
    public int FSAA_samples = 4;
    public double fovyNear = 0.1;
    public double fovyFar = 100.0;
    public boolean enableFSAA = true;
    public boolean fullscreen = false;
    public boolean wowvx = false;
    protected Window window;
    protected JToolBar toolBar;
    protected GLCanvas glCanvas;
    protected JOGLRenderer renderer;
    public SystemClock renderClock;
    protected List<Runnable> renderRunners = Collections.synchronizedList(new ArrayList());
    protected VJoint vjWorldAnimationRoot;
    protected VJoint vjWorldRenderRoot;
    protected VJoint vjNavigationNode;
    protected VJoint vjSceneRenderRoot;
    protected GLNavigation2 glNavControl;
    protected LightBox lights;
    protected VGLNode vglSceneRenderRoot = null;
    protected ArrayList<VGLNode> visualisations = new ArrayList();
    protected ArrayList<VGLNode> hiddenVisualisations = new ArrayList();
    protected ArrayList<VGLNode> visualisationsUninitialized = new ArrayList();
    protected ArrayList<GLScene> glScenes = new ArrayList();
    @GuardedBy(value="debugVisualizations")
    private ArrayList<VGLNode> debugVisualisations = new ArrayList();
    @GuardedBy(value="debugVisualisationsUninitialized")
    private ArrayList<VGLNode> debugVisualisationsUninitialized = new ArrayList();
    protected Background background;
    GLTextureWow color_buf_tex = null;
    GLTextureWow depth_buf_tex = null;
    GLTextureWow wowvx_header_tex = null;
    byte[] wowvx_header_data = new byte[]{1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    float[] wowTransformMatrix = new float[16];
    float dx = 0.0f;
    float dy = 0.0f;
    float dz = 0.0f;

    public VJoint getWorldAnimationRoot() {
        return this.vjWorldAnimationRoot;
    }

    public void addRenderRunner(Runnable r) {
        this.renderRunners.add(r);
    }

    public VJoint getWorldRenderRoot() {
        return this.vjWorldRenderRoot;
    }

    public GraphicsEnvironment() {
        this.initQuickSettings();
    }

    public void init() {
        this.initVJointStructure();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GraphicsEnvironment.this.initUI();
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.initRender();
        this.initGraphicScene();
    }

    protected void initQuickSettings() {
    }

    protected void initVJointStructure() {
        this.vjWorldAnimationRoot = new VJoint("World animation root");
        this.vjWorldRenderRoot = new VJoint("World render root");
        this.vjNavigationNode = new VJoint("Navigation node");
        this.vjNavigationNode.addChild(this.vjWorldRenderRoot);
        this.vjSceneRenderRoot = new VJoint("Scene root");
        this.vjSceneRenderRoot.addChild(this.vjNavigationNode);
        this.vglSceneRenderRoot = new VGLNode("SceneRoot VGL");
        this.addVisualisation(this.vglSceneRenderRoot);
    }

    public void setWindowInitializer(WindowInitializer w) {
        this.windowInitializer = w;
    }

    private Window initWindow() {
        return this.windowInitializer.intitialize(this.frameTitle);
    }

    protected void initUI() {
        this.window = this.initWindow();
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphicsEnvironment.this.prepareDispose(true);
            }
        });
        this.window.setLocation(350, 150);
        this.window.setSize(800, 600);
        this.initToolbar();
        GLCapabilities cap = new GLCapabilities();
        cap.setSampleBuffers(this.enableFSAA);
        cap.setNumSamples(this.FSAA_samples);
        cap.setStencilBits(this.numStencilBits);
        this.glCanvas = new GLCanvas(cap);
        this.glCanvas.addKeyListener((KeyListener)this);
        this.window.add((Component)this.glCanvas);
        if (this.toolBar != null && this.showToolbar) {
            if (this.wowvx) {
                this.window.add((Component)this.toolBar, "Last");
            } else {
                this.window.add((Component)this.toolBar, "First");
            }
        }
        if (this.fullscreen) {
            this.setFullScreen(true);
        }
    }

    protected void initToolbar() {
        this.toolBar = new JToolBar("Presentation player");
        PlayListener playListener = new PlayListener();
        JButton playButton = new JButton();
        ImageIcon playIcon = this.getImageIcon("Play24", "Play");
        this.setupMediaButton(playIcon, (ActionListener)playListener, "Play", "Play", playButton);
        this.toolBar.add(playButton);
        PauseListener pauseListener = new PauseListener();
        JButton pauseButton = new JButton();
        ImageIcon pauseIcon = this.getImageIcon("Pause24", "Pause");
        this.setupMediaButton(pauseIcon, (ActionListener)pauseListener, "Pause", "Pause", pauseButton);
        this.toolBar.add(pauseButton);
        ResetListener resetListener = new ResetListener();
        JButton resetButton = new JButton();
        ImageIcon resetIcon = this.getGeneralImageIcon("Redo24", "Reset");
        this.setupMediaButton(resetIcon, (ActionListener)resetListener, "Reset", "Reset", resetButton);
        this.toolBar.add(resetButton);
        this.toolBar.addKeyListener(this);
        JCheckBox checkDebugViz = new JCheckBox("DebugRender", this.renderDebugVisualisations);
        checkDebugViz.addActionListener(new DebugCheckListener());
        this.toolBar.add(checkDebugViz);
    }

    public void setFullScreen(boolean full) {
        if (this.window instanceof JFrame) {
            JFrame jframe = (JFrame)this.window;
            if (full) {
                jframe.setUndecorated(true);
                jframe.setExtendedState(6);
            } else {
                jframe.setUndecorated(false);
            }
        }
    }

    public void toggleDebugViz() {
        this.renderDebugVisualisations = !this.renderDebugVisualisations;
    }

    protected void initGraphics() {
        this.initRender();
        this.initGraphicScene();
    }

    protected void initRender() {
        this.renderer = new JOGLRenderer((GLAutoDrawable)this.glCanvas);
        this.renderer.setFOVY(40.0);
        this.renderer.setNear(this.fovyNear);
        this.renderer.setFar(this.fovyFar);
        this.renderClock = new SystemClock("GraphicsEnvironmentRenderClock");
        this.renderClock.addClockListener((ClockListener)new MyRenderclockCallback());
        this.renderClock.addClockListener((ClockListener)this.renderer);
        this.renderer.setScene((GLRenderObject)this);
        if (this.debugJOGL) {
            this.renderer.useDebugGL();
        }
        this.renderer.setVsync(this.useVsync);
    }

    protected void initGraphicScene() {
        this.background = new Background(0.3f, 0.3f, 0.4f);
        this.glNavControl = new GLNavigation2((Component)this.glCanvas);
        this.glNavControl.setPosition(0.0f, 1.2f, 4.0f);
        this.glNavControl.time(0.0);
        this.lights = new LightBox(3);
        this.lights.get(0).setDiffuseColor(0.8f, 0.8f, 0.8f);
        this.lights.get(1).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(2).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(0).setPosition(-0.2777347f, 2.5676637f, 0.46893778f);
        this.lights.get(1).setPosition(-0.040819082f, 2.066795f, 2.1057882f);
        this.lights.get(2).setPosition(-1.7811359f, 2.6335182f, 1.9070864f);
        this.lights.get(0).setLinearAttenuation(1.0f);
        this.lights.setControl(this.glNavControl);
        this.initVisualGround();
    }

    protected void initVisualGround() {
        VJoint vjGround = new VJoint("Visual ground");
        GLShape groundShape = new GLShape("Shape visual ground");
        GLRenderList shapeList = new GLRenderList(1);
        GLCheckerBoardGround groundGeometry = new GLCheckerBoardGround(0.0f, 0.5f);
        groundShape.addGLGeometry((GLRenderObject)groundGeometry);
        groundShape.linkToTransformMatrix(vjGround.getGlobalMatrix());
        shapeList.add((GLRenderObject)groundShape);
        VGLNode vglGround = new VGLNode(vjGround, shapeList);
        this.vjWorldRenderRoot.addChild(vglGround.getRoot());
        this.addVisualisation(vglGround);
    }

    public void startAll() {
        this.window.setVisible(true);
        this.glCanvas.requestFocusInWindow();
        this.startClocks();
    }

    public void startClocks() {
        this.renderClock.start();
    }

    protected void play() {
        logger.debug("Play!");
    }

    public void prepareReset() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment.this.reset();
            }
        });
    }

    public void preparePlay() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment.this.play();
            }
        });
    }

    public void preparePause() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment.this.pause();
            }
        });
    }

    protected void prepareDispose() {
        this.prepareDispose(false);
    }

    protected void prepareDispose(final boolean exitAfterDispose) {
        this.addRenderRunner(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GraphicsEnvironment.this.disposeFrame();
                }
                catch (InterruptedException e) {
                    logger.warn("Exception when disposing frame", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.warn("Exception when disposing frame", (Throwable)e);
                }
                finally {
                    if (exitAfterDispose) {
                        GraphicsEnvironment.this.exit();
                    }
                }
            }
        });
    }

    protected void reset() {
        logger.debug("Reset!");
    }

    protected void pause() {
        logger.debug("Pause!");
    }

    protected void disposeFrame() throws InterruptedException, InvocationTargetException {
        logger.debug("Disposing frame {}", (Object)this.getClass().getName());
        this.renderClock.terminate();
        logger.debug("Renderclock terminated");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                logger.debug("Start frame dispose");
                GraphicsEnvironment.this.getFrame().setVisible(false);
                logger.debug("Frame hidden");
                GraphicsEnvironment.this.getFrame().dispose();
                logger.debug("Frame disposed");
            }
        });
        logger.debug("Frame disposed");
    }

    protected void exit() {
        logger.debug("Exit");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            if (this.hasVisualisation(viz)) {
                logger.warn("Trying to add visualsation twice");
                return;
            }
            this.visualisationsUninitialized.add(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGLScene(GLScene gls) {
        ArrayList<GLScene> arrayList = this.glScenes;
        synchronized (arrayList) {
            this.glScenes.add(gls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGLScene(GLScene gls) {
        ArrayList<GLScene> arrayList = this.glScenes;
        synchronized (arrayList) {
            this.glScenes.remove(gls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            if (this.visualisationsUninitialized.contains(viz)) {
                return true;
            }
        }
        arrayList = this.visualisations;
        synchronized (arrayList) {
            if (this.visualisations.contains(viz)) {
                return true;
            }
            if (this.hiddenVisualisations.contains(viz)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisualisationVisible(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisations;
        synchronized (arrayList) {
            return this.visualisations.contains(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisualisationVisible(VGLNode viz, boolean enabled) {
        ArrayList<VGLNode> arrayList = this.visualisations;
        synchronized (arrayList) {
            if (!enabled) {
                ArrayList<VGLNode> arrayList2 = this.visualisationsUninitialized;
                synchronized (arrayList2) {
                    if (this.visualisations.contains(viz)) {
                        this.hiddenVisualisations.add(viz);
                        this.visualisations.remove(viz);
                    } else if (this.visualisationsUninitialized.contains(viz)) {
                        this.hiddenVisualisations.add(viz);
                    } else {
                        throw new RuntimeException("Attempting to hide non-existing VGLNode " + viz.toString());
                    }
                }
            } else if (this.hiddenVisualisations.contains(viz)) {
                this.hiddenVisualisations.remove(viz);
                this.visualisations.add(viz);
            } else {
                throw new RuntimeException("Attempting to show non-existing VGLNode " + viz.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            this.visualisationsUninitialized.remove(viz);
        }
        arrayList = this.visualisations;
        synchronized (arrayList) {
            this.visualisations.remove(viz);
            this.hiddenVisualisations.remove(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.debugVisualisationsUninitialized;
        synchronized (arrayList) {
            this.debugVisualisationsUninitialized.add(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebugVisualisation(VGLNode viz) {
        this.renderDebugVisualisations = false;
        ArrayList<VGLNode> arrayList = this.debugVisualisationsUninitialized;
        synchronized (arrayList) {
            logger.debug("Removing unitialized debug vizualization");
            this.debugVisualisationsUninitialized.remove(viz);
        }
        logger.debug("Finished removing unitialized debug vizualization");
        arrayList = this.debugVisualisations;
        synchronized (arrayList) {
            logger.debug("Removing debug vizualization");
            this.debugVisualisations.remove(viz);
        }
        this.renderDebugVisualisations = true;
    }

    public void glPreInit(GLRenderContext glc) {
        glc.glEnable(2977);
        glc.glEnable(2929);
        glc.glCullFace(1029);
        glc.glEnable(2884);
        glc.glShadeModel(7425);
        glc.glEnable(2896);
        glc.glLightModeli(2897, 1);
        glc.glPolygonMode(1032, 6914);
        float[] global_amb = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        FloatBuffer global_ambient = BufferUtil.directFloatBuffer((int)4);
        global_ambient.put(global_amb);
        global_ambient.rewind();
        glc.glLightModelfv(2899, global_ambient);
        glc.glEnable(2977);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glInit(GLRenderContext glc) {
        ArrayList<VGLNode> arrayList;
        this.glPreInit(glc);
        this.background.glInit(glc);
        this.lights.glInit(glc);
        ArrayList<VGLNode> arrayList2 = this.visualisationsUninitialized;
        synchronized (arrayList2) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                arrayList = this.visualisations;
                synchronized (arrayList) {
                    this.visualisations.add(nextVgl);
                }
            }
            this.visualisationsUninitialized.clear();
        }
        arrayList2 = this.debugVisualisationsUninitialized;
        synchronized (arrayList2) {
            for (VGLNode nextVgl : this.debugVisualisationsUninitialized) {
                nextVgl.glInit(glc);
                arrayList = this.debugVisualisations;
                synchronized (arrayList) {
                    this.debugVisualisations.add(nextVgl);
                }
            }
            this.debugVisualisationsUninitialized.clear();
        }
        this.glNavControl.glInit(glc);
        GLUtil.reportGLErrors((GLBinding)glc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glPreRender(GLRenderContext glc) {
        ArrayList<VGLNode> arrayList;
        glc.glDisable(3042);
        glc.glDepthMask(true);
        glc.glClear(17664);
        glc.glMatrixMode(5888);
        glc.glLoadIdentity();
        if (this.wowvx) {
            glc.glDepthMask(true);
        }
        ArrayList<VGLNode> arrayList2 = this.visualisationsUninitialized;
        synchronized (arrayList2) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                arrayList = this.visualisations;
                synchronized (arrayList) {
                    if (!this.hiddenVisualisations.contains(nextVgl)) {
                        this.visualisations.add(nextVgl);
                    }
                }
            }
            this.visualisationsUninitialized.clear();
        }
        arrayList2 = this.debugVisualisationsUninitialized;
        synchronized (arrayList2) {
            for (VGLNode nextVgl : this.debugVisualisationsUninitialized) {
                nextVgl.glInit(glc);
                arrayList = this.debugVisualisations;
                synchronized (arrayList) {
                    this.debugVisualisations.add(nextVgl);
                }
            }
            this.debugVisualisationsUninitialized.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnimationResultForRender(GLRenderContext glc) {
        this.vjWorldAnimationRoot.calculateMatrices();
        this.vjSceneRenderRoot.calculateMatrices();
        ArrayList<GLScene> arrayList = this.glScenes;
        synchronized (arrayList) {
            for (GLScene gls : this.glScenes) {
                gls.doMorph();
                gls.deform();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glRender(GLRenderContext glc) {
        if (!this.render) {
            return;
        }
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.glPreRender(glc);
            this.glNavControl.glRender(glc);
            this.lights.glRender(glc);
            ArrayList<VGLNode> arrayList = AnimationSync.getSync();
            synchronized (arrayList) {
                this.processAnimationResultForRender(glc);
            }
            arrayList = this.visualisations;
            synchronized (arrayList) {
                for (VGLNode nextVgl : this.visualisations) {
                    if (this.laptop) {
                        glc.glPushAttrib(1048575);
                        glc.glPushClientAttrib(-1);
                    }
                    nextVgl.glRender(glc);
                    glc.glDisable(3042);
                    glc.glDepthMask(true);
                    if (!this.laptop) continue;
                    glc.glPopClientAttrib();
                    glc.glPopAttrib();
                }
            }
            if (this.renderDebugVisualisations) {
                arrayList = this.debugVisualisations;
                synchronized (arrayList) {
                    for (VGLNode nextVgl : this.debugVisualisations) {
                        if (this.laptop) {
                            glc.glPushAttrib(1048575);
                            glc.glPushClientAttrib(-1);
                        }
                        logger.debug("nextVgl.glRender(glc) of debugViz");
                        nextVgl.glRender(glc);
                        logger.debug("Done nextVgl.glRender(glc) of debugViz");
                        glc.glDisable(3042);
                        glc.glDepthMask(true);
                        if (!this.laptop) continue;
                        glc.glPopClientAttrib();
                        glc.glPopAttrib();
                    }
                }
                logger.debug("Done rendering debug viz");
            }
            if (this.wowvx) {
                this.convertBufferToWowVX(glc);
            }
            GLUtil.reportGLErrors((GLBinding)glc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTime(double currentTime) {
        this.navigate(currentTime);
        List<Runnable> list = this.renderRunners;
        synchronized (list) {
            for (Runnable r : this.renderRunners) {
                r.run();
            }
            this.renderRunners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void navigate(double currentTime) {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.glNavControl.time(currentTime);
        }
    }

    void convertBufferToWowVX(GLRenderContext glc) {
        Dimension scrsize = this.glCanvas.getSize();
        float factor = 500.0f;
        float w = (float)scrsize.width / factor;
        float h = (float)scrsize.height / factor - 1.0f / factor;
        if (this.color_buf_tex == null) {
            GLTextureWow.setNPOTMode(0);
            this.color_buf_tex = new GLTextureWow(glc, (int)(w * factor), (int)(h * factor), false, false);
            this.depth_buf_tex = new GLTextureWow(glc, (int)(w * factor), (int)(h * factor), false, false);
        }
        if (this.wowvx_header_tex == null) {
            int[] wowvx_header = new int[this.wowvx_header_data.length];
            for (int i = 0; i < wowvx_header.length; ++i) {
                wowvx_header[i] = this.wowvx_header_data[i] == 0 ? -16777216 : -16776961;
            }
            this.wowvx_header_tex = new GLTextureWow(glc, wowvx_header, wowvx_header.length, 1, false, false);
        }
        this.color_buf_tex.copyRenderBuffer(glc, 0, 0);
        this.depth_buf_tex.copyDepthBuffer(glc, 0, 0);
        glc.glClear(17664);
        float z = 0.0f;
        this.color_buf_tex.writeToGL(glc);
        this.color_buf_tex.enable(glc);
        glc.glBegin(9);
        glc.glTexCoord2f(0.0f, 0.0f);
        glc.glVertex3f(-w / 2.0f, 0.0f, z);
        glc.glTexCoord2f(0.0f, 1.0f);
        glc.glVertex3f(-w / 2.0f, h, z);
        glc.glTexCoord2f(1.0f, 1.0f);
        glc.glVertex3f(0.0f, h, z);
        glc.glTexCoord2f(1.0f, 0.0f);
        glc.glVertex3f(0.0f, 0.0f, z);
        glc.glEnd();
        this.color_buf_tex.disable(glc);
        this.depth_buf_tex.writeToGL(glc);
        this.depth_buf_tex.enable(glc);
        glc.glEnable(3042);
        glc.glBlendFunc(769, 1);
        glc.glBegin(9);
        glc.glTexCoord2f(0.0f, 0.0f);
        glc.glVertex3f(0.0f, 0.0f, z);
        glc.glTexCoord2f(0.0f, 1.0f);
        glc.glVertex3f(0.0f, h, z);
        glc.glTexCoord2f(1.0f, 1.0f);
        glc.glVertex3f(w / 2.0f, h, z);
        glc.glTexCoord2f(1.0f, 0.0f);
        glc.glVertex3f(w / 2.0f, 0.0f, z);
        glc.glEnd();
        this.depth_buf_tex.disable(glc);
        glc.glBlendFunc(770, 771);
        glc.glDisable(3042);
        this.wowvx_header_tex.writeToGL(glc);
        this.wowvx_header_tex.enable(glc);
        glc.glColor3f(1.0f, 1.0f, 1.0f);
        glc.glDisable(3042);
        glc.glBegin(9);
        glc.glTexCoord2f(0.0f, 0.0f);
        glc.glVertex3f(-w / 2.0f - 1.0f / factor, h - 1.0f / factor, z);
        glc.glTexCoord2f(0.0f, 1.0f);
        glc.glVertex3f(-w / 2.0f - 1.0f / factor, h + 1.0f / factor, z);
        glc.glTexCoord2f(1.0f, 1.0f);
        glc.glVertex3f(-w / 2.0f - 1.0f / factor + (float)this.wowvx_header_data.length / factor, h + 1.0f / factor, z);
        glc.glTexCoord2f(1.0f, 0.0f);
        glc.glVertex3f(-w / 2.0f - 1.0f / factor + (float)this.wowvx_header_data.length / factor, h - 1.0f / factor, z);
        glc.glEnd();
        this.renderer.reshape(((JOGLContext)glc).getGL(), 0, 0, (int)(w * factor), (int)(h * factor));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.prepareDispose(true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == 'k') {
            this.dx -= 1.0f;
        }
        if (e.getKeyChar() == ';') {
            this.dx += 1.0f;
        }
        if (e.getKeyChar() == 'l') {
            this.dy -= 1.0f;
        }
        if (e.getKeyChar() == 'o') {
            this.dy += 1.0f;
        }
        if (e.getKeyChar() == '[') {
            this.dz -= 1.0f;
        }
        if (e.getKeyChar() == ']') {
            this.dz += 1.0f;
        }
        logger.debug("{} , {}, {}", new Object[]{Float.valueOf(this.dx), Float.valueOf(this.dy), Float.valueOf(this.dz)});
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Window getFrame() {
        return this.window;
    }

    public ImageIcon getImageIcon(String imageName, String altText) {
        String imgLocation = "/toolbarButtonGraphics/media/" + imageName + ".gif";
        URL imageURL = GraphicsEnvironment.class.getResource(imgLocation);
        if (imageURL != null) {
            return new ImageIcon(imageURL, altText);
        }
        System.err.println("Resource not found: " + imgLocation);
        return null;
    }

    public ImageIcon getGeneralImageIcon(String imageName, String altText) {
        String imgLocation = "/toolbarButtonGraphics/general/" + imageName + ".gif";
        URL imageURL = GraphicsEnvironment.class.getResource(imgLocation);
        if (imageURL != null) {
            return new ImageIcon(imageURL, altText);
        }
        System.err.println("Resource not found: " + imgLocation);
        return null;
    }

    public void setupMediaButton(ImageIcon icon, ActionListener listener, String toolTipText, String altText, JButton button) {
        button.setToolTipText(toolTipText);
        ActionListener[] list = button.getActionListeners();
        for (int i = 0; i < list.length; ++i) {
            button.removeActionListener(list[i]);
        }
        button.addActionListener(listener);
        if (icon != null) {
            button.setIcon(icon);
        } else {
            button.setText(altText);
        }
    }

    public void setupMediaButton(String imageName, ActionListener listener, String toolTipText, String altText, JButton button) {
        this.setupMediaButton(this.getImageIcon(imageName, altText), listener, toolTipText, altText, button);
    }

    class PauseListener
    implements ActionListener {
        PauseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsEnvironment.this.preparePause();
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsEnvironment.this.prepareReset();
        }
    }

    class DebugCheckListener
    implements ActionListener {
        DebugCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsEnvironment.this.toggleDebugViz();
        }
    }

    class PlayListener
    implements ActionListener {
        PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsEnvironment.this.preparePlay();
        }
    }

    class MyRenderclockCallback
    implements ClockListener {
        MyRenderclockCallback() {
        }

        public void initTime(double time) {
        }

        public void time(double currentTime) {
            GraphicsEnvironment.this.renderTime(currentTime);
        }
    }

    private static class JFrameInitializer
    implements WindowInitializer {
        private JFrameInitializer() {
        }

        @Override
        public Window intitialize(String windowName) {
            return new JFrame(windowName);
        }
    }
}

