/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.animationengine.AnimationPlayerManager;
import hmi.elckerlyc.animationengine.PhysicsCallback;
import hmi.elckerlyc.scheduler.PhysicsSchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.world.WorldObject;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.environment.PhysicalEnvironment;
import hmi.environment.PoisonPillRunnable;
import hmi.environment.vhloader.CopyEmbodiment;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.impl.AnimationEnvironment;
import hmi.environment.vhloader.impl.ElckerlycRealizerEnvironment;
import hmi.environment.vhloader.impl.HmiRenderEnvironment;
import hmi.environment.vhloader.impl.JPanelEnvironment;
import hmi.environment.vhloader.impl.OdePhysicalEnvironment;
import hmi.graphics.opengl.GLRenderContext;
import hmi.physics.PhysicsSync;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.odejava.Space;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycEnvironment
extends PhysicalEnvironment {
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycEnvironment.class.getName());
    protected VJoint vjCameraTarget;
    protected VJoint vjMixedDynamicsAnimationRoot;
    protected VJoint vjNextMixedDynamicsRoot;
    protected VJoint vjCurrentMixedDynamicsRoot;
    protected VJoint vjPreviousMixedDynamicsRoot;
    protected VJoint vjPredictorMixedDynamicsRoot;
    protected AnimationPlayerManager theAnimationPlayerManager = null;
    protected ArrayList<ElckerlycVirtualHuman> virtualHumanList = new ArrayList();
    protected ElckerlycRealizerEnvironment ere = null;
    protected AnimationEnvironment ae = null;
    protected HmiRenderEnvironment hre = null;
    protected JPanelEnvironment jpe = null;
    protected OdePhysicalEnvironment ope = null;
    protected Environment[] environments = new Environment[0];

    public ElckerlycRealizerEnvironment getElckerlycRealizerEnvironment() {
        return this.ere;
    }

    public AnimationEnvironment getAnimationEnvironment() {
        return this.ae;
    }

    public HmiRenderEnvironment getHmiRenderEnvironment() {
        return this.hre;
    }

    public JPanelEnvironment getJPanelEnvironment() {
        return this.jpe;
    }

    public OdePhysicalEnvironment getOdePhysicalEnvironment() {
        return this.ope;
    }

    @Override
    public void init() {
        this.logger.debug("Initializing ElckerlycEnvironment");
        super.init();
        this.initMixedAnimation();
        this.initVoiceSystem();
        this.initEnvironments();
    }

    @Override
    protected void initToolbar() {
        super.initToolbar();
    }

    @Override
    protected void initGraphicScene() {
        super.initGraphicScene();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initEnvironments() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                this.hre = new HmiRenderEnvironment();
                this.hre.setGraphicsEnvironment(this);
                this.hre.setWorldRenderRoot(this.vjWorldRenderRoot);
                this.hre.setNavigationControl(this.glNavControl);
                this.hre.setId("renderenvironment");
                this.ae = new AnimationEnvironment(this.hre);
                this.ae.setWorldObjectManager(new WorldObjectManager());
                this.ae.setAnimationPlayerManager(this.theAnimationPlayerManager);
                this.ae.setMixedDynamicsAnimationRoot(this.vjMixedDynamicsAnimationRoot);
                this.ae.setNextMixedDynamicsRoot(this.vjNextMixedDynamicsRoot);
                this.ae.setCurrentMixedDynamicsRoot(this.vjCurrentMixedDynamicsRoot);
                this.ae.setPreviousMixedDynamicsRoot(this.vjPreviousMixedDynamicsRoot);
                this.ae.setPredictorMixedDynamicsRoot(this.vjPredictorMixedDynamicsRoot);
                this.ae.setId("animationenvironment");
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ElckerlycEnvironment.this.jpe = new JPanelEnvironment();
                            JPanel jp = new JPanel();
                            if (ElckerlycEnvironment.this.showToolbar) {
                                ElckerlycEnvironment.this.toolBar.add(jp);
                            }
                            ElckerlycEnvironment.this.jpe.setPanel(jp);
                            JButton loaderButton = new JButton("Load");
                            loaderButton.addActionListener(new LoaderButtonListener());
                            ElckerlycEnvironment.this.jpe.addJComponent(loaderButton);
                            ElckerlycEnvironment.this.jpe.setId("jpanelenvironment");
                        }
                    });
                }
                catch (InterruptedException e) {
                    this.logger.warn("Exception construting JPanelEnvironment", (Throwable)e);
                    Thread.interrupted();
                }
                catch (InvocationTargetException e) {
                    this.logger.warn("Exception construting JPanelEnvironment", (Throwable)e);
                }
                this.ope = new OdePhysicalEnvironment(this);
                this.ope.setCollision(this.collision);
                this.ope.setSpace(this.space);
                this.ope.setWorld(this.phworld);
                this.ope.setId("physicalenvironment");
                this.ere = new ElckerlycRealizerEnvironment();
                this.ere.setElckerlycEnvironment(this);
                this.ere.setId("realizerenvironment");
                this.environments = new Environment[]{this.ae, this.hre, this.ope, this.jpe, this.ere};
                this.vjCameraTarget = new VJoint("camera");
                this.vjWorldAnimationRoot.addChild(this.vjCameraTarget);
                if (this.ae.getWorldObjectManager() != null) {
                    this.ae.getWorldObjectManager().addWorldObject("camera", new WorldObject(this.vjCameraTarget));
                }
            }
        }
    }

    protected void initMixedAnimation() {
        this.vjMixedDynamicsAnimationRoot = new VJoint("Mixed dynamic animation root");
        this.vjWorldAnimationRoot.addChild(this.vjMixedDynamicsAnimationRoot);
        this.vjNextMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.copyTree("next-");
        this.vjCurrentMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.copyTree("curr-");
        this.vjPreviousMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.copyTree("prev-");
        this.vjPredictorMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.copyTree("pred-");
        this.theAnimationPlayerManager = new AnimationPlayerManager((PhysicsCallback)new PhysCallback(), this.vjMixedDynamicsAnimationRoot, this.vjCurrentMixedDynamicsRoot);
    }

    @Override
    protected void initQuickSettings() {
        this.frameTitle = "Elckerlyc - HMI Virtual Human Environment";
    }

    protected void initVoiceSystem() {
    }

    public ElckerlycVirtualHuman loadVirtualHuman(String resources, String fileName, String name) throws IOException {
        ElckerlycVirtualHuman evh = new ElckerlycVirtualHuman();
        evh.load(resources, fileName, name, this.environments, (SchedulingClock)new PhysicsSchedulingClock(this.physicsClock));
        return evh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void physicsTime(double currentTime) {
        this.prevTime = this.theAnimationPlayerManager.getPrevTime();
        this.theAnimationPlayerManager.time(currentTime);
        for (Object e : this.ere.getPlayableEngines()) {
            e.play(currentTime);
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Object e;
            e = AnimationSync.getSync();
            synchronized (e) {
                this.physicsCopy();
            }
        }
        object = this.physicsRunners;
        synchronized (object) {
            for (Runnable r : this.physicsRunners) {
                Object object2;
                if (r instanceof PoisonPillRunnable) {
                    object2 = this.shutdownSync;
                    synchronized (object2) {
                        Object object3 = PhysicsSync.getSync();
                        synchronized (object3) {
                            r.run();
                        }
                    }
                }
                object2 = PhysicsSync.getSync();
                synchronized (object2) {
                    r.run();
                }
            }
            this.physicsRunners.clear();
        }
    }

    @Override
    public void processAnimationResultForRender(GLRenderContext glc) {
        super.processAnimationResultForRender(glc);
        for (CopyEmbodiment ce : this.ere.getCopyEmbodiments()) {
            ce.copy();
        }
        float[] navpos = this.glNavControl.getPosition();
        this.vjCameraTarget.setTranslation(navpos);
    }

    public void addVirtualHuman(ElckerlycVirtualHuman evh) {
        this.virtualHumanList.add(evh);
    }

    public void removeVirtualHuman(ElckerlycVirtualHuman evh) {
        this.virtualHumanList.remove(evh);
    }

    private void unloadAllVirtualHumans() {
        ArrayList<ElckerlycVirtualHuman> vhList = new ArrayList<ElckerlycVirtualHuman>();
        vhList.addAll(this.virtualHumanList);
        for (ElckerlycVirtualHuman evh : vhList) {
            this.logger.info("Disposing humanoid {}", (Object)evh.getName());
            evh.unload();
        }
    }

    @Override
    protected void disposeFrame() throws InterruptedException, InvocationTargetException {
        this.logger.info("Disposing ElckerlycEnvironment");
        this.unloadAllVirtualHumans();
        this.logger.debug("Done removing humanoids");
        super.disposeFrame();
        this.logger.debug("Done disposing ElckerlycEnvironment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reset() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.collision.emptyContactGroup();
        }
        for (ElckerlycVirtualHuman vh : this.virtualHumanList) {
            vh.getElckerlycRealizerLoader().getRealizerBridge().performBML("<bml id=\"clear\" scheduling=\"replace\"></bml>");
        }
        this.physicsClock.setMediaSeconds(0.0);
        this.renderClock.setMediaSeconds(0.0);
        this.prevTime = 0.0;
        for (Engine e : this.ere.getPlayableEngines()) {
            e.play(0.0);
        }
        this.logger.debug("Reset finished!");
    }

    class LoaderButtonListener
    implements ActionListener {
        LoaderButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JFileChooser chooser = new JFileChooser(".");
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Virtual Human Loader Specifications (.xml)";
                }
            });
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                ElckerlycEnvironment.this.addPhysicsRunner(new Runnable(){

                    @Override
                    public void run() {
                        block8: {
                            FileReader r;
                            File f = chooser.getSelectedFile();
                            if (f == null) break block8;
                            ElckerlycVirtualHuman evh = null;
                            XMLTokenizer tokenizer = null;
                            try {
                                r = new FileReader(f);
                            }
                            catch (FileNotFoundException e1) {
                                ElckerlycEnvironment.this.logger.warn("File not found; see stack trace for more info.", (Throwable)e1);
                                return;
                            }
                            try {
                                evh = new ElckerlycVirtualHuman();
                                tokenizer = new XMLTokenizer((Reader)r);
                                tokenizer.setResourceDir(f.getParent());
                            }
                            catch (XMLScanException ex) {
                                ElckerlycEnvironment.this.logger.error("Error in the XML; see stack trace for more info.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Error in the XML; see stack trace for more info.", "alert", 0);
                                    }
                                }.start();
                                evh = null;
                            }
                            catch (Exception ex) {
                                ElckerlycEnvironment.this.logger.error("Error constructing Virtual Human from specification; see stack trace for more info.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Error constructing Virtual Human from specification; see stack trace for more info.", "alert", 0);
                                    }
                                }.start();
                                evh = null;
                            }
                            if (evh != null) {
                                try {
                                    evh.load(tokenizer, f.getName().replaceAll(".xml", ""), ElckerlycEnvironment.this.environments, (SchedulingClock)new PhysicsSchedulingClock(ElckerlycEnvironment.this.physicsClock));
                                }
                                catch (Exception ex) {
                                    ElckerlycEnvironment.this.logger.error("Error constructing Virtual Human from specification; see stack trace for more info.", (Throwable)ex);
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(null, "Error constructing Virtual Human from specification; see stack trace for more info.", "alert", 0);
                                        }
                                    }.start();
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    class PhysCallback
    implements PhysicsCallback {
        PhysCallback() {
        }

        public void time(float timeDiff) {
            if (ElckerlycEnvironment.this.runphysics) {
                if (ElckerlycEnvironment.this.collisionEnabled) {
                    ElckerlycEnvironment.this.collision.collide((Space)ElckerlycEnvironment.this.space);
                    ElckerlycEnvironment.this.collision.applyContacts();
                }
                ElckerlycEnvironment.this.phworld.step(timeDiff);
            }
        }
    }
}

