/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.VJoint;
import hmi.elckerlyc.world.WorldObject;
import hmi.environment.ElckerlycEnvironment;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.geometry.BoxGeometry;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycDemo
extends ElckerlycEnvironment {
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycDemo.class.getName());
    private VGLNode boxNode;
    private VGLNode boxNode2;
    private VJoint boxAni;
    private VJoint boxAni2;
    private VGLNode sphereNode;
    private VJoint sphereAni;
    private static final float[] boxDiffuse = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] boxSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] boxAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] boxEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] sphereDiffuse = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
    private static final float[] sphereSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] sphereAmbient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] sphereEmission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] box2Diffuse = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] box2Specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] box2Ambient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] box2Emission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};

    public static void main(String[] arg) {
        System.setProperty("sun.java2d.noddraw", "true");
        ElckerlycDemo env = new ElckerlycDemo(){

            @Override
            protected void initQuickSettings() {
                this.frameTitle = "Elckerlyc - BML Realizer demo";
                this.useVsync = true;
                this.laptop = false;
                this.collisionEnabled = false;
                this.fullscreen = false;
                this.wowvx = false;
            }
        };
        env.init();
        env.initDemoScene();
        env.startAll();
        try {
            env.loadVirtualHuman("Humanoids/armandia/", "testvhloader.xml", "Armandia -- Default version");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void physicsTime(double currentTime) {
        super.physicsTime(currentTime);
        float speed = 1.0f;
        this.sphereAni.setTranslation(0.75f + (float)Math.sin(currentTime * (double)speed) * 1.5f, (float)Math.cos(currentTime * (double)speed) * 1.0f + 1.5f, 0.5f);
    }

    protected void initDemoScene() {
        this.boxNode = new VGLNode("box");
        GLShape boxShape = new GLShape();
        BoxGeometry boxGeometry = new BoxGeometry(0.05f, 0.05f, 0.05f);
        boxShape.addGLGeometry((GLRenderObject)boxGeometry);
        GLMaterial boxState = new GLMaterial();
        boxState.setDiffuseColor(boxDiffuse);
        boxState.setSpecularColor(boxSpecular);
        boxState.setAmbientColor(boxAmbient);
        boxState.setEmissionColor(boxEmission);
        boxState.setShininess(15.0f);
        boxShape.addGLState((GLRenderObject)new GLFill());
        boxShape.addGLState((GLRenderObject)new NoTexture2DState());
        boxShape.addGLState((GLRenderObject)boxState);
        this.boxNode.addGLShape(boxShape);
        this.boxNode.getRoot().setTranslation(-0.25f, 1.45f, 0.3f);
        this.boxAni = this.boxNode.getRoot().masterCopyTree("master-");
        this.vjWorldRenderRoot.addChild(this.boxNode.getRoot());
        this.vjWorldAnimationRoot.addChild(this.boxAni);
        this.addVisualisation(this.boxNode);
        this.ae.getWorldObjectManager().addWorldObject("bluebox", new WorldObject(this.boxAni));
        this.boxNode2 = new VGLNode("box2");
        GLShape boxShape2 = new GLShape();
        BoxGeometry boxGeometry2 = new BoxGeometry(0.05f, 0.05f, 0.05f);
        boxShape2.addGLGeometry((GLRenderObject)boxGeometry2);
        GLMaterial boxState2 = new GLMaterial();
        boxState2.setDiffuseColor(box2Diffuse);
        boxState2.setSpecularColor(box2Specular);
        boxState2.setAmbientColor(box2Ambient);
        boxState2.setEmissionColor(box2Emission);
        boxState2.setShininess(15.0f);
        boxShape2.addGLState((GLRenderObject)new GLFill());
        boxShape2.addGLState((GLRenderObject)new NoTexture2DState());
        boxShape2.addGLState((GLRenderObject)boxState2);
        this.boxNode2.addGLShape(boxShape2);
        this.boxNode2.getRoot().setTranslation(-2.5f, 3.0f, 0.5f);
        this.boxAni2 = this.boxNode2.getRoot().masterCopyTree("master-");
        this.vjWorldRenderRoot.addChild(this.boxNode2.getRoot());
        this.vjWorldAnimationRoot.addChild(this.boxAni2);
        this.addVisualisation(this.boxNode2);
        this.ae.getWorldObjectManager().addWorldObject("redbox", new WorldObject(this.boxAni2));
        this.sphereNode = new VGLNode("sphere");
        GLShape sphereShape = new GLShape();
        SphereGeometry sphereGeometry = new SphereGeometry(0.1f, 10, 10);
        sphereShape.addGLGeometry((GLRenderObject)sphereGeometry);
        GLMaterial sphereState = new GLMaterial();
        sphereState.setDiffuseColor(sphereDiffuse);
        sphereState.setSpecularColor(sphereSpecular);
        sphereState.setAmbientColor(sphereAmbient);
        sphereState.setEmissionColor(sphereEmission);
        sphereState.setShininess(15.0f);
        sphereShape.addGLState((GLRenderObject)new GLFill());
        sphereShape.addGLState((GLRenderObject)new NoTexture2DState());
        sphereShape.addGLState((GLRenderObject)sphereState);
        this.sphereNode.addGLShape(sphereShape);
        this.sphereNode.getRoot().setTranslation(1.5f, 0.2f, 2.0f);
        this.sphereAni = this.sphereNode.getRoot().masterCopyTree("master-");
        this.vjWorldRenderRoot.addChild(this.sphereNode.getRoot());
        this.vjWorldAnimationRoot.addChild(this.sphereAni);
        this.addVisualisation(this.sphereNode);
        this.ae.getWorldObjectManager().addWorldObject("greensphere", new WorldObject(this.sphereAni));
    }

    @Override
    public void reset() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                ElckerlycDemo.this.physicsClock.setMediaSeconds(0.0);
                ElckerlycDemo.this.prevTime = 0.0;
            }
        });
    }
}

