/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.bridge.emitters;

import hmi.animation.VJoint;
import hmi.bml.bridge.RealizerBridge;
import hmi.math.Vec3f;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GazeEmitter
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)GazeEmitter.class.getName());
    private GazePattern activeGazeBehavior = GazePattern.AUTOGAZE_NONE;
    RealizerBridge realizerBridge = null;
    protected String randomTargetName = "randomgazetarget";
    protected VJoint vjRandomTarget = null;
    protected String userTargetName = "usergazetarget";
    protected VJoint vjUserTarget = null;
    protected VJoint vjXuukTarget = null;
    private long lastmove = 0L;
    private double currentwaitingtime = 0.0;
    private boolean parameterschanged = false;
    boolean userGazeDynamic = false;
    boolean running = true;
    private double averagewaitingtime = 5.0;
    private double range = 3.0;
    private float trackingDistanceLimit = 0.01f;
    private float z = 3.0f;
    private float minX = -1.5f;
    private float maxX = 1.5f;
    private float minY = 1.0f;
    private float maxY = 3.0f;
    private int lastgazeblock = 0;
    private static HashMap<String, GazeEmitter> allGazeEmitters = new HashMap();

    public static GazeEmitter getGazeEmitter(String id) {
        return allGazeEmitters.get(id);
    }

    public GazeEmitter(RealizerBridge rb, String id) {
        this.realizerBridge = rb;
        allGazeEmitters.put(id, this);
    }

    public void setXuukTarget(VJoint xj) {
        this.vjXuukTarget = xj;
    }

    public void setRandomTarget(VJoint rj, String targetName) {
        this.vjRandomTarget = rj;
        this.randomTargetName = targetName;
    }

    public void setUserTarget(VJoint uj, String targetName) {
        this.vjUserTarget = uj;
        this.userTargetName = targetName;
    }

    @Override
    public void run() {
        this.lastmove = System.currentTimeMillis();
        while (this.running) {
            long now = System.currentTimeMillis();
            if (!this.running) break;
            if (this.parameterschanged) {
                this.setWaitForNextEmitGaze();
            }
            if ((double)(now - this.lastmove) >= this.currentwaitingtime * 1000.0) {
                this.emitGaze();
                this.setWaitForNextEmitGaze();
            }
            try {
                GazeEmitter.sleep((int)(this.currentwaitingtime * 1000.0 + (double)this.lastmove - (double)now));
            }
            catch (Exception ex) {
                this.logger.debug("Error waiting for the move: ", (Throwable)ex);
            }
        }
        this.logger.debug("Stopping GazeEmitter thread");
    }

    public void stopRunning() {
        this.running = false;
        this.interrupt();
    }

    protected void emitGaze() {
        block7: {
            float[] normX;
            float[] normU;
            block6: {
                this.lastmove = System.currentTimeMillis();
                if (this.activeGazeBehavior != GazePattern.AUTOGAZE_RANDOM) break block6;
                float relX = (float)Math.random();
                float relY = (float)Math.random();
                this.vjRandomTarget.setTranslation(new float[]{this.minX + relX * (this.maxX - this.minX), this.minY + relY * (this.maxY - this.minY), this.z});
                this.realizerBridge.performBML("<bml id=\"gazebml_" + (this.lastgazeblock + 1) + "\" scheduling=\"interrupt(gazebml_" + this.lastgazeblock + ")\"><gaze type=\"AT\" modality=\"EYES\" id=\"g1\" start=\"0\" ready=\"0.3\" dynamic=\"false\"  target=\"" + this.randomTargetName + "\"/></bml>");
                ++this.lastgazeblock;
                break block7;
            }
            if (this.activeGazeBehavior != GazePattern.AUTOGAZE_USER) break block7;
            if (this.userGazeDynamic) {
                normU = new float[3];
                normX = new float[3];
                this.vjUserTarget.getTranslation(normU);
                this.vjXuukTarget.getTranslation(normX);
                float[] dist = new float[3];
                Vec3f.sub((float[])dist, (float[])normX, (float[])normU);
                if (Vec3f.lengthSq((float[])dist) > this.trackingDistanceLimit) {
                    this.userGazeDynamic = false;
                } else {
                    float[] xp = new float[3];
                    this.vjXuukTarget.getTranslation(xp);
                    this.vjUserTarget.setTranslation(xp);
                    return;
                }
            }
            if (!this.userGazeDynamic) {
                normU = new float[3];
                normX = new float[3];
                float[] xp = new float[3];
                this.vjUserTarget.getTranslation(normU);
                this.vjXuukTarget.getTranslation(xp);
                this.vjUserTarget.setTranslation(xp);
                this.vjXuukTarget.getTranslation(normX);
                float[] dist = new float[3];
                Vec3f.sub((float[])dist, (float[])normX, (float[])normU);
                if (Vec3f.lengthSq((float[])dist) > this.trackingDistanceLimit) {
                    this.realizerBridge.performBML("<bml id=\"gazebml_" + (this.lastgazeblock + 1) + "\" scheduling=\"interrupt(gazebml_" + this.lastgazeblock + ")\"><gaze type=\"AT\" modality=\"NECK\" id=\"g1\" start=\"0\" ready=\"0.3\" dynamic=\"false\" target=\"" + this.userTargetName + "\"/></bml>");
                    ++this.lastgazeblock;
                } else {
                    this.userGazeDynamic = true;
                    this.realizerBridge.performBML("<bml id=\"gazebml_" + (this.lastgazeblock + 1) + "\" scheduling=\"interrupt(gazebml_" + this.lastgazeblock + ")\"><gaze type=\"AT\" modality=\"NECK\" id=\"g1\" start=\"0\" ready=\"0.3\" dynamic=\"true\" target=\"" + this.userTargetName + "\"/></bml>");
                    ++this.lastgazeblock;
                }
            }
        }
    }

    protected void setWaitForNextEmitGaze() {
        if (this.activeGazeBehavior == GazePattern.AUTOGAZE_RANDOM) {
            this.currentwaitingtime = Math.random() * 2.0 * this.range - this.range + this.averagewaitingtime;
        } else if (this.activeGazeBehavior == GazePattern.AUTOGAZE_USER) {
            this.currentwaitingtime = this.userGazeDynamic ? 0.05 : 0.3;
        } else if (this.activeGazeBehavior == GazePattern.AUTOGAZE_NONE) {
            this.currentwaitingtime = 1000.0;
        }
        long now = System.currentTimeMillis();
        if ((double)(now - this.lastmove) >= this.currentwaitingtime * 1000.0) {
            this.emitGaze();
            this.setWaitForNextEmitGaze();
        }
    }

    public void randomSetAvg(double w) {
        this.averagewaitingtime = w;
        this.parameterschanged = true;
        this.interrupt();
    }

    public void randomSetRange(double r) {
        this.range = r;
        this.parameterschanged = true;
        this.interrupt();
    }

    public void setGazeBehavior(GazePattern gazeBehavior) {
        if (gazeBehavior == this.activeGazeBehavior) {
            return;
        }
        this.activeGazeBehavior = gazeBehavior;
        this.parameterschanged = true;
        this.userGazeDynamic = false;
        this.currentwaitingtime = 0.0;
        if (this.activeGazeBehavior == GazePattern.AUTOGAZE_NONE) {
            this.realizerBridge.performBML("<bml id=\"gazebml_" + (this.lastgazeblock + 1) + "\" scheduling=\"interrupt(gazebml_" + this.lastgazeblock + ")\"></bml>");
            ++this.lastgazeblock;
        }
        this.interrupt();
    }

    public static enum GazePattern {
        AUTOGAZE_NONE,
        AUTOGAZE_RANDOM,
        AUTOGAZE_USER;

    }
}

