/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.AudioPlannerSpecLoader;
import hmi.environment.avatars.BMLRealizerSpecLoader;
import hmi.environment.avatars.BodySpecLoader;
import hmi.environment.avatars.FaceSpecLoader;
import hmi.environment.avatars.GestureBindingSpecLoader;
import hmi.environment.avatars.IncludeSpecLoader;
import hmi.environment.avatars.PhysicsSpecLoader;
import hmi.environment.avatars.SpecLoader;
import hmi.environment.avatars.SpeechBindingSpecLoader;
import hmi.environment.avatars.VoiceSpecLoader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class VirtualHumanSpec
extends XMLStructureAdapter {
    public static final String IMPL_VERSION = "1.0";
    private Resources specRes = null;
    private HashMap<String, HashMap<String, Object>> sections = new HashMap();
    private static final String XMLTAG = "VirtualHumanSpec";

    public VirtualHumanSpec(Resources newRes) {
        this.specRes = newRes;
    }

    public Resources getSpecResources() {
        return this.specRes;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String version = this.getRequiredAttribute("version", attrMap, tokenizer);
        if (!version.equals(IMPL_VERSION)) {
            throw new RuntimeException("Cannot read VHSpecs of version " + version + "; required " + IMPL_VERSION + ". Please implement a converter between the two...");
        }
        String resources = this.getOptionalAttribute("resources", attrMap);
        if (resources != null) {
            this.specRes = new Resources(resources);
        }
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            SpecLoader specLoader = this.getLoader(tag);
            if (specLoader == null) {
                throw new XMLScanException("Cannot find SpecLoader for " + tag + " element");
            }
            specLoader.readXML(tokenizer);
        }
    }

    SpecLoader getLoader(String type) {
        SpecLoader result = null;
        if (type.equals(IncludeSpecLoader.xmlTag())) {
            result = new IncludeSpecLoader(this.getSpecResources());
        } else if (type.equals(GestureBindingSpecLoader.xmlTag())) {
            result = new GestureBindingSpecLoader();
        } else if (type.equals(SpeechBindingSpecLoader.xmlTag())) {
            result = new SpeechBindingSpecLoader();
        } else if (type.equals(VoiceSpecLoader.xmlTag())) {
            result = new VoiceSpecLoader();
        } else if (type.equals(BodySpecLoader.xmlTag())) {
            result = new BodySpecLoader();
        } else if (type.equals(FaceSpecLoader.xmlTag())) {
            result = new FaceSpecLoader();
        } else if (type.equals(AudioPlannerSpecLoader.xmlTag())) {
            result = new AudioPlannerSpecLoader();
        } else if (type.equals(BMLRealizerSpecLoader.xmlTag())) {
            result = new BMLRealizerSpecLoader();
        } else if (type.equals(PhysicsSpecLoader.xmlTag())) {
            result = new PhysicsSpecLoader();
        }
        if (result != null) {
            result.setVirtualHumanSpec(this);
        }
        return result;
    }

    public void addSpecParameter(String sectionName, String parameterName, Object parameterValue) {
        HashMap<String, Object> section = this.sections.get(sectionName);
        if (section == null) {
            section = new HashMap();
        }
        section.put(parameterName, parameterValue);
        this.sections.put(sectionName, section);
    }

    public Object getSpecParameter(String sectionName, String parameterName, Object defaultValue) {
        Object result = this.getSpecParameter(sectionName, parameterName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public Object getSpecParameter(String sectionName, String parameterName) {
        HashMap<String, Object> section = this.sections.get(sectionName);
        if (section == null) {
            return null;
        }
        return section.get(parameterName);
    }

    public boolean canReadSpecType(String tag) {
        return tag.equals(VirtualHumanSpec.xmlTag());
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

