/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.SpecLoader;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PhysicsSpecLoader
extends SpecLoader {
    private static final String XMLTAG = "PhysicsSpec";

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String resourcesPath = this.getOptionalAttribute("resources", attrMap, "");
        this.getVirtualHumanSpec().addSpecParameter("physics", "resourcepath", resourcesPath);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            this.readElement(tag, tokenizer);
        }
    }

    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        if (tag.equals("PhysicalModel")) {
            String filename = this.getRequiredAttribute("filename", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("physics", "physicalmodel", filename);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("MixedSystems")) {
            boolean autocreate = this.getOptionalBooleanAttribute("autocreate", attrMap, false);
            if (autocreate) {
                this.getVirtualHumanSpec().addSpecParameter("physics", "autocreatemixedsystems", true);
                tokenizer.skipTag();
            } else {
                tokenizer.takeSTag(tag);
                ArrayList<String> mixedsystems = new ArrayList<String>();
                ArrayList<String> mixedsystemnames = new ArrayList<String>();
                while (tokenizer.atSTag()) {
                    String mstag = tokenizer.getTagName();
                    if (mstag.equals("MixedSystem")) {
                        HashMap msattrMap = tokenizer.getAttributes();
                        String filename = this.getRequiredAttribute("filename", msattrMap, tokenizer);
                        String name = this.getOptionalAttribute("name", msattrMap);
                        mixedsystems.add(filename);
                        mixedsystemnames.add(name);
                        tokenizer.takeSTag(mstag);
                        tokenizer.takeETag(mstag);
                        continue;
                    }
                    throw new XMLScanException("Unknown element type in MixedSystems: " + mstag);
                }
                this.getVirtualHumanSpec().addSpecParameter("physics", "mixedsystems", mixedsystems);
                this.getVirtualHumanSpec().addSpecParameter("physics", "mixedsystemnames", mixedsystemnames);
                tokenizer.takeETag(tag);
            }
        } else {
            throw new XMLScanException("Unknown element type in PhysicsSpec: " + tag);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

