/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.SpecLoader;
import hmi.environment.avatars.VirtualHumanSpec;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.Reader;
import java.util.HashMap;

public class IncludeSpecLoader
extends SpecLoader {
    private Resources specRes = null;
    private static final String XMLTAG = "IncludeSpec";

    public IncludeSpecLoader(Resources res) {
        this.specRes = res;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String filename = this.getRequiredAttribute("filename", attrMap, tokenizer);
        XMLTokenizer includetokenizer = null;
        try {
            includetokenizer = new XMLTokenizer((Reader)this.specRes.getReader(filename));
            if (!includetokenizer.atSTag()) {
                throw new XMLScanException("Included Spec file should have a start tag at the start...");
            }
            String tag = includetokenizer.getTagName();
            if (!this.getVirtualHumanSpec().canReadSpecType(tag)) {
                StringBuilder stringBuilder = new StringBuilder("Spec of type \"");
                this.getVirtualHumanSpec();
                throw new XMLScanException(stringBuilder.append(VirtualHumanSpec.xmlTag()).append("\" cannot read content from an include file starting with \"").append(tag).append("\"").toString());
            }
            HashMap attrMap2 = includetokenizer.getAttributes();
            String version = this.getRequiredAttribute("version", attrMap2, includetokenizer);
            this.getVirtualHumanSpec();
            if (!version.equals("1.0")) {
                StringBuilder stringBuilder = new StringBuilder("Cannot read VHSpecs of version ").append(version).append("; required ");
                this.getVirtualHumanSpec();
                throw new RuntimeException(stringBuilder.append("1.0").append(". Please implement a converter between the two...").toString());
            }
            includetokenizer.takeSTag(tag);
            this.getVirtualHumanSpec().decodeContent(includetokenizer);
            includetokenizer.takeETag(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot include Spec with file=\"" + filename + "\": " + e);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

