/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.SpecLoader;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class DebugSpecHmiLoader
extends SpecLoader {
    private static final String XMLTAG = "DebugSpec";

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            this.readElement(tag, tokenizer);
        }
    }

    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        if (tag.equals("DebugVJoints")) {
            this.getVirtualHumanSpec().addSpecParameter("debug", "debugvjoints", true);
            String type = this.getOptionalAttribute("type", attrMap, "sphere");
            this.getVirtualHumanSpec().addSpecParameter("debug", "debugvjointstype", type);
            String offsetString = this.getOptionalAttribute("offset", attrMap, "-1 0 0");
            float[] offset = DebugSpecHmiLoader.decodeFloatArray((String)offsetString);
            this.getVirtualHumanSpec().addSpecParameter("debug", "debugvjointsoffset", offset);
        } else if (tag.equals("DebugPhysicalHuman")) {
            this.getVirtualHumanSpec().addSpecParameter("debug", "debugphysicalhuman", true);
            String offsetString = this.getOptionalAttribute("offset", attrMap, "-1 0 0");
            float[] offset = DebugSpecHmiLoader.decodeFloatArray((String)offsetString);
            this.getVirtualHumanSpec().addSpecParameter("debug", "debugphysicalhumanoffset", offset);
        } else {
            throw new XMLScanException("DebugSpec contains unknown element of type " + tag);
        }
        tokenizer.takeSTag(tag);
        tokenizer.takeETag(tag);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

