/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.animation.SkeletonPose;
import hmi.environment.avatars.SpecLoader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class BodySpecLoader
extends SpecLoader {
    private static final String XMLTAG = "BodySpec";

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            this.readElement(tag, tokenizer);
        }
    }

    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        if (tag.equals("ColladaSpec")) {
            this.readColladaSpec(tokenizer);
        } else if (tag.equals("StartPose")) {
            String resourcesPath = this.getOptionalAttribute("resources", attrMap, "");
            String startposeFilename = this.getRequiredAttribute("filename", attrMap, tokenizer);
            try {
                Resources res = new Resources(resourcesPath);
                SkeletonPose pose = new SkeletonPose(new XMLTokenizer((Reader)res.getReader(startposeFilename)));
                this.getVirtualHumanSpec().addSpecParameter("body", "startpose", pose);
            }
            catch (Exception e) {
                System.out.println("Cannot load start pose " + startposeFilename);
            }
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("StartPosition")) {
            String offsetString = this.getOptionalAttribute("offset", attrMap, "0 0 0");
            float[] offset = BodySpecLoader.decodeFloatArray((String)offsetString);
            this.getVirtualHumanSpec().addSpecParameter("body", "startposition", offset);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("StartRotation")) {
            String rotationString = this.getOptionalAttribute("rotation", attrMap, "0 1 0 0");
            float[] rotation = BodySpecLoader.decodeFloatArray((String)rotationString);
            this.getVirtualHumanSpec().addSpecParameter("body", "startrotation", rotation);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("GlueFeetToFloor")) {
            this.getVirtualHumanSpec().addSpecParameter("body", "gluefeettofloor", true);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else {
            throw new XMLScanException("Unknown element type in BodySpec: " + tag);
        }
    }

    public void readColladaSpec(XMLTokenizer tokenizer) throws IOException {
        tokenizer.takeSTag("ColladaSpec");
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            this.readColladaElement(tag, tokenizer);
        }
        tokenizer.takeETag("ColladaSpec");
    }

    public void readColladaElement(String tag, XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        if (tag.equals("ColladaIncludeDir")) {
            String path = this.getRequiredAttribute("path", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladaincludedir", path);
        } else if (tag.equals("ColladaScalingFactor")) {
            float factor = this.getRequiredFloatAttribute("factor", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladascalingfactor", new Float(factor));
        } else if (tag.equals("ColladaFile")) {
            String humanoidTypeString = this.getOptionalAttribute("type", attrMap, "Seamless").toLowerCase();
            String filename = this.getRequiredAttribute("filename", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladafilename", filename);
            if (humanoidTypeString.equals("segmented")) {
                this.getVirtualHumanSpec().addSpecParameter("body", "colladahumanoidtype", (Object)Humanoidtype.SEGMENTED);
            } else {
                this.getVirtualHumanSpec().addSpecParameter("body", "colladahumanoidtype", (Object)Humanoidtype.SEAMLESS);
            }
        } else if (tag.equals("ColladaRenamingFile")) {
            String filename = this.getRequiredAttribute("filename", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladarenamingfile", filename);
        } else {
            throw new XMLScanException("Unknown element type in ColladaSpec: " + tag);
        }
        tokenizer.takeSTag(tag);
        tokenizer.takeETag(tag);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public static enum Humanoidtype {
        SEAMLESS,
        SEGMENTED;

    }
}

