/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.VJoint;
import hmi.sensors.eyebox2.aggregate.SingleUserTrackerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XuukTargetMover
implements SingleUserTrackerListener {
    private static final Logger logger = LoggerFactory.getLogger((String)XuukTargetMover.class.getName());
    protected VJoint vjTarget = null;
    private float xuukFieldMinX = 0.5f;
    private float xuukFieldMaxX = -0.5f;
    private float xuukFieldMaxY = 0.5f;
    private float xuukFieldMinY = -0.5f;
    private float xuukFieldZ = 0.0f;
    private float xuukUserRelX = 0.0f;
    private float xuukUserRelY = 1.0f;

    public XuukTargetMover(VJoint xt) {
        this.vjTarget = xt;
    }

    public void setUserGazeTarget(float x, float y) {
        this.xuukUserRelX = x;
        this.xuukUserRelY = y;
        this.vjTarget.setTranslation(new float[]{this.xuukFieldMinX + this.xuukUserRelX * (this.xuukFieldMaxX - this.xuukFieldMinX), this.xuukFieldMinY + this.xuukUserRelY * (this.xuukFieldMaxY - this.xuukFieldMinY), this.xuukFieldZ});
    }

    public void userAppeared(float x1, float y1, float x2, float y2) {
        logger.debug("FACE FOUND (" + x1 + "," + y2 + ")");
        this.setUserGazeTarget(x1 + 0.5f * (x2 - x1), y1 + 0.5f * (y2 - y1));
    }

    public void userDisappeared() {
        logger.debug("FACE LOST");
    }

    public void userMoved(float x1, float y1, float x2, float y2) {
        logger.debug("FACE MOVED (" + x1 + "," + y2 + ")");
        this.setUserGazeTarget(x1 + 0.5f * (x2 - x1), y1 + 0.5f * (y2 - y1));
    }
}

