/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.environment.avatars.VirtualHumanSpec;
import hmi.environment.avatars.VirtualHumanSpecHmi;
import hmi.environment.avatars.VoiceSpecLoader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualHumanSpecLoaderTest {
    @Before
    public void setup() {
    }

    @After
    public void teardown() {
    }

    private String readTestFile(String filename) throws IOException {
        Resources res = new Resources("vhspectest");
        BufferedReader reader = res.getReader(filename);
        StringBuffer fileData = new StringBuffer(1000);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private boolean hasParameterValue(VirtualHumanSpec theVHSpec, String sectionName, String parameterName, Object value) {
        if (theVHSpec.getSpecParameter(sectionName, parameterName) == null) {
            return false;
        }
        return theVHSpec.getSpecParameter(sectionName, parameterName).equals(value);
    }

    private boolean hasParameterValueOfType(VirtualHumanSpec theVHSpec, String sectionName, String parameterName, String cl) {
        if (theVHSpec.getSpecParameter(sectionName, parameterName) == null) {
            return false;
        }
        try {
            return Class.forName(cl).isInstance(theVHSpec.getSpecParameter(sectionName, parameterName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void checkCorrectMorphTargets(VirtualHumanSpec spec) {
        ArrayList morphtargets = (ArrayList)spec.getSpecParameter("face", "availablemorphtargets");
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-A-2"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-E-5"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-I-6"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-U-4"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-O-3"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-P_B-8"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-Hum-19"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-Wink-20"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-yeux_NG01-1"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-F-7"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-Smile01-9"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-Pff-10"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-T_severe-11"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-T_severe02-12"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-T_dent-13"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-T_trist-14"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-T_trist02-15"));
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-HAA-16"));
    }

    private void checkSpecEqualsGenericSpec(VirtualHumanSpec spec) {
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "voice", "voicetype", (Object)VoiceSpecLoader.Voicetype.TEXT));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "bmlrealizer", "createrealizer", true));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "face", "facebinding", "hmi.elckerlyc.faceengine.facebinding.FaceBinding"));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "face", "visemebinding", "hmi.elckerlyc.faceengine.viseme.VisemeBinding"));
        this.checkCorrectMorphTargets(spec);
        float[] off = (float[])spec.getSpecParameter("body", "startposition");
        Assert.assertTrue((off[0] == 0.2f ? 1 : 0) != 0);
        Assert.assertTrue((off[1] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((off[2] == 0.0f ? 1 : 0) != 0);
        float[] rot = (float[])spec.getSpecParameter("body", "startrotation");
        Assert.assertTrue((rot[0] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[1] == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[2] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[3] == -0.2f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "gluefeettofloor", true));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "body", "startpose", "hmi.animation.SkeletonPose"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladaincludedir", "armandia/dae"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladafilename", "armandia/dae/armandia_boring_neckfix_dark_toplevel.dae"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladarenamingfile", "armandia/dae/armandia-renaming.txt"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "physics", "resourcepath", ""));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "physics", "physicalmodel", "armandia/physicalmodels/armandia_ph.xml"));
        ArrayList mixedsystems = (ArrayList)spec.getSpecParameter("physics", "mixedsystems");
        ArrayList mixedsystemnames = (ArrayList)spec.getSpecParameter("physics", "mixedsystemnames");
        Assert.assertTrue((boolean)((String)mixedsystems.get(0)).equals("armandia/mixedsystems/armandialowerbody.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(1)).equals("armandia/mixedsystems/armandialowerbodyandleftarm.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(2)).equals("armandia/mixedsystems/armandialowerbodyandrightarm.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(3)).equals("armandia/mixedsystems/armandialowerbodyarms.xml"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(0)).equals("lowerbody"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(1)).equals("lowerbodyandleftarm"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(2)).equals("lowerbodyandrightarm"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(3)).equals("lowerbodyandarms"));
    }

    private void checkSpecEqualsHmiSpec(VirtualHumanSpec spec) {
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "voice", "voicetype", (Object)VoiceSpecLoader.Voicetype.SAPI5));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "voice", "voicename", "Kate"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "bmlrealizer", "createrealizer", true));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "face", "facebinding", "hmi.elckerlyc.faceengine.facebinding.FaceBinding"));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "face", "visemebinding", "hmi.elckerlyc.faceengine.viseme.VisemeBinding"));
        ArrayList morphtargets = (ArrayList)spec.getSpecParameter("face", "availablemorphtargets");
        Assert.assertTrue((!morphtargets.contains("Body_NG-mesh-morpher-T_trist02-15") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)morphtargets.contains("Body_NG-mesh-morpher-HAA-16"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "face", "fapdeform", "armandia/mpeg4faps/armandia.xml"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "debug", "debugvjoints", true));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "debug", "debugvjointstype", "box"));
        float[] off = (float[])spec.getSpecParameter("debug", "debugvjointsoffset");
        Assert.assertTrue((off[0] == -0.5f ? 1 : 0) != 0);
        Assert.assertTrue((off[1] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((off[2] == -0.5f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "debug", "debugphysicalhuman", true));
        off = (float[])spec.getSpecParameter("debug", "debugphysicalhumanoffset");
        Assert.assertTrue((off[0] == 0.5f ? 1 : 0) != 0);
        Assert.assertTrue((off[1] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((off[2] == -0.5f ? 1 : 0) != 0);
        off = (float[])spec.getSpecParameter("body", "startposition");
        Assert.assertTrue((off[0] == 0.2f ? 1 : 0) != 0);
        Assert.assertTrue((off[1] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((off[2] == 0.0f ? 1 : 0) != 0);
        float[] rot = (float[])spec.getSpecParameter("body", "startrotation");
        Assert.assertTrue((rot[0] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[1] == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[2] == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((rot[3] == -0.2f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "gluefeettofloor", true));
        Assert.assertTrue((boolean)this.hasParameterValueOfType(spec, "body", "startpose", "hmi.animation.SkeletonPose"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladaincludedir", "armandia/dae"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladafilename", "armandia/dae/armandia_boring_neckfix_dark_toplevel.dae"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladarenamingfile", "armandia/dae/armandia-renaming.txt"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladatexturedir", "armandia/maps"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "body", "colladashaderdir", "armandia/shaders"));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "physics", "resourcepath", ""));
        Assert.assertTrue((boolean)this.hasParameterValue(spec, "physics", "physicalmodel", "armandia/physicalmodels/armandia_ph.xml"));
        ArrayList mixedsystems = (ArrayList)spec.getSpecParameter("physics", "mixedsystems");
        ArrayList mixedsystemnames = (ArrayList)spec.getSpecParameter("physics", "mixedsystemnames");
        Assert.assertTrue((boolean)((String)mixedsystems.get(0)).equals("armandia/mixedsystems/armandialowerbody.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(1)).equals("armandia/mixedsystems/armandialowerbodyandleftarm.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(2)).equals("armandia/mixedsystems/armandialowerbodyandrightarm.xml"));
        Assert.assertTrue((boolean)((String)mixedsystems.get(3)).equals("armandia/mixedsystems/armandialowerbodyarms.xml"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(0)).equals("lowerbody"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(1)).equals("lowerbodyandleftarm"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(2)).equals("lowerbodyandrightarm"));
        Assert.assertTrue((boolean)((String)mixedsystemnames.get(3)).equals("lowerbodyandarms"));
    }

    @Test
    public void testFailUnkownElement() {
        try {
            String failSpec = this.readTestFile("spec_test_fail_unknownelement.xml");
            VirtualHumanSpec spec = new VirtualHumanSpec(new Resources("vhspectest"));
            spec.readXML(failSpec);
        }
        catch (XMLScanException e) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testGenericSpec() {
        try {
            String genericSpec = this.readTestFile("spec_test_defaults_generic.xml");
            VirtualHumanSpec spec = new VirtualHumanSpec(new Resources("vhspectest"));
            spec.readXML(genericSpec);
            this.checkSpecEqualsGenericSpec(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testHmiSpecOverride() {
        try {
            String hmiSpec = this.readTestFile("spec_test_override_hmi.xml");
            VirtualHumanSpecHmi spec = new VirtualHumanSpecHmi(new Resources("vhspectest"));
            spec.readXML(hmiSpec);
            this.checkSpecEqualsHmiSpec(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

