/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.graphics.opengl.GLRenderContext;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.glu.GLU;

public class GLTextureWow {
    public int name;
    public boolean mipmap;
    public boolean smooth;
    public int origwidth;
    public int origheight;
    public int width;
    public int height;
    public int totalwidth;
    public int totalheight;
    public static final int NPOT_HARDWARE = 0;
    public static final int NPOT_STRETCH = 1;
    public static final int NPOT_PAD = 2;
    private static int npotmode = 0;

    public static int smallestPowerOfTwo(int i) {
        int ret = 1;
        while (ret < i) {
            ret <<= 1;
        }
        return ret;
    }

    public static void setNPOTMode(int mode) {
        npotmode = mode;
    }

    public GLTextureWow(GLRenderContext glc, int width, int height, boolean mipmap, boolean smooth) {
        this.initialise(glc, new int[width * height * 4], width, height, mipmap, smooth);
    }

    public GLTextureWow(GLRenderContext glc, int[] data, int width, int height, boolean mipmap, boolean smooth) {
        this.initialise(glc, data, width, height, mipmap, smooth);
    }

    void initialise(GLRenderContext glc, int[] data, int width, int height, boolean mipmap, boolean smooth) {
        int[] names = new int[1];
        glc.glGenTextures(1, names);
        this.name = names[0];
        this.origwidth = width;
        this.origheight = height;
        this.mipmap = mipmap;
        this.smooth = smooth;
        if (npotmode != 0) {
            this.totalwidth = GLTextureWow.smallestPowerOfTwo(width);
            this.totalheight = GLTextureWow.smallestPowerOfTwo(height);
        } else {
            this.totalwidth = width;
            this.totalheight = height;
        }
        if (npotmode == 1) {
            this.width = this.totalwidth;
            this.height = this.totalheight;
        } else {
            this.width = width;
            this.height = height;
        }
        ByteBuffer data_padded = ByteBuffer.allocate(this.totalwidth * this.totalheight * 4);
        int i = 0;
        int y = 0;
        while (y < this.totalheight) {
            int x = 0;
            while (x < this.totalwidth) {
                int pix = 0;
                if (x < width && y < height) {
                    pix = data[i++];
                }
                data_padded.put((byte)(pix >> 16 & 0xFF));
                data_padded.put((byte)(pix >> 8 & 0xFF));
                data_padded.put((byte)(pix >> 0 & 0xFF));
                data_padded.put((byte)(pix >> 24 & 0xFF));
                ++x;
            }
            ++y;
        }
        data_padded.rewind();
        this.bind(glc);
        if (!mipmap) {
            glc.glTexImage2D(3553, 0, 6408, this.totalwidth, this.totalheight, 0, 6408, 5121, (Buffer)data_padded);
        } else {
            new GLU().gluBuild2DMipmaps(3553, 6408, this.totalwidth, this.totalheight, 6408, 5121, (Buffer)data_padded);
        }
    }

    public void free(GLRenderContext glc) {
        glc.glDeleteTextures(1, new int[]{this.name});
    }

    public void copyDepthBuffer(GLRenderContext glc, int x, int y) {
        this.bind(glc);
        glc.glCopyTexImage2D(3553, 0, 6402, x, y, this.totalwidth, this.totalheight, 0);
    }

    public void copyRenderBuffer(GLRenderContext glc, int x, int y) {
        this.bind(glc);
        glc.glCopyTexImage2D(3553, 0, 6408, x, y, this.totalwidth, this.totalheight, 0);
    }

    public void enable(GLRenderContext glc) {
        glc.glEnable(3553);
    }

    public static void enableTex(GLRenderContext glc) {
        glc.glEnable(3553);
    }

    public void disable(GLRenderContext glc) {
        glc.glDisable(3553);
    }

    public static void disableTex(GLRenderContext glc) {
        glc.glDisable(3553);
    }

    public void bind(GLRenderContext glc) {
        glc.glBindTexture(3553, this.name);
    }

    public float getMaxS() {
        return (float)this.width / (float)this.totalwidth;
    }

    public float getMaxT() {
        return (float)this.height / (float)this.totalheight;
    }

    public float getSStretch() {
        return (float)this.totalwidth / (float)this.origwidth;
    }

    public float getTStretch() {
        return (float)this.totalheight / (float)this.origheight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void writeToGL(GLRenderContext glc) {
        this.bind(glc);
        if (!this.mipmap) {
            if (this.smooth) {
                glc.glTexParameteri(3553, 10241, 9729);
                glc.glTexParameteri(3553, 10240, 9729);
            } else {
                glc.glTexParameteri(3553, 10241, 9728);
                glc.glTexParameteri(3553, 10240, 9728);
            }
        } else {
            glc.glTexParameteri(3553, 10241, 9985);
            glc.glTexParameteri(3553, 10240, 9985);
        }
        glc.glTexParameteri(3553, 10242, 10497);
        glc.glTexParameteri(3553, 10243, 10497);
    }
}

