/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.bml.feedback.BMLListener;
import hmi.environment.AbstractRealizerTest;
import hmi.environment.ElckerlycEnvironment;
import hmi.environment.avatars.HmiVirtualHuman;
import hmi.util.Resources;
import java.io.IOException;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizerTest
extends AbstractRealizerTest {
    private ElckerlycEnvironment env;
    private final Logger logger = LoggerFactory.getLogger((String)ElckerlycRealizerTest.class.getName());

    @Before
    public void setupEnvironment() throws Exception {
        this.logger.debug("Started setup");
        this.env = new ElckerlycEnvironment(){

            @Override
            protected void initQuickSettings() {
                this.frameTitle = "Elckerlyc - HMI BML Realizer Tester";
                this.useVsync = true;
                this.animateavatars = true;
                this.runphysics = true;
                this.laptop = true;
                this.collisionEnabled = false;
            }
        };
        this.env.init();
        HmiVirtualHuman vh = null;
        vh = this.env.loadVirtualHuman(new Resources("blueguy"), "spec_blueguy_hmi_sapi_WAVTTS.xml", "TestAvatar");
        this.env.startAll();
        this.realizerBridge = vh.getRealizerBridge();
        this.realizerBridge.addListeners(new BMLListener[]{this});
        this.logger.debug("Finished setup");
    }

    @After
    public void teardownEnvironment() {
        this.logger.debug("Started teardown");
        this.env.prepareDispose();
        while (!this.env.isShutdown()) {
        }
        this.logger.debug("Finished teardown");
    }

    @Test(timeout=20000L)
    public void testPreplan() throws InterruptedException, IOException {
        double DELAY = 3.0;
        String bmlString1 = this.readTestFile("runtime/bmlt/preplan/testspeech1.xml");
        String bmlString2 = this.readTestFile("runtime/bmlt/preplan/testspeechinterrupt.xml");
        String bmlString3 = this.readTestFile("runtime/bmlt/preplan/testnod.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        Thread.sleep(3000L);
        this.realizerBridge.performBML(bmlString3);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        endFeedbacks.add("bml3");
        this.waitForBMLEndFeedback(endFeedbacks);
    }

    @Test(timeout=20000L)
    public void testAppendAfter() throws InterruptedException, IOException {
        String bmlString1 = this.readTestFile("runtime/bmlt/appendafter/testspeech1.xml");
        String bmlString2 = this.readTestFile("runtime/bmlt/appendafter/testspeech2.xml");
        String bmlString3 = this.readTestFile("runtime/bmlt/appendafter/testspeech3.xml");
        String bmlString4 = this.readTestFile("runtime/bmlt/appendafter/testnodappendafter.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        this.realizerBridge.performBML(bmlString3);
        this.realizerBridge.performBML(bmlString4);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml3");
        endFeedbacks.add("bml4");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "speech1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml2", "speech1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml3", "speech1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml4", "nod1"));
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml2").timeStamp, (double)0.1);
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml2").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml3").timeStamp, (double)0.1);
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml2").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml4").timeStamp, (double)0.1);
    }

    @Test(timeout=20000L)
    public void testInterrupt() throws InterruptedException, IOException {
        String bmlString1 = this.readTestFile("runtime/testlongspeechandnod.xml");
        String bmlString2 = this.readTestFile("bmlt/testinterruptbml1.xml");
        this.realizerBridge.performBML(bmlString1);
        Thread.sleep(1000L);
        this.realizerBridge.performBML(bmlString2);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml2").timeStamp, (double)0.1);
    }

    @Test(timeout=20000L)
    public void testInterruptBehaviour() throws InterruptedException, IOException {
        String bmlString1 = this.readTestFile("runtime/bmlt/interrupt/testlongspeechandnod.xml");
        String bmlString2 = this.readTestFile("runtime/bmlt/interrupt/testspeechinterrupt.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml1").timeStamp, (double)(this.getBMLPerformanceStartFeedback((String)"bml2").timeStamp + 2.0), (double)0.1);
    }

    @Test(timeout=20000L)
    public void testInterruptBehaviour2() throws InterruptedException, IOException {
        String bmlString1 = this.readTestFile("runtime/bmlt/interruptbehavior/testlongspeechandnod.xml");
        String bmlString2 = this.readTestFile("runtime/bmlt/interruptbehavior/testspeechinterrupt.xml");
        String bmlString3 = this.readTestFile("runtime/bmlt/interruptbehavior/testinterruptionspeech.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString3);
        this.realizerBridge.performBML(bmlString2);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        endFeedbacks.add("bml3");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLSyncPointProgressFeedback((String)"bml1", (String)"speech1", (String)"s1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml3").timeStamp, (double)0.1);
    }

    @Test(timeout=50000L)
    public void testInterruptBehaviourRestart() throws InterruptedException, IOException {
        String bmlString1 = this.readTestFile("runtime/bmlt/interruptbehavior/testlongspeechandnod.xml");
        String bmlString2 = this.readTestFile("runtime/bmlt/interruptbehavior/testspeechinterrupt.xml");
        String bmlString3 = this.readTestFile("runtime/bmlt/interruptbehavior/testinterruptionspeech.xml");
        String bmlString4 = "<bml id=\"bmlrep\" scheduling=\"replace\"/>";
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString3);
        this.realizerBridge.performBML(bmlString2);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        endFeedbacks.add("bml3");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLSyncPointProgressFeedback((String)"bml1", (String)"speech1", (String)"s1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml3").timeStamp, (double)0.1);
        this.clearFeedbackLists();
        this.realizerBridge.performBML(bmlString4);
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString3);
        this.realizerBridge.performBML(bmlString2);
        endFeedbacks = new HashSet();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        endFeedbacks.add("bml3");
        endFeedbacks.add("bmlrep");
        this.waitForBMLEndFeedback(endFeedbacks);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLSyncPointProgressFeedback((String)"bml1", (String)"speech1", (String)"s1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml3").timeStamp, (double)0.1);
    }
}

