/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.bml.BMLSync;
import hmi.bml.bridge.RealizerBridge;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRealizerTest
implements BMLWarningListener,
BMLFeedbackListener,
BMLExceptionListener {
    protected RealizerBridge realizerBridge;
    protected List<BMLSyncPointProgressFeedback> feedbackProgressList;
    private List<BMLPerformanceStopFeedback> performanceStopList;
    private List<BMLPerformanceStartFeedback> performanceStartList;

    protected void clearFeedbackLists() {
        this.feedbackProgressList.clear();
        this.performanceStopList.clear();
        this.performanceStartList.clear();
    }

    protected BMLPerformanceStartFeedback getBMLPerformanceStartFeedback(String bmlId) {
        for (BMLPerformanceStartFeedback bpfs : this.performanceStartList) {
            if (!bpfs.bmlId.equals(bmlId)) continue;
            return bpfs;
        }
        return null;
    }

    protected BMLPerformanceStopFeedback getBMLPerformanceStopFeedback(String bmlId) {
        for (BMLPerformanceStopFeedback bpfs : this.performanceStopList) {
            if (!bpfs.bmlId.equals(bmlId)) continue;
            return bpfs;
        }
        return null;
    }

    protected BMLSyncPointProgressFeedback getBMLSyncPointProgressFeedback(String bmlId, String behaviorId, String syncId) {
        for (BMLSyncPointProgressFeedback fb : this.feedbackProgressList) {
            if (!fb.bmlId.equals(bmlId) || !fb.behaviorId.equals(behaviorId) || !fb.syncId.equals(syncId)) continue;
            return fb;
        }
        return null;
    }

    protected String readTestFile(String filename) throws IOException {
        this.feedbackProgressList = Collections.synchronizedList(new ArrayList());
        this.performanceStopList = Collections.synchronizedList(new ArrayList());
        this.performanceStartList = Collections.synchronizedList(new ArrayList());
        Resources res = new Resources("bmltest");
        BufferedReader reader = res.getReader(filename);
        StringBuffer fileData = new StringBuffer(1000);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    protected boolean hasBMLEndFeedback(String bmlId) {
        for (BMLPerformanceStopFeedback fb : this.performanceStopList) {
            if (!fb.bmlId.equals(bmlId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasBMLEndFeedbacks(Set<String> bmlId) {
        HashSet<String> reqId = new HashSet<String>();
        reqId.addAll(bmlId);
        for (BMLPerformanceStopFeedback fb : this.performanceStopList) {
            reqId.remove(fb.bmlId);
        }
        return reqId.isEmpty();
    }

    protected boolean hasFeedback(String bmlId, String behaviorId, String syncId) {
        for (BMLSyncPointProgressFeedback fb : this.feedbackProgressList) {
            if (!fb.bmlId.equals(bmlId) || !fb.behaviorId.equals(behaviorId) || !fb.syncId.equals(syncId)) continue;
            return true;
        }
        return false;
    }

    protected synchronized void waitForFeedback(String bmlId, String behaviorId, String syncId) throws InterruptedException {
        while (!this.hasFeedback(bmlId, behaviorId, syncId)) {
            this.wait();
        }
    }

    protected synchronized void waitForBMLEndFeedback(String bmlId) throws InterruptedException {
        while (!this.hasBMLEndFeedback(bmlId)) {
            this.wait();
        }
    }

    protected synchronized void waitForBMLEndFeedback(Set<String> bmlIds) throws InterruptedException {
        while (!this.hasBMLEndFeedbacks(bmlIds)) {
            this.wait();
        }
    }

    public synchronized void warn(BMLWarningFeedback bw) {
        this.notifyAll();
    }

    public synchronized void exception(BMLExceptionFeedback be) {
        this.notifyAll();
    }

    public synchronized void performanceStop(BMLPerformanceStopFeedback psf) {
        this.performanceStopList.add(psf);
        this.notifyAll();
    }

    public synchronized void performanceStart(BMLPerformanceStartFeedback psf) {
        this.performanceStartList.add(psf);
        this.notifyAll();
    }

    public synchronized void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.feedbackProgressList.add(spp);
        this.notifyAll();
    }

    protected void assertValidSyncTimes() {
        for (BMLSyncPointProgressFeedback fb1 : this.feedbackProgressList) {
            Assert.assertThat((String)(String.valueOf(fb1.bmlId) + ":" + fb1.behaviorId + ":" + fb1.syncId + " bml block time "), (Object)fb1.bmlBlockTime, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)));
        }
    }

    protected void assertNoDuplicateSyncs() {
        for (BMLSyncPointProgressFeedback fb1 : this.feedbackProgressList) {
            for (BMLSyncPointProgressFeedback fb2 : this.feedbackProgressList) {
                if (fb1 == fb2 || !fb1.bmlId.equals(fb2.bmlId) || !fb1.behaviorId.equals(fb2.behaviorId) || !fb1.syncId.equals(fb2.syncId)) continue;
                Assert.fail((String)("Duplicate sync in feedback: " + fb1 + "List:" + this.feedbackProgressList));
            }
        }
    }

    protected boolean hasAllBMLSyncsInBMLOrder(String bmlId, String behaviorId) {
        Object prev = null;
        BMLSync curSync = null;
        for (BMLSyncPointProgressFeedback fb : this.feedbackProgressList) {
            if (!fb.bmlId.equals(bmlId) || !fb.behaviorId.equals(behaviorId) || !BMLSync.isBMLSync((String)fb.syncId)) continue;
            curSync = BMLSync.get((String)fb.syncId);
            if (prev == null || prev.isBefore(curSync)) continue;
            return false;
        }
        return curSync == BMLSync.END;
    }

    @Test(timeout=500L)
    public void testEmptyBlock() throws IOException, InterruptedException {
        String bmlString = this.readTestFile("empty.xml");
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        Assert.assertTrue((this.performanceStartList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.performanceStopList.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSpeech() throws InterruptedException, IOException {
        String bmlString = this.readTestFile("runtime/testspeech.xml");
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        System.out.println(this.feedbackProgressList);
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "speech1"));
        Assert.assertTrue((this.performanceStartList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.performanceStopList.size() == 1 ? 1 : 0) != 0);
        this.assertNoDuplicateSyncs();
    }

    @Test
    public void testSpeech2() throws InterruptedException {
        String bmlString = "";
        try {
            bmlString = this.readTestFile("runtime/testspeech2.xml");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)false);
        }
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        System.out.println(this.feedbackProgressList);
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "speech1"));
        Assert.assertTrue((this.performanceStartList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.performanceStopList.size() == 1 ? 1 : 0) != 0);
        this.assertNoDuplicateSyncs();
    }

    @Test
    public void testSpeechNodTimedToSync() throws InterruptedException {
        String bmlString = "";
        try {
            bmlString = this.readTestFile("testspeech_nodtimedtosync.xml");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)false);
        }
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "speech1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "nod1"));
        Assert.assertTrue((this.performanceStartList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.performanceStopList.size() == 1 ? 1 : 0) != 0);
        System.out.println(this.feedbackProgressList);
        this.assertNoDuplicateSyncs();
    }

    @Test
    public void testNod() throws InterruptedException {
        String bmlString = "";
        try {
            bmlString = this.readTestFile("runtime/testnodlong.xml");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)false);
        }
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "nod1"));
        this.assertNoDuplicateSyncs();
    }

    @Test
    public void testSpeechGestures() throws InterruptedException, IOException {
        String bmlString = this.readTestFile("testspeechgestures.xml");
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        Thread.sleep(1000L);
        this.assertNoDuplicateSyncs();
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "welkom"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "g1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "relaxleft"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "transleft"));
    }

    @Test
    public void testPersistence() throws IOException, InterruptedException {
        String bmlString = this.readTestFile("runtime/testpersistence.xml");
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
        Thread.sleep(1000L);
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((long)1L, (long)this.performanceStopList.size());
        String bmlString2 = "<bml id=\"bml2\" scheduling=\"replace\"/>";
        this.realizerBridge.performBML(bmlString2);
        this.waitForBMLEndFeedback("bml2");
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "pose1"));
        this.assertValidSyncTimes();
    }

    @Test
    public void testVeryShortBehaviour() throws IOException, InterruptedException {
        String bmlString = this.readTestFile("runtime/testshortbeh.xml");
        this.realizerBridge.performBML(bmlString);
        this.waitForBMLEndFeedback("bml1");
    }

    @Test
    public void testAppend() throws InterruptedException, IOException {
        String bmlString1 = "";
        String bmlString2 = "";
        bmlString1 = this.readTestFile("runtime/testspeech.xml");
        bmlString2 = this.readTestFile("runtime/testspeechappend.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        this.waitForBMLEndFeedback("bml2");
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml1", "speech1"));
        Assert.assertTrue((boolean)this.hasAllBMLSyncsInBMLOrder("bml2", "speech1"));
        this.assertNoDuplicateSyncs();
        Assert.assertEquals((double)this.getBMLPerformanceStopFeedback((String)"bml1").timeStamp, (double)this.getBMLPerformanceStartFeedback((String)"bml2").timeStamp, (double)0.01);
        Assert.assertTrue((this.getBMLPerformanceStopFeedback((String)"bml1").timeStamp > this.getBMLPerformanceStartFeedback((String)"bml1").timeStamp ? 1 : 0) != 0);
        Assert.assertTrue((this.getBMLPerformanceStopFeedback((String)"bml2").timeStamp > this.getBMLPerformanceStartFeedback((String)"bml2").timeStamp ? 1 : 0) != 0);
    }

    @Test
    public void testAppendReplace() throws InterruptedException, IOException {
        double DELAY = 3.0;
        String bmlString1 = this.readTestFile("runtime/appendandreplace/testspeech1.xml");
        String bmlString2 = this.readTestFile("runtime/appendandreplace/testspeech2.xml");
        String bmlString3 = this.readTestFile("runtime/appendandreplace/replace.xml");
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        Thread.sleep(3000L);
        this.realizerBridge.performBML(bmlString3);
        HashSet<String> endFeedbacks = new HashSet<String>();
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        endFeedbacks.add("bml3");
        this.waitForBMLEndFeedback(endFeedbacks);
        endFeedbacks.clear();
        this.performanceStopList.clear();
        this.realizerBridge.performBML(bmlString1);
        this.realizerBridge.performBML(bmlString2);
        endFeedbacks.add("bml1");
        endFeedbacks.add("bml2");
        this.waitForBMLEndFeedback(endFeedbacks);
    }
}

