/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.bml.bridge.RealizerBridge;
import hmi.bml.bridge.ui.BridgeServerUI;
import hmi.bml.bridge.ui.RealizerBridgeUI;
import hmi.elckerlyc.speechengine.TTSPlanner;
import hmi.environment.ElckerlycEnvironment;
import hmi.environment.avatars.HmiVirtualHuman;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualHumanUI
extends JFrame {
    private static Logger logger = LoggerFactory.getLogger((String)VirtualHumanUI.class.getName());
    public static final long serialVersionUID = 1L;
    JPanel contentPanel = new JPanel();
    protected JPanel buttonPanel = null;
    protected JComboBox voiceList = null;
    protected JButton reloadGestureBinding;
    protected JButton killVH;
    protected HmiVirtualHuman theVH = null;
    protected ElckerlycEnvironment demoEnv = null;

    public VirtualHumanUI(String title, HmiVirtualHuman vh, ElckerlycEnvironment elck) {
        super(title);
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
        this.contentPanel.setAlignmentX(0.0f);
        this.theVH = vh;
        this.demoEnv = elck;
        this.setLocation(650, 50);
        this.setSize(600, 500);
        this.setDefaultCloseOperation(1);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.buttonPanel.setAlignmentX(0.0f);
        if (this.theVH.getSpeechPlanner() != null) {
            if (this.theVH.getSpeechPlanner() instanceof TTSPlanner) {
                TTSPlanner ttsp = (TTSPlanner)this.theVH.getSpeechPlanner();
                this.voiceList = new JComboBox<String>(ttsp.getVoices());
                this.voiceList.setEditable(false);
                this.voiceList.setSelectedItem(this.theVH.getVirtualHumanSpec().getSpecParameter("voice", "voicename"));
                this.voiceList.addActionListener(new VoiceSelectionListener());
                this.buttonPanel.add(new JLabel("Voice:"));
                this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                this.buttonPanel.add(this.voiceList);
                this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            }
        } else {
            logger.info("No voice selection, because no ttsplanner found");
        }
        this.reloadGestureBinding = new JButton("Reload gesture binding");
        this.reloadGestureBinding.addActionListener(new ReloadGestureBindingListener());
        this.buttonPanel.add(this.reloadGestureBinding);
        this.killVH = new JButton("KILL VH");
        this.killVH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualHumanUI.this.demoEnv.addPhysicsRunner(new Runnable(){

                    @Override
                    public void run() {
                        VirtualHumanUI.this.demoEnv.unloadVirtualHuman(VirtualHumanUI.this.theVH);
                    }
                });
            }
        });
        this.buttonPanel.add(this.killVH);
        this.contentPanel.add(this.buttonPanel);
        this.contentPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (this.theVH.getRealizerBridge() != null) {
            JPanel realizerPanel = new JPanel();
            realizerPanel.setLayout(new BoxLayout(realizerPanel, 3));
            realizerPanel.setAlignmentX(0.0f);
            RealizerBridge bridge = this.theVH.getRealizerBridge();
            realizerPanel.add((Component)new RealizerBridgeUI(bridge));
            BridgeServerUI bsui = null;
            bsui = this.theVH.getRealizerServer() != null ? new BridgeServerUI(bridge, ((Integer)this.theVH.getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverbmlport", 7500)).intValue(), ((Integer)this.theVH.getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverfeedbackport", 7500)).intValue(), this.theVH.getRealizerServer()) : new BridgeServerUI(bridge, ((Integer)this.theVH.getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverbmlport", 7500)).intValue(), ((Integer)this.theVH.getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverfeedbackport", 7500)).intValue());
            bsui.setAlignmentX(0.0f);
            realizerPanel.add((Component)bsui);
            this.contentPanel.add(realizerPanel);
        }
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(this.contentPanel);
    }

    public void pullThePlug() {
        this.setDefaultCloseOperation(2);
        WindowEvent wev = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    class ReloadGestureBindingListener
    implements ActionListener {
        ReloadGestureBindingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                VirtualHumanUI.this.theVH.reloadGestureBinding();
            }
            catch (Exception ex) {
                logger.warn("Could not reload gesture binding; see stack trace for more info.\n", (Throwable)ex);
                JOptionPane.showOptionDialog(null, "Could not reload gesture binding; see stack trace for more info.", "Error loading gesture binding", 2, 0, null, null, null);
            }
            logger.debug("Gesturebinding reloaded.\n");
        }
    }

    class VoiceSelectionListener
    implements ActionListener {
        VoiceSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualHumanUI.this.theVH.setVoice((String)VirtualHumanUI.this.voiceList.getSelectedItem());
        }
    }
}

