/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.bml.bridge.emitters.BlinkEmitter;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.faceengine.AutoBehaviourCallback;
import hmi.elckerlyc.faceengine.BlinkModelChangeFU;
import hmi.elckerlyc.faceengine.GazePatternChangeFU;
import hmi.environment.bridge.emitters.GazeEmitter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmiEnvironmentAutoBehaviourCallback
extends AutoBehaviourCallback {
    private static final Logger logger = LoggerFactory.getLogger((String)HmiEnvironmentAutoBehaviourCallback.class.getName());
    private BlinkEmitter theBlinkEmitter = null;
    private GazeEmitter theGazeEmitter = null;

    public HmiEnvironmentAutoBehaviourCallback(BlinkEmitter be, GazeEmitter ge) {
        this.theBlinkEmitter = be;
        this.theGazeEmitter = ge;
    }

    public void callback(String autoclass, HashMap<String, String> parameters) throws PlayException {
        if (autoclass.equals(BlinkModelChangeFU.class.getName())) {
            if (this.theBlinkEmitter == null) {
                throw new PlayException("No Blink Emitter present");
            }
            this.theBlinkEmitter.basicMethodSetAvg((double)Float.parseFloat(parameters.get("averagewaitingtime")));
            this.theBlinkEmitter.basicMethodSetRange((double)Float.parseFloat(parameters.get("range")));
        } else if (autoclass.equals(GazePatternChangeFU.class.getName()) && this.theGazeEmitter != null) {
            if (this.theGazeEmitter == null) {
                throw new PlayException("No Blink Emitter present");
            }
            this.theGazeEmitter.randomSetAvg(Float.parseFloat(parameters.get("averagewaitingtime")));
            this.theGazeEmitter.randomSetRange(Float.parseFloat(parameters.get("range")));
            String type = parameters.get("type");
            if (type.equals("AUTOGAZE_USER")) {
                this.theGazeEmitter.setGazeBehavior(GazeEmitter.GazePattern.AUTOGAZE_USER);
            } else if (type.equals("AUTOGAZE_NONE")) {
                this.theGazeEmitter.setGazeBehavior(GazeEmitter.GazePattern.AUTOGAZE_NONE);
            } else if (type.equals("AUTOGAZE_RANDOM")) {
                this.theGazeEmitter.setGazeBehavior(GazeEmitter.GazePattern.AUTOGAZE_RANDOM);
            }
        }
    }
}

