/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.bml.bridge.TCPIPRealizerBridgeServer;
import hmi.debug.animation.VJointDebugVisualisations;
import hmi.debug.physics.PhysicsDebugVisualisations;
import hmi.elckerlyc.animationengine.AnimationPlayerManager;
import hmi.elckerlyc.animationengine.PhysicsCallback;
import hmi.elckerlyc.faceengine.AutoBehaviourCallback;
import hmi.elckerlyc.scheduler.PhysicsSchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.world.WorldObject;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.environment.HmiEnvironmentAutoBehaviourCallback;
import hmi.environment.PhysicalEnvironment;
import hmi.environment.VirtualHumanUI;
import hmi.environment.XuukTargetMover;
import hmi.environment.avatars.GenericVirtualWorld;
import hmi.environment.avatars.HmiVirtualHuman;
import hmi.environment.avatars.HmiVirtualHumanBuilder;
import hmi.environment.avatars.VirtualHumanBuilderException;
import hmi.environment.avatars.VirtualHumanSpecHmi;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicsSync;
import hmi.physics.ode.OdeHumanoid;
import hmi.sensors.eyebox2.aggregate.SingleUserTracker;
import hmi.sensors.eyebox2.aggregate.SingleUserTrackerListener;
import hmi.sensors.eyebox2.directaccess.XuukReader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.odejava.Space;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycEnvironment
extends PhysicalEnvironment {
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycEnvironment.class.getName());
    public boolean animateavatars = true;
    public boolean playvoices = true;
    GenericVirtualWorld theVirtualWorld = new GenericVirtualWorld();
    protected VJoint vjXuukTarget;
    protected VJoint vjCameraTarget;
    protected XuukTargetMover xuukTargetMover = null;
    protected VJoint vjMixedDynamicsAnimationRoot;
    protected VJoint vjNextMixedDynamicsRoot;
    protected VJoint vjCurrentMixedDynamicsRoot;
    protected VJoint vjPreviousMixedDynamicsRoot;
    protected VJoint vjPredictorMixedDynamicsRoot;
    protected AnimationPlayerManager theAnimationPlayerManager = null;
    protected ArrayList<HmiVirtualHuman> virtualHumanList = new ArrayList();
    protected HashMap<HmiVirtualHuman, JButton> vhUIToggleButtons = new HashMap();
    protected HashMap<HmiVirtualHuman, VirtualHumanUI> vhUIs = new HashMap();
    protected XuukReader xuukReader = null;

    public GenericVirtualWorld getVirtualWorld() {
        return this.theVirtualWorld;
    }

    public ElckerlycEnvironment(WorldObjectManager wom) {
        this.theVirtualWorld.setWorldObjectManager(wom);
    }

    public ElckerlycEnvironment() {
    }

    @Override
    public void init() {
        this.logger.debug("Initializing ElckerlycEnvironment");
        super.init();
        this.initMixedAnimation();
        this.initVoiceSystem();
    }

    @Override
    protected void initUI() {
        super.initUI();
        JButton loadVH = new JButton("Load VH");
        loadVH.addActionListener(new LoadVHListener());
        this.toolBar.add(loadVH);
    }

    @Override
    protected void initGraphicScene() {
        super.initGraphicScene();
        this.vjCameraTarget = new VJoint("camera");
        this.vjWorldAnimationRoot.addChild(this.vjCameraTarget);
        if (this.getVirtualWorld().getWorldObjectManager() != null) {
            this.getVirtualWorld().getWorldObjectManager().addWorldObject("camera", new WorldObject(this.vjCameraTarget));
        }
        this.vjXuukTarget = new VJoint("xuuktarget");
        this.vjCameraTarget.addChild(this.vjXuukTarget);
        this.vjXuukTarget.setTranslation(new float[]{0.0f, 0.0f, 0.0f});
        this.xuukTargetMover = new XuukTargetMover(this.vjXuukTarget);
    }

    public void setXuukReader(XuukReader xr) {
        new SingleUserTracker(xr).addListener((SingleUserTrackerListener)this.xuukTargetMover);
        this.xuukReader = xr;
    }

    protected void initMixedAnimation() {
        this.vjMixedDynamicsAnimationRoot = new VJoint("Mixed dynamic animation root");
        this.vjWorldAnimationRoot.addChild(this.vjMixedDynamicsAnimationRoot);
        this.vjNextMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.cloneTree();
        this.vjCurrentMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.cloneTree();
        this.vjPreviousMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.cloneTree();
        this.vjPredictorMixedDynamicsRoot = this.vjMixedDynamicsAnimationRoot.cloneTree();
        this.theAnimationPlayerManager = new AnimationPlayerManager((PhysicsCallback)new PhysCallback(), this.vjMixedDynamicsAnimationRoot, this.vjCurrentMixedDynamicsRoot);
    }

    @Override
    protected void initQuickSettings() {
        this.frameTitle = "Elckerlyc - HMI Virtual Human Environment";
    }

    protected void initVoiceSystem() {
    }

    @Override
    protected void initWorldPhysics() {
        super.initWorldPhysics();
        this.theVirtualWorld.setCollision(this.collision);
        this.theVirtualWorld.setSpace(this.space);
        this.theVirtualWorld.setWorld(this.phworld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void physicsTime(double currentTime) {
        this.playVoices(currentTime);
        this.playAudio(currentTime);
        this.prevTime = this.theAnimationPlayerManager.getPrevTime();
        for (HmiVirtualHuman vh : this.virtualHumanList) {
            if (vh.getFacePlanner() != null) {
                vh.getFacePlanner().getFacePlayer().play(currentTime);
            }
            vh.getInterruptPlanner().getInterruptPlayer().play(currentTime);
            vh.getWaitPlanner().getWaitPlayer().play(currentTime);
        }
        if (this.animateavatars) {
            this.theAnimationPlayerManager.time(currentTime);
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                this.physicsCopy();
            }
            object2 = this.physicsRunners;
            synchronized (object2) {
                for (Runnable r : this.physicsRunners) {
                    r.run();
                }
                this.physicsRunners.clear();
            }
        }
    }

    protected void playAudio(double currentTime) {
        for (HmiVirtualHuman vh : this.virtualHumanList) {
            if (vh.getAudioPlanner() == null) continue;
            vh.getAudioPlanner().getAudioPlayer().play(currentTime);
        }
    }

    protected void playVoices(double currentTime) {
        if (this.playvoices) {
            for (HmiVirtualHuman vh : this.virtualHumanList) {
                if (vh.getSpeechPlanner() == null) continue;
                vh.getSpeechPlanner().getVerbalPlayer().play(currentTime);
            }
        }
    }

    @Override
    public void processAnimationResultForRender(GLRenderContext glc) {
        super.processAnimationResultForRender(glc);
        for (HmiVirtualHuman vh : this.virtualHumanList) {
            try {
                vh.getGLScene().doMorph();
            }
            catch (Exception e) {
                this.logger.warn("Error morphing face: ", (Throwable)e);
                e.printStackTrace();
            }
            if (vh.getFacePlanner() != null && vh.getFacePlanner().getFacePlayer() != null && vh.getFacePlanner().getFacePlayer().getFaceController() != null) {
                vh.getFacePlanner().getFacePlayer().getFaceController().copy();
            }
            vh.getGLScene().deform();
        }
        float[] navpos = this.glNavControl.getPosition();
        this.vjCameraTarget.setTranslation(navpos);
    }

    @Override
    public void close() {
        this.logger.info("Closing ElckerlycEnvironment");
        this.unloadAllVirtualHumans();
        this.logger.debug("Done closing humanoids");
        super.close();
    }

    private void unloadAllVirtualHumans() {
        ArrayList<HmiVirtualHuman> vhList = new ArrayList<HmiVirtualHuman>();
        vhList.addAll(this.virtualHumanList);
        for (HmiVirtualHuman vh : vhList) {
            this.unloadVirtualHuman(vh);
        }
    }

    @Override
    protected void disposeFrame() throws InterruptedException, InvocationTargetException {
        this.logger.info("Disposing ElckerlycEnvironment");
        this.unloadAllVirtualHumans();
        this.logger.debug("Done removing humanoids");
        super.disposeFrame();
        this.logger.debug("Done disposing ElckerlycEnvironment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reset() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.collision.emptyContactGroup();
        }
        for (HmiVirtualHuman vh : this.virtualHumanList) {
            vh.getRealizerBridge().performBML("<bml id=\"clear\" scheduling=\"replace\"></bml>");
        }
        this.theAnimationPlayerManager.reset();
        this.physicsClock.setMediaSeconds(0.0);
        this.renderClock.setMediaSeconds(0.0);
        this.prevTime = 0.0;
        for (HmiVirtualHuman vh : this.virtualHumanList) {
            if (vh.getSpeechPlanner() != null) {
                vh.getSpeechPlanner().getVerbalPlayer().play(0.0);
            }
            if (vh.getAudioPlanner() == null) continue;
            vh.getAudioPlanner().getAudioPlayer().play(0.0);
        }
        this.logger.debug("Reset finished!");
    }

    public HmiVirtualHuman loadVirtualHuman(Resources res, String specFileName, String name) throws Exception {
        VirtualHumanSpecHmi spec = new VirtualHumanSpecHmi(res);
        spec.readXML(res.getReader(specFileName));
        return this.loadVirtualHuman(spec, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HmiVirtualHuman loadVirtualHuman(VirtualHumanSpecHmi spec, String name) throws VirtualHumanBuilderException {
        HmiVirtualHumanBuilder vhBuilder = new HmiVirtualHumanBuilder();
        HmiVirtualHuman vh = (HmiVirtualHuman)vhBuilder.buildVirtualHuman(spec, name + "_" + this.virtualHumanList.size(), this.theVirtualWorld, (SchedulingClock)new PhysicsSchedulingClock(this.physicsClock));
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                this.virtualHumanList.add(vh);
                this.vjMixedDynamicsAnimationRoot.addChild(vh.getAnimationRootJoint());
                this.vjWorldRenderRoot.addChild(vh.getRenderNode().getRoot());
                if (((Boolean)vh.getVirtualHumanSpec().getSpecParameter("debug", "debugvjoints", false)).booleanValue()) {
                    this.addVJointDebugVisualisations(vh);
                }
                this.vjPreviousMixedDynamicsRoot.addChild(vh.getPreviousAnimationRootJoint());
                this.vjCurrentMixedDynamicsRoot.addChild(vh.getCurrentAnimationRootJoint());
                this.vjNextMixedDynamicsRoot.addChild(vh.getNextAnimationRootJoint());
                this.vjPredictorMixedDynamicsRoot.addChild(vh.getPredictorAnimationRootJoint());
                if (((Boolean)vh.getVirtualHumanSpec().getSpecParameter("debug", "debugphysicalhuman", false)).booleanValue()) {
                    this.addPhysicalHumanDebugVisualisations(vh);
                }
                this.addVisualisation(vh.getRenderNode());
                this.theAnimationPlayerManager.addAnimationPlayer(vh.getAnimationPlanner().getAnimationPlayer());
                if (vh.getBlinkEmitter() != null) {
                    vh.getBlinkEmitter().start();
                }
                if (vh.getGazeEmitter() != null) {
                    VJoint vjRandomGazeTarget = new VJoint("randomgazetarget_" + vh.getId());
                    this.getVirtualWorld().getWorldObjectManager().addWorldObject("randomgazetarget_" + vh.getId(), new WorldObject(vjRandomGazeTarget));
                    this.vjWorldAnimationRoot.addChild(vjRandomGazeTarget);
                    vjRandomGazeTarget.setTranslation(new float[]{0.0f, 1.5f, 0.0f});
                    vh.getGazeEmitter().setRandomTarget(vjRandomGazeTarget, "randomgazetarget_" + vh.getId());
                    VJoint vjUserGazeTarget = new VJoint("usergazetarget_" + vh.getId());
                    this.getVirtualWorld().getWorldObjectManager().addWorldObject("usergazetarget_" + vh.getId(), new WorldObject(vjUserGazeTarget));
                    this.vjCameraTarget.addChild(vjUserGazeTarget);
                    vjUserGazeTarget.setTranslation(new float[]{0.0f, 0.0f, 0.0f});
                    vh.getGazeEmitter().setUserTarget(vjUserGazeTarget, "usergazetarget_" + vh.getId());
                    vh.getGazeEmitter().setXuukTarget(this.vjXuukTarget);
                    vh.getGazeEmitter().start();
                }
                AutoBehaviourCallback.setAutoBehaviourCallback((AutoBehaviourCallback)new HmiEnvironmentAutoBehaviourCallback(vh.getBlinkEmitter(), vh.getGazeEmitter()));
            }
        }
        return vh;
    }

    public void addVJointDebugVisualisations(HmiVirtualHuman vh) {
        ArrayList<VGLNode> debugRenderNodes = vh.getDebugRenderNodes();
        ArrayList<VJoint> debugRenderRootJoints = vh.getDebugRenderRootJoints();
        VGLNode debugViz = VJointDebugVisualisations.getColoredShapeDebugVisualisationTree((VJoint)vh.getAnimationRootJoint(), (String)((String)vh.getVirtualHumanSpec().getSpecParameter("debug", "debugvjointstype", "sphere")));
        debugRenderNodes.add(debugViz);
        this.addDebugVisualisation(debugViz);
        VJoint move = new VJoint();
        move.setTranslation((float[])vh.getVirtualHumanSpec().getSpecParameter("debug", "debugvjointsoffset", new float[]{0.0f, 0.0f, 0.0f}));
        move.addChild(debugViz.getRoot());
        debugRenderRootJoints.add(move);
        this.vjWorldRenderRoot.addChild(move);
        vh.setDebugRenderNodes(debugRenderNodes);
        vh.setDebugRenderRootJoints(debugRenderRootJoints);
    }

    public void addPhysicalHumanDebugVisualisations(HmiVirtualHuman vh) {
        ArrayList<VGLNode> debugRenderNodes = vh.getDebugRenderNodes();
        ArrayList<VJoint> debugRenderRootJoints = vh.getDebugRenderRootJoints();
        for (OdeHumanoid pHuman : vh.getPhysicalHumans()) {
            VGLNode debugViz = PhysicsDebugVisualisations.getPhysicalHumanDebugVisualisation((PhysicalHumanoid)pHuman);
            this.addDebugVisualisation(debugViz);
            debugRenderNodes.add(debugViz);
            VJoint move = new VJoint();
            move.setTranslation((float[])vh.getVirtualHumanSpec().getSpecParameter("debug", "debugphysicalhumanoffset", new float[]{0.0f, 0.0f, 0.0f}));
            move.addChild(debugViz.getRoot());
            debugRenderRootJoints.add(move);
            this.vjWorldRenderRoot.addChild(move);
        }
        vh.setDebugRenderNodes(debugRenderNodes);
        vh.setDebugRenderRootJoints(debugRenderRootJoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadVirtualHuman(HmiVirtualHuman vh) {
        VirtualHumanUI vhUI = this.vhUIs.get(vh);
        JButton vhUIToggleButton = this.vhUIToggleButtons.get(vh);
        TCPIPRealizerBridgeServer server = vh.getRealizerServer();
        if (server != null) {
            server.shutdown();
            this.logger.debug("Environment tries to shutdown server...");
        }
        if (vh.getBlinkEmitter() != null) {
            vh.getBlinkEmitter().stopRunning();
        }
        if (vh.getGazeEmitter() != null) {
            vh.getGazeEmitter().stopRunning();
        }
        this.virtualHumanList.remove(vh);
        if (vh.getSpeechPlanner() != null) {
            vh.getSpeechPlanner().getVerbalPlayer().cleanup();
            this.logger.debug("Speechplayer shutdown start");
            vh.getSpeechPlanner().shutdown();
            this.logger.debug("Speechplayer shutdown end");
        }
        if (vh.getAudioPlanner() != null) {
            vh.getAudioPlanner().getAudioPlayer().cleanup();
            vh.getAudioPlanner().shutdown();
        }
        this.logger.debug("Removing debug visualizations");
        for (VGLNode debugRenderNode : vh.getDebugRenderNodes()) {
            this.removeDebugVisualisation(debugRenderNode);
        }
        this.logger.debug("Finished removing debug renderNodes");
        for (VJoint debugRenderRootJoint : vh.getDebugRenderRootJoints()) {
            this.vjWorldRenderRoot.removeChild(debugRenderRootJoint);
        }
        this.logger.debug("Removing visualizations");
        this.removeVisualisation(vh.getRenderNode());
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.logger.debug("Removing from VJoint structures");
            this.vjMixedDynamicsAnimationRoot.removeChild(vh.getAnimationRootJoint());
            this.vjWorldRenderRoot.removeChild(vh.getRenderNode().getRoot());
            this.vjPreviousMixedDynamicsRoot.removeChild(vh.getPreviousAnimationRootJoint());
            this.vjCurrentMixedDynamicsRoot.removeChild(vh.getCurrentAnimationRootJoint());
            this.vjNextMixedDynamicsRoot.removeChild(vh.getNextAnimationRootJoint());
            this.vjPredictorMixedDynamicsRoot.removeChild(vh.getPredictorAnimationRootJoint());
            this.logger.debug("Removing from AnimationPlayer");
            this.theAnimationPlayerManager.removeAnimationPlayer(vh.getAnimationPlanner().getAnimationPlayer());
        }
        object = PhysicsSync.getSync();
        synchronized (object) {
            this.logger.debug("Removing from Physics");
            for (OdeHumanoid nextPH : vh.getPhysicalHumans()) {
                nextPH.clear();
            }
            vh.getFeetGlueJointGroup().empty();
            vh.getFeetGlueJointGroup().delete();
        }
        if (vhUI != null) {
            this.logger.debug("Removing VHUI");
            vhUI.setVisible(false);
            this.logger.debug("Disposing VHUI");
            vhUI.setVisible(false);
            vhUI.pullThePlug();
            this.vhUIs.remove(vh);
            this.toolBar.remove(vhUIToggleButton);
            this.vhUIToggleButtons.remove(vh);
            this.logger.debug("VHUI Removed");
        }
    }

    public void createVirtualHumanUI(HmiVirtualHuman vh) {
        if (vh.getRealizerBridge() == null) {
            System.err.println("No BML realizer available for virtual human \"" + vh.getId() + "\"");
            return;
        }
        VirtualHumanUI vhUI = new VirtualHumanUI("VH setup & enter BML \"" + vh.getId() + "\"", vh, this);
        this.vhUIs.put(vh, vhUI);
        JButton toggleVHUI = new JButton("VH setup & enter BML \"" + vh.getId() + "\"");
        toggleVHUI.addActionListener(new ToggleVHUIListener(vhUI));
        this.toolBar.add(toggleVHUI);
        this.vhUIToggleButtons.put(vh, toggleVHUI);
    }

    static class ToggleVHUIListener
    implements ActionListener {
        VirtualHumanUI theVHUI = null;

        public ToggleVHUIListener(VirtualHumanUI ui) {
            this.theVHUI = ui;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.theVHUI.isShowing()) {
                this.theVHUI.setVisible(false);
            } else {
                this.theVHUI.setVisible(true);
            }
        }
    }

    class PhysCallback
    implements PhysicsCallback {
        PhysCallback() {
        }

        public void time(float timeDiff) {
            if (ElckerlycEnvironment.this.runphysics) {
                if (ElckerlycEnvironment.this.collisionEnabled) {
                    ElckerlycEnvironment.this.collision.collide((Space)ElckerlycEnvironment.this.space);
                    ElckerlycEnvironment.this.collision.applyContacts();
                }
                ElckerlycEnvironment.this.phworld.step(timeDiff);
            }
        }
    }

    class LoadVHListener
    implements ActionListener {
        LoadVHListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JFileChooser chooser = new JFileChooser(".");
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Virtual Human Specifications (.xml)";
                }
            });
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                ElckerlycEnvironment.this.addPhysicsRunner(new Runnable(){

                    @Override
                    public void run() {
                        File f = chooser.getSelectedFile();
                        if (f != null) {
                            FileReader r;
                            try {
                                r = new FileReader(f);
                            }
                            catch (FileNotFoundException e1) {
                                ElckerlycEnvironment.this.logger.warn("File not found; see stack trace for more info.", (Throwable)e1);
                                return;
                            }
                            try {
                                VirtualHumanSpecHmi spec = new VirtualHumanSpecHmi(new Resources(""));
                                spec.readXML(r);
                                try {
                                    HmiVirtualHuman vh = ElckerlycEnvironment.this.loadVirtualHuman(spec, "new");
                                    ElckerlycEnvironment.this.createVirtualHumanUI(vh);
                                }
                                catch (VirtualHumanBuilderException ex) {
                                    ElckerlycEnvironment.this.logger.error("Error constructing Virtual Human from specification; see stack trace for more info.", (Throwable)ex);
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(null, "Error constructing Virtual Human from specification; see stack trace for more info.", "alert", 0);
                                        }
                                    }.start();
                                }
                            }
                            catch (IOException ex) {
                                ElckerlycEnvironment.this.logger.error("Error reading file; see stack trace for more info.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Error reading file; see stack trace for more info.", "alert", 0);
                                    }
                                }.start();
                            }
                            catch (XMLScanException ex) {
                                ElckerlycEnvironment.this.logger.error("Error in the XML; see stack trace for more info.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Error in the XML; see stack trace for more info.", "alert", 0);
                                    }
                                }.start();
                            }
                            try {
                                r.close();
                            }
                            catch (IOException e1) {
                                ElckerlycEnvironment.this.logger.warn("Error closing file; see stack trace for more info.", (Throwable)e1);
                            }
                        }
                    }
                });
            }
        }
    }
}

