/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.bml.BMLGestureSync;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.ListFeedbackListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.FeedbackManagerImpl;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.testutil.bml.feedback.FeedbackAsserts;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public abstract class AbstractTimedPlanUnitTest {
    protected List<BMLSyncPointProgressFeedback> fbList = new ArrayList<BMLSyncPointProgressFeedback>();
    protected BMLBlockManager mockBlockManager = (BMLBlockManager)PowerMockito.mock(BMLBlockManager.class);
    protected FeedbackManager fbManager = new FeedbackManagerImpl(this.mockBlockManager, "character1");

    protected abstract TimedPlanUnit setupPlanUnit(FeedbackManager var1, BMLBlockPeg var2, String var3, String var4, double var5);

    protected TimedPlanUnit setupPlanUnitWithListener(BMLBlockPeg bbPeg, String id, String bmlId, double startTime) {
        TimedPlanUnit tpu = this.setupPlanUnit(this.fbManager, bbPeg, id, bmlId, startTime);
        this.fbManager.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(this.fbList));
        return tpu;
    }

    protected void assertSubsiding(TimedPlanUnit tpu) {
        Assert.assertEquals((Object)TimedPlanUnitState.SUBSIDING, (Object)tpu.getState());
    }

    @Test
    public void testFeedback() {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        BMLSyncPointProgressFeedback expected = new BMLSyncPointProgressFeedback("bml1", "beh1", "stroke", 0.0, 0.0);
        tpu.feedback(expected);
        FeedbackAsserts.assertOneFeedback((BMLSyncPointProgressFeedback)expected, this.fbList);
    }

    @Test
    public void testSetup() {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        Assert.assertEquals((double)0.0, (double)tpu.getStartTime(), (double)1.0E-4f);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_PREP, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testPlayInPrep() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.play(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_PREP, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStopInPrep() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.stop(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.DONE, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStartInPrep() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.start(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_PREP, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testPlayInPending() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.PENDING);
        tpu.play(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.PENDING, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStartInPending() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.PENDING);
        tpu.start(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.PENDING, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStopInPending() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.PENDING);
        tpu.stop(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.DONE, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testPlayInLurking() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.play(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.LURKING, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStopInLurking() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.stop(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.DONE, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testStartInLurking() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.start(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_EXEC, (Object)tpu.getState());
    }

    @Test
    public void testStartThenPlayInLurking() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.start(0.0);
        tpu.play(0.0);
        MatcherAssert.assertThat((Object)tpu.getState(), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)TimedPlanUnitState.SUBSIDING), Matchers.equalTo((Object)TimedPlanUnitState.IN_EXEC), Matchers.equalTo((Object)TimedPlanUnitState.DONE)}));
        BMLSyncPointProgressFeedback expected = new BMLSyncPointProgressFeedback("bml1", "id1", "start", 0.0, 0.0);
        FeedbackAsserts.assertEqualSyncPointProgress((BMLSyncPointProgressFeedback)expected, (BMLSyncPointProgressFeedback)this.fbList.get(0));
    }

    @Test
    public void testPlayInExec() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.start(0.0);
        tpu.play(0.0);
        tpu.play(0.0);
        MatcherAssert.assertThat((Object)tpu.getState(), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)TimedPlanUnitState.SUBSIDING), Matchers.equalTo((Object)TimedPlanUnitState.IN_EXEC), Matchers.equalTo((Object)TimedPlanUnitState.DONE)}));
    }

    @Test
    public void testStartInExec() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        tpu.setState(TimedPlanUnitState.IN_EXEC);
        tpu.start(0.0);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_EXEC, (Object)tpu.getState());
        MatcherAssert.assertThat(this.fbList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testSetStrokePeg() {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        TimePeg strokePeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        strokePeg.setGlobalValue(2.0);
        tpu.setTimePeg(BMLGestureSync.STROKE.getId(), strokePeg);
        Assert.assertEquals((double)2.0, (double)tpu.getTime(BMLGestureSync.STROKE.getId()), (double)1.0E-4f);
    }

    @Test
    public void testSubsiding() throws TimedPlanUnitPlayException {
        TimedPlanUnit tpu = this.setupPlanUnitWithListener(BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0);
        TimePeg relaxPeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        relaxPeg.setGlobalValue(2.0);
        tpu.setTimePeg(BMLGestureSync.RELAX.toString(), relaxPeg);
        tpu.setState(TimedPlanUnitState.LURKING);
        tpu.start(0.0);
        tpu.play(2.1);
        this.assertSubsiding(tpu);
    }
}

