/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.StubPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractTimedPlanUnitPlayerTest {
    protected FeedbackManager mockFeedbackManager = (FeedbackManager)Mockito.mock(FeedbackManager.class);
    protected TimedPlanUnitPlayer tpp;

    protected abstract TimedPlanUnitPlayer createTimedPlanUnitPlayer();

    @Before
    public void setup() {
        this.tpp = this.createTimedPlanUnitPlayer();
    }

    @Test
    public void testPlayUnit() throws InterruptedException {
        StubPlanUnit stubUnit = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        stubUnit.setState(TimedPlanUnitState.LURKING);
        this.tpp.playUnit((TimedPlanUnit)stubUnit, 0.0);
        Thread.sleep(100L);
        Assert.assertEquals((Object)TimedPlanUnitState.IN_EXEC, (Object)stubUnit.getState());
    }

    @Test
    public void testPlayUnitWithException() throws InterruptedException, TimedPlanUnitPlayException {
        StubPlanUnit stubUnit = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        StubPlanUnit stubUnitSpy = (StubPlanUnit)((Object)Mockito.spy((Object)((Object)stubUnit)));
        TimedPlanUnitPlayException ex = new TimedPlanUnitPlayException("", (TimedPlanUnit)stubUnit);
        ((StubPlanUnit)((Object)Mockito.doThrow((Throwable)ex).when((Object)stubUnitSpy))).playUnit(0.0);
        stubUnitSpy.setState(TimedPlanUnitState.LURKING);
        this.tpp.playUnit((TimedPlanUnit)stubUnitSpy, 0.0);
        Thread.sleep(100L);
        Assert.assertThat((Object)this.tpp.getPlayExceptions(), (Matcher)IsIterableContainingInOrder.contains((Object[])new TimedPlanUnitPlayException[]{ex}));
        Assert.assertThat((Object)this.tpp.getStopExceptions(), (Matcher)Matchers.empty());
    }

    @Test
    public void testStopUnitWithException() throws InterruptedException, TimedPlanUnitPlayException {
        StubPlanUnit stubUnit = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0, 1.0);
        StubPlanUnit stubUnitSpy = (StubPlanUnit)((Object)Mockito.spy((Object)((Object)stubUnit)));
        TimedPlanUnitPlayException ex = new TimedPlanUnitPlayException("", (TimedPlanUnit)stubUnit);
        ((StubPlanUnit)((Object)Mockito.doThrow((Throwable)ex).when((Object)stubUnitSpy))).stopUnit(1.1);
        stubUnitSpy.setState(TimedPlanUnitState.IN_EXEC);
        this.tpp.stopUnit((TimedPlanUnit)stubUnitSpy, 1.1);
        Thread.sleep(100L);
        Assert.assertThat((Object)this.tpp.getStopExceptions(), (Matcher)IsIterableContainingInOrder.contains((Object[])new TimedPlanUnitPlayException[]{ex}));
        Assert.assertThat((Object)this.tpp.getPlayExceptions(), (Matcher)Matchers.empty());
    }

    @Test
    public void testStopUnit() throws InterruptedException {
        StubPlanUnit stubUnit = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "id1", "bml1", 0.0, 1.0);
        stubUnit.setState(TimedPlanUnitState.IN_EXEC);
        this.tpp.stopUnit((TimedPlanUnit)stubUnit, 1.1);
        Thread.sleep(100L);
        Assert.assertEquals((Object)TimedPlanUnitState.DONE, (Object)stubUnit.getState());
    }
}

