/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.StubPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractPlanPlayerTest {
    TimedPlanUnit mockPlanUnit1 = (TimedPlanUnit)Mockito.mock(TimedPlanUnit.class);
    TimedPlanUnit mockPlanUnit2 = (TimedPlanUnit)Mockito.mock(TimedPlanUnit.class);
    TimedPlanUnit mockPlanUnit3 = (TimedPlanUnit)Mockito.mock(TimedPlanUnit.class);
    protected FeedbackManager mockFeedbackManager = (FeedbackManager)Mockito.mock(FeedbackManager.class);
    protected PlanManager planManager = new PlanManager();

    protected abstract PlanPlayer createPlanPlayer();

    @Test
    public void testInterruptUnit() {
        PlanPlayer pp = this.createPlanPlayer();
        Mockito.when((Object)this.mockPlanUnit1.getEndTime()).thenReturn((Object)3.0);
        Mockito.when((Object)this.mockPlanUnit1.getBMLId()).thenReturn((Object)"bml1");
        Mockito.when((Object)this.mockPlanUnit1.getId()).thenReturn((Object)"beh1");
        Mockito.when((Object)this.mockPlanUnit2.getStartTime()).thenReturn((Object)1.0);
        Mockito.when((Object)this.mockPlanUnit2.getEndTime()).thenReturn((Object)4.0);
        Mockito.when((Object)this.mockPlanUnit2.getBMLId()).thenReturn((Object)"bml1");
        Mockito.when((Object)this.mockPlanUnit2.getId()).thenReturn((Object)"beh2");
        Mockito.when((Object)this.mockPlanUnit3.getStartTime()).thenReturn((Object)0.0);
        Mockito.when((Object)this.mockPlanUnit3.getEndTime()).thenReturn((Object)5.0);
        Mockito.when((Object)this.mockPlanUnit3.getBMLId()).thenReturn((Object)"bml2");
        Mockito.when((Object)this.mockPlanUnit3.getId()).thenReturn((Object)"beh3");
        this.planManager.addPlanUnit(this.mockPlanUnit1);
        this.planManager.addPlanUnit(this.mockPlanUnit2);
        this.planManager.addPlanUnit(this.mockPlanUnit3);
        Assert.assertEquals((long)3L, (long)this.planManager.getNumberOfPlanUnits());
        pp.interruptBehaviourBlock("bml1", 1.0);
        Assert.assertEquals((long)1L, (long)this.planManager.getNumberOfPlanUnits());
    }

    @Test
    public void testRemoveWhenDone() throws InterruptedException {
        PlanPlayer pp = this.createPlanPlayer();
        StubPlanUnit spu1 = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "bml1", "beh1", 0.0, 2.0);
        StubPlanUnit spu2 = new StubPlanUnit(this.mockFeedbackManager, BMLBlockPeg.GLOBALPEG, "bml1", "beh2", 1.0, 6.0);
        spu1.setState(TimedPlanUnitState.LURKING);
        spu2.setState(TimedPlanUnitState.LURKING);
        this.planManager.addPlanUnit((TimedPlanUnit)spu1);
        this.planManager.addPlanUnit((TimedPlanUnit)spu2);
        pp.play(1.0);
        Assert.assertEquals((long)2L, (long)this.planManager.getNumberOfPlanUnits());
        pp.play(3.0);
        Thread.sleep(400L);
        Assert.assertEquals((long)1L, (long)this.planManager.getNumberOfPlanUnits());
    }
}

