/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.core.Behaviour;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.util.TimePegUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;

public class PlannerTests {
    private final BMLBlockPeg bbPeg;
    private final Planner planner;

    public PlannerTests(Planner p, BMLBlockPeg bbPeg) {
        this.bbPeg = bbPeg;
        this.planner = p;
    }

    public void testResolveUnsetStart(Behaviour beh) throws BehaviourPlanningException {
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        TimedPlanUnit pu = this.planner.resolveSynchs(this.bbPeg, beh, sacs);
        Assert.assertEquals((double)this.bbPeg.getValue(), (double)sp.getGlobalValue(), (double)1.0E-4);
        this.planner.addBehaviour(this.bbPeg, beh, sacs, pu);
        Assert.assertEquals((double)this.bbPeg.getValue(), (double)pu.getStartTime(), (double)1.0E-4);
        if (pu.getEndTime() != -1.7976931348623157E308) {
            Assert.assertThat((Object)pu.getEndTime(), (Matcher)OrderingComparison.greaterThan((Comparable)Double.valueOf(this.bbPeg.getValue())));
        }
    }

    public void testResolveNonExistingSync(Behaviour beh) throws IOException, BehaviourPlanningException {
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg startPeg = TimePegUtil.createTimePeg(-1.7976931348623157E308);
        OffsetPeg startOffsetPeg = new OffsetPeg(startPeg, 0.0);
        sacs.add(new TimePegAndConstraint("unknown", TimePegUtil.createTimePeg(-1.7976931348623157E308), new Constraint(), 0.0, false));
        sacs.add(new TimePegAndConstraint("start", (TimePeg)startOffsetPeg, new Constraint(), 0.0, true));
        this.planner.resolveSynchs(this.bbPeg, beh, sacs);
    }

    public void testResolveStartOffset(Behaviour beh) throws IOException, BehaviourPlanningException {
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg startPeg = TimePegUtil.createTimePeg(0.0);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), -2.0, true));
        TimedPlanUnit pu = this.planner.resolveSynchs(this.bbPeg, beh, sacs);
        Assert.assertEquals((double)2.0, (double)pu.getStartTime(), (double)1.0E-4);
    }
}

