/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import com.google.common.collect.Sets;
import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.WavClipUnit;
import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWavTTSUnit
extends TimedTTSUnit {
    protected WavUnit wavUnit;
    private File tempFile;
    @GuardedBy(value="this")
    private Set<Bookmark> progressHandled = Sets.newHashSet();
    private static Logger logger = LoggerFactory.getLogger((String)TimedWavTTSUnit.class.getName());

    public TimedWavTTSUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, behClass);
    }

    public TimedWavTTSUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, SpeechBehaviour.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendProgress(double playTime, double time) {
        ArrayList<BMLSyncPointProgressFeedback> sppfs = new ArrayList<BMLSyncPointProgressFeedback>();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            for (Bookmark b : this.bookmarks) {
                if (!(playTime >= (double)b.getOffset() / 1000.0) || this.progressHandled.contains(b)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = b.getName();
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                sppfs.add(new BMLSyncPointProgressFeedback(id, this.getBMLId(), behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(b);
            }
        }
        this.feedback(sppfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        double playTime = time - this.getStartTime();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            try {
                this.wavUnit.play(playTime);
            }
            catch (WavUnitPlayException e) {
                throw new TimedPlanUnitPlayException(e.getLocalizedMessage(), this, e);
            }
        }
        this.sendProgress(playTime, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopUnit(double time) {
        logger.debug("StopTimedWavUnit {}:{}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendProgress(time - this.getStartTime(), time);
        if (time >= this.getEndTime()) {
            this.sendEndProgress(time);
        }
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            logger.debug("StopTimedWavUnit in sync block)");
            this.wavUnit.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendStartProgress(time);
        this.bmlStartTime = time;
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            if (this.wavUnit == null) {
                throw new TimedPlanUnitPlayException("null wavUnit", this);
            }
            this.wavUnit.setPlaying(true);
        }
    }

    @Override
    protected synchronized void setupCache() throws SpeechUnitPlanningException {
        try {
            try {
                this.wavUnit = new WavClipUnit(this.tempFile.toURI().toURL().openStream());
            }
            catch (WavUnitPlanningException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), this, e);
            }
        }
        catch (IOException ex) {
            throw new SpeechUnitPlanningException(ex.getLocalizedMessage(), this, ex);
        }
        finally {
            if (this.tempFile != null && !this.tempFile.delete()) {
                logger.warn("Couldn't delete temp file in WavTTSUnit: {}", (Object)this.tempFile.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TimingInfo getTiming() throws SpeechUnitPlanningException {
        String fileName = this.getBMLId() + "-" + this.getId();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            TimingInfo ti = null;
            try {
                this.tempFile = File.createTempFile(fileName, ".wav");
            }
            catch (IOException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), this, e);
            }
            try {
                ti = this.ttsBinding.speakToFile(this.getBehaviourClass(), this.speechText, this.tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), this, e);
            }
            this.progressHandled.clear();
            return ti;
        }
    }

    @Override
    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        logger.debug("TimedWavTTSUnit Setting parameter {} value {}", (Object)parameter, (Object)Float.valueOf(value));
        try {
            this.wavUnit.setParameterValue(parameter, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.wavUnit.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }
}

