/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.TTSCallback;
import hmi.tts.TimingInfo;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedDirectTTSUnit
extends TimedTTSUnit {
    private double systemStartTime;
    @GuardedBy(value="ttsBinding")
    private boolean played = false;
    private static Logger logger = LoggerFactory.getLogger((String)TimedDirectTTSUnit.class.getName());

    public TimedDirectTTSUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, behClass);
    }

    public TimedDirectTTSUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id, TTSBinding ttsBin) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, SpeechBehaviour.class);
    }

    public TimedDirectTTSUnit(BMLBlockPeg bbPeg, String text, String bmlId, String id, TTSBinding ttsBin) {
        this(NullFeedbackManager.getInstance(), bbPeg, text, bmlId, id, ttsBin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            if (!this.played) {
                logger.debug("playUnit {}", (Object)this.speechText);
                this.sendStartProgress(time);
                this.bmlStartTime = time;
                this.systemStartTime = (double)System.nanoTime() / 1.0E9;
                this.ttsBinding.setCallback(new MyTTSCallback());
                this.ttsBinding.speak(this.getBehaviourClass(), this.speechText);
                this.played = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TimingInfo getTiming() {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            return this.ttsBinding.getTiming(this.getBehaviourClass(), this.speechText);
        }
    }

    @Override
    protected void sendProgress(double playTime, double time) {
    }

    @Override
    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        try {
            this.ttsBinding.setFloatParameterValue(parameter, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.ttsBinding.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.ttsBinding.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.ttsBinding.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        if (time >= this.getEndTime()) {
            this.sendEndProgress(time);
            TTSBinding tTSBinding = this.ttsBinding;
            synchronized (tTSBinding) {
                logger.debug("StopUnit {}", (Object)this.speechText);
                this.played = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUnit(double time) {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            logger.debug("resetUnit {}", (Object)this.speechText);
            this.played = false;
        }
    }

    protected class MyTTSCallback
    implements TTSCallback {
        protected MyTTSCallback() {
        }

        public void bookmarkCallback(String bookmark) {
            double bmTime = (double)System.nanoTime() / 1.0E9;
            String bmlId = TimedDirectTTSUnit.this.getBMLId();
            String behaviorId = TimedDirectTTSUnit.this.getId();
            String syncId = bookmark;
            String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
            double timeStamp = TimedDirectTTSUnit.this.bmlStartTime + (bmTime - TimedDirectTTSUnit.this.systemStartTime);
            double bmlBlockTime = timeStamp - TimedDirectTTSUnit.this.bmlBlockPeg.getValue();
            TimedDirectTTSUnit.this.feedback(new BMLSyncPointProgressFeedback(id, TimedDirectTTSUnit.this.getBMLId(), behaviorId, syncId, bmlBlockTime, timeStamp));
        }

        public void phonemeCallback(int phoneme, int dur, int nextPhoneme, boolean stress) {
        }

        public void sentenceBoundryCallback(int offset, int length) {
        }

        public boolean stopCallback() {
            return TimedDirectTTSUnit.this.isDone() || TimedDirectTTSUnit.this.isLurking();
        }

        public void visimeCallback(int visime, int duration, int nextVis, boolean stress) {
            TimedDirectTTSUnit.this.prevVisime = TimedDirectTTSUnit.this.curVisime;
            TimedDirectTTSUnit.this.curVisime = visime;
            TimedDirectTTSUnit.this.nextVisime = nextVis;
            TimedDirectTTSUnit.this.visimeDuration = (double)duration / 1000.0;
        }

        public void wordBoundryCallback(int offset, int length) {
        }
    }
}

