/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.faceengine.viseme.VisemeBinding;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.TimedTTSUnitFactory;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.faceanimation.FaceController;
import hmi.tts.Bookmark;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTSPlanner
extends AbstractPlanner {
    private static Logger logger = LoggerFactory.getLogger((String)TTSPlanner.class.getName());
    private final VisemeBinding visimeBinding;
    private final TTSBinding ttsBinding;
    private final SpeechBinding speechBinding;
    private final TimedTTSUnitFactory suFactory;
    private static final double TIMEPEG_TOLERANCE = 0.003;
    private AnimationPlayer animationPlayer = null;
    private final PlanManager animationPlanManager;
    private final PlanManager facePlanManager;
    private final FaceController faceController;

    public String toString() {
        return this.getClass().getName() + "[" + this.ttsBinding.getClass().getName() + ", " + this.suFactory.getClass().getName() + "]";
    }

    public TTSPlanner(FeedbackManager bfm, TimedTTSUnitFactory suf, TTSBinding ttsGen, PlanManager planManager) {
        this(bfm, suf, ttsGen, null, null, null, null, planManager, null, null);
    }

    public TTSPlanner(FeedbackManager bfm, TimedTTSUnitFactory suf, TTSBinding ttsBin, FaceController fc, VisemeBinding vb, AnimationPlayer ap, SpeechBinding sBinding, PlanManager planManager, PlanManager facePlanManager, PlanManager animationPlanManager) {
        super(bfm, planManager);
        this.suFactory = suf;
        this.ttsBinding = ttsBin;
        this.faceController = fc;
        this.animationPlayer = ap;
        this.visimeBinding = vb;
        this.speechBinding = sBinding;
        this.facePlanManager = facePlanManager;
        this.animationPlanManager = animationPlanManager;
        if (facePlanManager == null && this.faceController != null) {
            logger.warn("TTSPlanner created with null facePlanManager and set faceController");
        }
        if (facePlanManager != null && this.faceController == null) {
            logger.warn("TTSPlanner created with set facePlanManager and null faceController");
        }
        if (animationPlanManager == null && this.animationPlayer != null) {
            logger.warn("TTSPlanner created with null animationPlanManager and set animationPlayer");
        }
        if (animationPlanManager != null && this.animationPlayer == null) {
            logger.warn("TTSPlanner created with set animationPlanManager and null animationPlayer");
        }
    }

    @Override
    public void shutdown() {
        this.ttsBinding.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeaker(String speaker) {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            this.ttsBinding.setVoice(speaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVoices() {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            return this.ttsBinding.getVoices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedTTSUnit createSpeechUnit(BMLBlockPeg bbPeg, Behaviour b) throws BehaviourPlanningException {
        try {
            SpeechBehaviour bSpeech = (SpeechBehaviour)b;
            TimedTTSUnit bs = this.suFactory.createTimedTTSUnit(bbPeg, bSpeech.getContent(), bSpeech.getBmlId(), bSpeech.id, this.ttsBinding, b.getClass());
            TTSBinding tTSBinding = this.ttsBinding;
            synchronized (tTSBinding) {
                bs.setup();
            }
            logger.debug("Created speech unit {} duration: {}", (Object)b.id, (Object)bs.getPreferedDuration());
            return bs;
        }
        catch (SpeechUnitPlanningException e) {
            throw new BehaviourPlanningException(b, e.getLocalizedMessage(), e);
        }
    }

    private void validateSacs(Behaviour b, TimedTTSUnit bs, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        for (TimePegAndConstraint sac : sacs) {
            if (bs.hasSync(sac.syncId)) continue;
            throw new BehaviourPlanningException(b, "Invalid synchronization constraint " + sac + " syncId " + sac.syncId + " not found in speech unit");
        }
    }

    @Override
    public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TimedTTSUnit bs = this.createSpeechUnit(bbPeg, b);
        this.validateSacs(b, bs, sacs);
        double startTime = bbPeg.getValue();
        boolean startFound = false;
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.syncId.equals("start") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            startTime = sac.peg.getGlobalValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                for (Bookmark bm : bs.getBookmarks()) {
                    if (!bm.getName().equals(sac.syncId)) continue;
                    startTime = sac.peg.getGlobalValue() - (double)bm.getOffset() * 0.001 - sac.offset;
                    logger.debug("Setting start time based on bookmark {} , startTime: {}, sac.offset: {}, bm.offset: {}", new Object[]{sac.syncId, startTime, sac.offset, bm.getOffset()});
                    break;
                }
                if (!sac.syncId.equals("end") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                startTime = sac.peg.getGlobalValue() - bs.getPreferedDuration() - sac.offset;
                break;
            }
        }
        this.linkBookmarks(bs, sacs, startTime, b);
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("end")) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    sac.peg.setGlobalValue(bs.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getGlobalValue() - (startTime + bs.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching speech is not supported yet. Possibly this can be solved by moving the speech behavior up in the BML spec? Behavior omitted.");
                }
            }
            if (!sac.syncId.equals("start") || sac.peg.getGlobalValue() != -1.7976931348623157E308) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getGlobalValue());
                continue;
            }
            sac.peg.setGlobalValue(startTime + sac.offset);
        }
        this.linkStartAndEnd(b, sacs, bs);
        return bs;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedTTSUnit bs = planElement == null ? this.createSpeechUnit(bbPeg, b) : (TimedTTSUnit)planElement;
        this.validateSacs(b, bs, sacs);
        this.linkStartAndEnd(b, sacs, bs);
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", bs.getStartPeg()));
        if (bs.getEndPeg() != null) {
            satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "end", bs.getEndPeg()));
        }
        this.linkBookmarks(bs, sacs, bs.getStartTime(), b);
        for (Bookmark bm : bs.getBookmarks()) {
            TimePeg p = bs.getBookMarkTimePeg(bm);
            if (p == null) continue;
            satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, bm.getName(), p));
        }
        if (this.faceController != null && this.visimeBinding != null) {
            this.addFaceUnits(bbPeg, b, bs);
        }
        if (this.animationPlayer != null && this.speechBinding != null) {
            this.addJawMovement(bbPeg, b, bs);
        }
        this.planManager.addPlanUnit(bs);
        return satp;
    }

    private void linkStartAndEnd(Behaviour b, List<TimePegAndConstraint> sacs, TimedTTSUnit bs) {
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.syncId.equals("start")) {
                if (sac.offset == 0.0) {
                    bs.setStart(sac.peg);
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    bs.setStart(p);
                }
            }
            if (!sac.syncId.equals("end")) continue;
            if (sac.offset == 0.0) {
                bs.setEnd(sac.peg);
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            bs.setEnd(p);
        }
    }

    private void addJawMovement(BMLBlockPeg bbPeg, Behaviour beh, TimedTTSUnit bs) {
        ArrayList<TimedMotionUnit> tmus = new ArrayList<TimedMotionUnit>();
        double totalDuration = 0.0;
        double prevDuration = 0.0;
        TimedMotionUnit tmu = this.speechBinding.getMotionUnit(0, bbPeg, beh.getBmlId(), beh.id, this.animationPlayer);
        tmu.resolveDefaultBMLKeyPositions();
        HashMap<TimedMotionUnit, Double> startTimes = new HashMap<TimedMotionUnit, Double>();
        HashMap<TimedMotionUnit, Double> endTimes = new HashMap<TimedMotionUnit, Double>();
        startTimes.put(tmu, new Double(0.0));
        endTimes.put(tmu, new Double(0.0));
        tmus.add(tmu);
        for (Visime vis : bs.getVisimes()) {
            double start = totalDuration / 1000.0 - prevDuration / 2000.0;
            double peak = totalDuration / 1000.0 + (double)vis.getDuration() / 2000.0;
            double end = totalDuration / 1000.0 + (double)vis.getDuration() / 1000.0;
            endTimes.put(tmu, peak);
            tmu = this.speechBinding.getMotionUnit(vis.getNumber(), bbPeg, beh.getBmlId(), beh.id, this.animationPlayer);
            if (tmu == null) {
                tmu = this.speechBinding.getMotionUnit(0, bbPeg, beh.getBmlId(), beh.id, this.animationPlayer);
            }
            logger.debug("Viseme number {}", (Object)vis.getNumber());
            startTimes.put(tmu, start);
            endTimes.put(tmu, end);
            tmus.add(tmu);
            tmu.resolveDefaultBMLKeyPositions();
            totalDuration += (double)vis.getDuration();
            prevDuration = vis.getDuration();
        }
        tmu = this.speechBinding.getMotionUnit(0, bbPeg, beh.getBmlId(), beh.id, this.animationPlayer);
        tmu.resolveDefaultBMLKeyPositions();
        tmus.add(tmu);
        startTimes.put(tmu, new Double(totalDuration / 1000.0));
        endTimes.put(tmu, new Double(totalDuration / 1000.0));
        for (TimedMotionUnit tm : tmus) {
            tm.setSubUnit(true);
            this.animationPlanManager.addPlanUnit(tm);
        }
        for (TimedMotionUnit plannedFU : tmus) {
            OffsetPeg startPeg = new OffsetPeg(bs.getStartPeg(), (Double)startTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("start"), (TimePeg)startPeg);
            OffsetPeg endPeg = new OffsetPeg(bs.getStartPeg(), (Double)endTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("end"), (TimePeg)endPeg);
            logger.debug("adding jaw movement at {}-{}", (Object)plannedFU.getStartTime(), (Object)plannedFU.getEndTime());
        }
    }

    private void addFaceUnits(BMLBlockPeg bbPeg, Behaviour beh, TimedTTSUnit bs) {
        ArrayList<TimedFaceUnit> tfus = new ArrayList<TimedFaceUnit>();
        double totalDuration = 0.0;
        double prevDuration = 0.0;
        TimedFaceUnit tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, -1, this.faceController);
        tfu.setSubUnit(true);
        HashMap<TimedFaceUnit, Double> startTimes = new HashMap<TimedFaceUnit, Double>();
        HashMap<TimedFaceUnit, Double> endTimes = new HashMap<TimedFaceUnit, Double>();
        startTimes.put(tfu, new Double(0.0));
        endTimes.put(tfu, new Double(0.0));
        for (Visime vis : bs.getVisimes()) {
            double start = totalDuration / 1000.0 - prevDuration / 2000.0;
            double peak = totalDuration / 1000.0 + (double)vis.getDuration() / 2000.0;
            double end = totalDuration / 1000.0 + (double)vis.getDuration() / 1000.0;
            endTimes.put(tfu, peak);
            tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, vis.getNumber(), this.faceController);
            startTimes.put(tfu, start);
            endTimes.put(tfu, end);
            tfus.add(tfu);
            totalDuration += (double)vis.getDuration();
            prevDuration = vis.getDuration();
        }
        tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, -1, this.faceController);
        tfus.add(tfu);
        startTimes.put(tfu, new Double(totalDuration / 1000.0));
        endTimes.put(tfu, new Double(totalDuration / 1000.0));
        for (TimedFaceUnit vfu : tfus) {
            vfu.setSubUnit(true);
            this.facePlanManager.addPlanUnit(vfu);
        }
        for (TimedFaceUnit plannedFU : tfus) {
            OffsetPeg startPeg = new OffsetPeg(bs.getStartPeg(), (Double)startTimes.get(plannedFU));
            plannedFU.setTimePeg("start", (TimePeg)startPeg);
            OffsetPeg endPeg = new OffsetPeg(bs.getStartPeg(), (Double)endTimes.get(plannedFU));
            plannedFU.setTimePeg("end", (TimePeg)endPeg);
            logger.debug("adding face movement at {}-{}", (Object)plannedFU.getStartTime(), (Object)plannedFU.getEndTime());
        }
    }

    private void linkBookmarks(TimedTTSUnit su, List<TimePegAndConstraint> sacs, double startTime, Behaviour b) throws BehaviourPlanningException {
        for (Bookmark bm : su.getBookmarks()) {
            for (TimePegAndConstraint sac : sacs) {
                if (!sac.syncId.equals(bm.getName())) continue;
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    logger.debug("Setting time for bookmark {} : {}", (Object)bm.getName(), (Object)(-sac.offset + startTime + (double)bm.getOffset() * 0.001));
                    sac.peg.setGlobalValue(sac.offset + startTime + (double)bm.getOffset() * 0.001);
                    if (sac.offset == 0.0) {
                        su.setTimePeg(bm, sac.peg);
                        continue;
                    }
                    su.setTimePeg(bm, (TimePeg)new OffsetPeg(sac.peg, -sac.offset));
                    continue;
                }
                if (Math.abs(sac.peg.getGlobalValue() - sac.offset - (startTime + (double)bm.getOffset() * 0.001)) > 0.1) {
                    throw new BehaviourPlanningException(b, "Can't set bookmark timing for bookmark: " + bm.getName() + ", functionality not yet supported. Desired time: " + (sac.peg.getGlobalValue() - sac.offset) + " Speech time: " + (startTime + (double)((float)bm.getOffset() * 0.001f)) + ". Behavior omitted.");
                }
                if (sac.offset == 0.0) {
                    su.setTimePeg(bm, sac.peg);
                    continue;
                }
                OffsetPeg p = new OffsetPeg(sac.peg, -sac.offset);
                su.setTimePeg(bm, (TimePeg)p);
            }
        }
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(SpeechBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        return this.ttsBinding.getSupportedBMLDescriptionExtensions();
    }

    @Override
    public double getRigidity(Behaviour beh) {
        return 1.0;
    }
}

