/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.speechengine.TextOutput;
import hmi.util.StringUtil;
import java.awt.Font;
import javax.swing.JLabel;

public class JLabelTextOutput
implements TextOutput {
    private JLabel label;
    private static final float FONT_PER_VOLUME_PERCENT = 0.25f;

    public JLabelTextOutput(JLabel l) {
        this.label = l;
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
        Font curFont = this.label.getFont();
        this.label.setFont(new Font(curFont.getFontName(), curFont.getStyle(), 12));
    }

    @Override
    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        if (!parameter.equals("volume")) {
            throw new ParameterNotFoundException(parameter);
        }
        Font curFont = this.label.getFont();
        this.label.setFont(new Font(curFont.getFontName(), curFont.getStyle(), (int)(0.25f * value)));
    }

    @Override
    public void setParameterValue(String parameter, String value) throws ParameterException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new InvalidParameterException(parameter, value);
        }
        this.setFloatParameterValue(parameter, Float.parseFloat(value));
    }

    @Override
    public float getFloatParameterValue(String parameter) throws ParameterException {
        if (parameter.equals("volume")) {
            Font curFont = this.label.getFont();
            return (float)curFont.getSize() / 0.25f;
        }
        throw new ParameterNotFoundException(parameter);
    }

    @Override
    public String getParameterValue(String parameter) throws ParameterException {
        return "" + this.getFloatParameterValue(parameter);
    }
}

