/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableCollection;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.DefaultTimedPlanUnitPlayer;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SingleThreadedPlanPlayer
implements PlanPlayer {
    private final PlanManager planManager;
    private final FeedbackManager fbManager;
    private List<TimedPlanUnit> tmuRemove = new ArrayList<TimedPlanUnit>();
    private TimedPlanUnitPlayer tpuPlayer;
    private List<TimedPlanUnit> playingPlanUnits = new ArrayList<TimedPlanUnit>();
    private static final Logger logger = LoggerFactory.getLogger((String)PlanUnitTimeManager.class.getName());

    public SingleThreadedPlanPlayer(FeedbackManager fbm, PlanManager planManager, TimedPlanUnitPlayer tpuCallback) {
        this.fbManager = fbm;
        this.planManager = planManager;
        this.tpuPlayer = tpuCallback;
    }

    public SingleThreadedPlanPlayer(FeedbackManager fbm, PlanManager planManager) {
        this(fbm, planManager, new DefaultTimedPlanUnitPlayer());
    }

    public SingleThreadedPlanPlayer(PlanManager planManager) {
        this(NullFeedbackManager.getInstance(), planManager);
    }

    public void exception(BMLExceptionFeedback e) {
        this.fbManager.exception(e);
    }

    public void addExceptionListener(BMLExceptionListener ws) {
        this.fbManager.addExceptionListener(ws);
    }

    public void removeAllExceptionListeners() {
        this.fbManager.removeAllExceptionListeners();
    }

    private boolean updatePlayingPU(TimedPlanUnit pu, double t) {
        ArrayList<TimedPlanUnit> remove = new ArrayList<TimedPlanUnit>();
        boolean play = true;
        TimedPlanUnit replacementOverlap = null;
        for (TimedPlanUnit planUnitPlay : this.playingPlanUnits) {
            if (planUnitPlay.getReplacementGroup() == null || !planUnitPlay.getReplacementGroup().equals(pu.getReplacementGroup())) continue;
            boolean runPuPlay = false;
            double puPlayEnd = planUnitPlay.getEndTime();
            double puEnd = pu.getEndTime();
            if (t >= planUnitPlay.getEndTime() && planUnitPlay.getEndTime() != -1.7976931348623157E308) {
                this.tpuPlayer.stopUnit(planUnitPlay, t);
                runPuPlay = false;
            } else if (t >= pu.getEndTime() && pu.getEndTime() != -1.7976931348623157E308) {
                this.tpuPlayer.stopUnit(pu, t);
                runPuPlay = true;
            } else if (planUnitPlay.getStartTime() > pu.getStartTime()) {
                runPuPlay = true;
            } else if (planUnitPlay.getStartTime() < pu.getStartTime()) {
                runPuPlay = false;
            } else if (puEnd == -1.7976931348623157E308 && puPlayEnd != -1.7976931348623157E308) {
                runPuPlay = true;
            } else if (puEnd != -1.7976931348623157E308 && puPlayEnd == -1.7976931348623157E308) {
                runPuPlay = false;
            } else if (puEnd == -1.7976931348623157E308 && puPlayEnd == -1.7976931348623157E308) {
                replacementOverlap = planUnitPlay;
                runPuPlay = false;
            } else if (puPlayEnd < puEnd) {
                runPuPlay = true;
            } else if (puPlayEnd == puEnd) {
                replacementOverlap = planUnitPlay;
                runPuPlay = false;
            }
            if (runPuPlay) {
                play = false;
                break;
            }
            remove.add(planUnitPlay);
            if (replacementOverlap == null) continue;
            break;
        }
        this.playingPlanUnits.removeAll(remove);
        if (replacementOverlap != null) {
            this.fbManager.puException(replacementOverlap, "Replacement group overlap between " + pu.getBMLId() + ":" + pu.getId() + " and " + replacementOverlap.getBMLId() + ":" + replacementOverlap.getId(), t);
            this.tmuRemove.add(replacementOverlap);
        }
        return play;
    }

    @Override
    public synchronized void play(double t) {
        this.playingPlanUnits.clear();
        this.tmuRemove.clear();
        for (TimedPlanUnit pu : this.planManager.getPlanUnits()) {
            if (!(t >= pu.getStartTime()) || !pu.isPlaying() && !pu.isLurking() || !this.updatePlayingPU(pu, t)) continue;
            this.playingPlanUnits.add(pu);
        }
        for (TimedPlanUnit pu : this.playingPlanUnits) {
            this.tpuPlayer.playUnit(pu, t);
        }
        this.handlePlayExceptions(t);
        this.handleStopExceptions(t);
        for (TimedPlanUnit tmuR : this.tmuRemove) {
            this.tpuPlayer.stopUnit(tmuR, t);
        }
        this.planManager.removeFinishedPlanUnits();
    }

    private void handleStopExceptions(double t) {
        ImmutableCollection<TimedPlanUnitPlayException> exceptions = this.tpuPlayer.getStopExceptions();
        for (TimedPlanUnitPlayException tmuEx : exceptions) {
            logger.warn("Exception stopping behaviour: ", (Throwable)tmuEx);
        }
        this.tpuPlayer.clearStopExceptions((Collection<TimedPlanUnitPlayException>)exceptions);
    }

    private void handlePlayExceptions(double t) {
        ImmutableCollection<TimedPlanUnitPlayException> exceptions = this.tpuPlayer.getPlayExceptions();
        for (TimedPlanUnitPlayException tmuEx : exceptions) {
            TimedPlanUnit tmuR = tmuEx.getPlanUnit();
            this.fbManager.puException(tmuR, "Runtime exception for behavior " + tmuR.getBMLId() + ":" + tmuR.getId() + ":" + tmuEx.getLocalizedMessage() + ".", t);
            this.tpuPlayer.stopUnit(tmuR, t);
        }
        this.tpuPlayer.clearPlayExceptions((Collection<TimedPlanUnitPlayException>)exceptions);
    }

    public Set<String> getInvalidBehaviors() {
        return this.planManager.getInvalidBehaviours();
    }

    public synchronized void removePlanUnits(Collection<TimedPlanUnit> puRemove, double time) {
        this.planManager.removePlanUnits(puRemove, time);
    }

    @Override
    public synchronized void interruptPlanUnit(String bmlId, String id, double globalTime) {
        this.planManager.interruptPlanUnit(bmlId, id, globalTime);
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.planManager.setBMLBlockState(bmlId, state);
    }

    public int getNumberOfPlanUnits() {
        return this.planManager.getNumberOfPlanUnits();
    }

    @Override
    public synchronized void reset(double time) {
        this.planManager.removeAllPlanUnits(time);
    }

    public Set<String> getBehaviours(String bmlId) {
        return this.planManager.getBehaviours(bmlId);
    }

    @Override
    public synchronized void interruptBehaviourBlock(String bmlId, double time) {
        this.planManager.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void shutdown() {
    }
}

