/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.feedback;

import com.google.common.collect.ImmutableSet;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.GuardedBy;

public class FeedbackManagerImpl
implements FeedbackManager {
    private final BMLBlockManager bmlBlockManager;
    @GuardedBy(value="feedbackListeners")
    private final List<BMLFeedbackListener> feedbackListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="exceptionListeners")
    private final List<BMLExceptionListener> exceptionListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="warningListeners")
    private final List<BMLWarningListener> warningListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="planningListeners")
    private final List<BMLTSchedulingListener> planningListeners = Collections.synchronizedList(new ArrayList());

    public FeedbackManagerImpl(BMLBlockManager bbm) {
        this.bmlBlockManager = bbm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(BMLExceptionFeedback e) {
        List<BMLExceptionListener> list = this.exceptionListeners;
        synchronized (list) {
            for (BMLExceptionListener el : this.exceptionListeners) {
                el.exception(e);
            }
        }
        this.bmlBlockManager.exception(e);
    }

    @Override
    public void addExceptionListener(BMLExceptionListener es) {
        this.exceptionListeners.add(es);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    @Override
    public void puException(TimedPlanUnit timedMU, String message, double time) {
        String bmlId = timedMU.getBMLId();
        String id = "w-" + timedMU.getId();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add(timedMU.getId());
        HashSet failedConstraints = new HashSet();
        String exceptionText = message + "\nBehavior " + timedMU.getBMLId() + ":" + timedMU.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(id, bmlId, time, failedBehaviours, failedConstraints, exceptionText, false));
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(BMLSyncPointProgressFeedback fb) {
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                fbl.syncProgress(fb);
            }
        }
        this.bmlBlockManager.syncProgress(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(List<BMLSyncPointProgressFeedback> fbs) {
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLSyncPointProgressFeedback fb : fbs) {
                for (BMLFeedbackListener fbl : this.feedbackListeners) {
                    fbl.syncProgress(fb);
                }
            }
        }
        for (BMLSyncPointProgressFeedback fb : fbs) {
            this.bmlBlockManager.syncProgress(fb);
        }
    }

    @Override
    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
    }

    @Override
    public ImmutableSet<String> getSyncsPassed(String bmlId, String behaviorId) {
        return this.bmlBlockManager.getSyncsPassed(bmlId, behaviorId);
    }

    @Override
    public void removeFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.remove(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockStopFeedback(BMLPerformanceStopFeedback psf) {
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                fbl.performanceStop(psf);
            }
        }
        this.bmlBlockManager.performanceStop(psf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockStartFeedback(BMLPerformanceStartFeedback psf) {
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                fbl.performanceStart(psf);
            }
        }
        this.bmlBlockManager.performanceStart(psf);
    }

    @Override
    public void removeExceptionListener(BMLExceptionListener e) {
        this.exceptionListeners.remove(e);
    }

    @Override
    public void addPlanningListener(BMLTSchedulingListener p) {
        this.planningListeners.add(p);
    }

    @Override
    public void removeAllPlanningListeners() {
        this.planningListeners.clear();
    }

    @Override
    public void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    @Override
    public void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    @Override
    public void removeWarningListener(BMLWarningListener ws) {
        this.warningListeners.remove(ws);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planningStart(BMLTSchedulingStartFeedback bpsf) {
        List<BMLTSchedulingListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTSchedulingListener pl : this.planningListeners) {
                pl.schedulingStart(bpsf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planningFinished(BMLTSchedulingFinishedFeedback bpff) {
        List<BMLTSchedulingListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTSchedulingListener pl : this.planningListeners) {
                pl.schedulingFinished(bpff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warn(BMLWarningFeedback w) {
        List<BMLWarningListener> list = this.warningListeners;
        synchronized (list) {
            for (BMLWarningListener wl : this.warningListeners) {
                wl.warn(w);
            }
        }
        this.bmlBlockManager.warn(w);
    }
}

