/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.facebinding;

import hmi.elckerlyc.faceengine.faceunit.AUFU;
import hmi.elckerlyc.faceengine.faceunit.FACSFU;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.MorphFU;
import hmi.elckerlyc.faceengine.faceunit.PlutchikFU;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.Reader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FaceUnitAssembler
extends XMLStructureAdapter {
    private static Logger logger = LoggerFactory.getLogger((String)FaceUnitAssembler.class.getName());
    private FaceUnit faceUnit;
    private static final String XMLTAG = "FaceUnit";

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String type = this.getRequiredAttribute("type", attrMap, tokenizer);
        if (type.equals("Morph")) {
            MorphFU fu = new MorphFU();
            this.faceUnit = fu;
        } else if (type.equals("Plutchik")) {
            PlutchikFU fu = new PlutchikFU();
            this.faceUnit = fu;
        } else if (type.equals("AU")) {
            AUFU fu = new AUFU();
            this.faceUnit = fu;
        } else if (type.equals("FACS")) {
            FACSFU fu = new FACSFU();
            this.faceUnit = fu;
            String filename = this.getRequiredAttribute("filename", attrMap, null);
            FACSConfiguration fc = new FACSConfiguration();
            try {
                fc.readXML((Reader)new Resources("").getReader(filename));
                fu.setConfig(fc);
            }
            catch (Exception e) {
                this.faceUnit = null;
                logger.warn("Cannot read FACS configuration from file \"{}\"; error: {}", (Object)filename, (Object)e.getMessage());
            }
        } else {
            logger.warn("Cannot read FaceUnit type \"{}\" in FaceBinding; omitting this FaceUnit", (Object)type);
        }
    }

    public FaceUnit getFaceUnit() {
        return this.faceUnit;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

