/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.anticipator;

import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.anticipator.KeyInfo;
import hmi.physics.PhysicsSync;
import hmi.util.CircularBuffer;
import hmi.util.SystemClock;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceBarTempoAnticipator
extends Anticipator
implements KeyListener,
KeyInfo {
    private List<TimePeg> orderedSynchs = Collections.synchronizedList(new ArrayList());
    private SystemClock physicsClock;
    private boolean pressed = false;
    private SBAObservable observable;
    private static final int PREDICTION_SIZE = 3;
    private CircularBuffer<Double> tempoBuffer = new CircularBuffer(3);
    private Logger logger = LoggerFactory.getLogger((String)SpaceBarTempoAnticipator.class.getName());

    public SpaceBarTempoAnticipator() {
        this.observable = new SBAObservable();
    }

    public List<TimePeg> getTimePegs() {
        return Collections.unmodifiableList(this.orderedSynchs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicsClock(SystemClock phClock) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock = phClock;
        }
    }

    @Override
    public void addSynchronisationPoint(String syncRef, TimePeg sp) {
        super.addSynchronisationPoint(syncRef, sp);
        this.orderedSynchs.add(sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTempo(double tempo, double startTime) {
        boolean update = false;
        double prevTime = 0.0;
        List<TimePeg> list = this.orderedSynchs;
        synchronized (list) {
            for (TimePeg p : this.orderedSynchs) {
                if (update) {
                    p.setGlobalValue(prevTime + tempo);
                    prevTime += tempo;
                    continue;
                }
                if (p.getGlobalValue() != -1.7976931348623157E308 && !(p.getGlobalValue() >= startTime)) continue;
                prevTime = startTime;
                if (p.getGlobalValue() - startTime > tempo * 0.5) {
                    prevTime += tempo;
                }
                update = true;
            }
        }
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    private double getTempo() {
        int i = 0;
        double totalTime = 0.0;
        double dPrev = 0.0;
        Iterator i$ = this.tempoBuffer.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            if (i > 0) {
                totalTime += d - dPrev;
            }
            dPrev = d;
            ++i;
        }
        if (i > 1) {
            this.logger.debug("tempo {}", (Object)(totalTime / (double)(i - 1)));
            return totalTime / (double)(i - 1);
        }
        this.logger.debug("tempo=1");
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && !this.pressed) {
            this.pressed = true;
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                this.tempoBuffer.add((Object)this.physicsClock.getMediaSeconds());
                this.updateTempo(this.getTempo(), this.physicsClock.getMediaSeconds());
            }
            this.observable.setChanged();
            this.observable.notifyObservers();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.pressed = false;
            this.observable.setChanged();
            this.observable.notifyObservers();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    private static class SBAObservable
    extends Observable {
        private SBAObservable() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }
}

