/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.SkeletonInterpolator;
import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.keyframe.KeyframeMU;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.procanimation.EndEffector;
import hmi.elckerlyc.animationengine.procanimation.HermiteSplineJEP;
import hmi.elckerlyc.animationengine.procanimation.IKBody;
import hmi.elckerlyc.animationengine.procanimation.Keyframes;
import hmi.elckerlyc.animationengine.procanimation.Parameter;
import hmi.elckerlyc.animationengine.procanimation.PerlinNoiseJEP;
import hmi.elckerlyc.animationengine.procanimation.Rotation;
import hmi.elckerlyc.animationengine.procanimation.TCBSplineJEP;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Id;
import hmi.util.StringUtil;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class ProcAnimationMU
extends XMLStructureAdapter
implements MotionUnit {
    public Id id = null;
    private ArrayList<EndEffector> endeffector = new ArrayList();
    private List<KeyframeMU> keyFrameMUs = new ArrayList<KeyframeMU>();
    private HashMap<String, Rotation> rotations = new HashMap();
    private HashMap<String, Keyframes> keyframes = new HashMap();
    private List<VJoint> bodyParts = new ArrayList<VJoint>();
    private Set<String> bodyPartFilter = new HashSet<String>();
    private EndEffector rootEff = null;
    private EndEffector rightFootEff = null;
    private EndEffector leftFootEff = null;
    private EndEffector rightHandEff = null;
    private EndEffector leftHandEff = null;
    private double minDuration = 0.0;
    private double maxDuration = 0.0;
    private double prefDuration = 0.0;
    private XJep parser;
    private Variable tVar;
    private ArrayList<IKParameter> parameters = new ArrayList();
    private IKBody body;
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private AtomicReference<String> replacementGroup = new AtomicReference();
    private float[] lf = new float[3];
    private float[] rf = new float[3];
    private float[] lh = new float[3];
    private float[] rh = new float[3];
    private float[] goal = new float[3];
    private float[] q = new float[4];
    private float[] ro = new float[3];

    public ProcAnimationMU() {
        this.setupParser();
    }

    public void addSkeletonInterpolator(SkeletonInterpolator ski) {
        this.keyFrameMUs.add(new KeyframeMU(ski));
    }

    public Collection<VJoint> getControlledJoints() {
        return this.bodyParts;
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void mirror() {
        if (this.body != null) {
            this.bodyParts.clear();
            this.bodyParts.addAll(this.body.getHuman().getParts());
        }
        for (EndEffector e : this.endeffector) {
            e.mirror();
        }
        this.setupEndEffectors();
        ArrayList<Keyframes> keyFr = new ArrayList<Keyframes>();
        for (Keyframes kf : this.keyframes.values()) {
            keyFr.add(kf);
            kf.mirror();
            if (this.body == null) continue;
            kf.setTarget(this.body.getHuman());
        }
        this.keyframes.clear();
        for (Keyframes kf : keyFr) {
            this.keyframes.put(kf.getTarget(), kf);
        }
        ArrayList<Rotation> rots = new ArrayList<Rotation>();
        for (Rotation r : this.rotations.values()) {
            rots.add(r);
            r.mirror();
        }
        this.rotations.clear();
        for (Rotation r : rots) {
            this.rotations.put(r.getTarget(), r);
        }
        for (KeyframeMU kmu : this.keyFrameMUs) {
            kmu.setParameterValue("mirror", "true");
        }
        if (this.body != null) {
            this.filterBodyParts();
        }
    }

    public ProcAnimationMU deepCopy() {
        ProcAnimationMU copy = new ProcAnimationMU();
        copy.replacementGroup = this.replacementGroup;
        copy.id = this.id;
        ArrayList<KeyPosition> keys = new ArrayList<KeyPosition>();
        for (KeyPosition key : this.getKeyPositions()) {
            keys.add(key.deepCopy());
        }
        copy.setKeyPositions(keys);
        ArrayList<EndEffector> effectors = new ArrayList<EndEffector>();
        for (EndEffector e : this.endeffector) {
            effectors.add(e.deepCopy());
        }
        copy.setEndEffectors(effectors);
        HashMap<String, Keyframes> keyfr = new HashMap<String, Keyframes>();
        for (Keyframes kf : this.keyframes.values()) {
            keyfr.put(kf.getTarget(), kf.deepCopy());
        }
        copy.setKeyframes(keyfr);
        HashMap<String, Rotation> rots = new HashMap<String, Rotation>();
        for (Rotation r : this.rotations.values()) {
            rots.put(r.getTarget(), r.deepCopy());
        }
        copy.setRotations(rots);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (IKParameter p : this.parameters) {
            params.add(p.param.deepCopy());
        }
        copy.setParameters(params);
        copy.keyFrameMUs = new ArrayList<KeyframeMU>();
        for (KeyframeMU kmu : this.keyFrameMUs) {
            copy.addSkeletonInterpolator(new SkeletonInterpolator(kmu.getSkeletonInterpolator(), null));
        }
        copy.setMinDuration(this.minDuration);
        copy.setMaxDuration(this.maxDuration);
        copy.setPrefDuration(this.prefDuration);
        copy.bodyPartFilter.addAll(this.bodyPartFilter);
        return copy;
    }

    @Override
    public double getPreferedDuration() {
        return this.prefDuration;
    }

    public void set(ProcAnimationMU ani) {
        this.id = ani.id;
        ArrayList<KeyPosition> keys = new ArrayList<KeyPosition>();
        for (KeyPosition key : ani.getKeyPositions()) {
            keys.add(key.deepCopy());
        }
        this.setKeyPositions(keys);
        ArrayList<EndEffector> effectors = new ArrayList<EndEffector>();
        for (EndEffector e : ani.endeffector) {
            effectors.add(e.deepCopy());
        }
        this.setEndEffectors(effectors);
        HashMap<String, Rotation> rots = new HashMap<String, Rotation>();
        for (Rotation r : ani.rotations.values()) {
            rots.put(r.getTarget(), r.deepCopy());
        }
        this.setRotations(rots);
        HashMap<String, Keyframes> frames = new HashMap<String, Keyframes>();
        for (Keyframes fr : ani.keyframes.values()) {
            frames.put(fr.getTarget(), fr.deepCopy());
        }
        this.setKeyframes(frames);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (IKParameter p : ani.parameters) {
            params.add(p.param.deepCopy());
        }
        this.setParameters(params);
        this.keyFrameMUs = new ArrayList<KeyframeMU>();
        for (KeyframeMU kmu : ani.keyFrameMUs) {
            this.addSkeletonInterpolator(kmu.getSkeletonInterpolator());
        }
        this.setMinDuration(ani.minDuration);
        this.setMaxDuration(ani.maxDuration);
        this.setPrefDuration(ani.prefDuration);
    }

    public void removeRotation(String name) {
        this.rotations.remove(name);
    }

    public void setRotation(String name, String xForm, String yForm, String zForm) throws ParseException {
        Rotation rot = this.rotations.get(name);
        if (rot == null) {
            rot = new Rotation(this.parser, name);
            this.rotations.put(name, rot);
        }
        rot.setRotation(0, xForm);
        rot.setRotation(1, yForm);
        rot.setRotation(2, zForm);
    }

    public void setEndEffector(String name, String xForm, String yForm, String zForm, String sForm, boolean isLocal) {
        EndEffector eff = this.getEndEffector(name);
        if (eff == null) {
            eff = new EndEffector(this.parser, name);
            this.endeffector.add(eff);
            this.setupEndEffectors();
        }
        eff.setTranslation(0, xForm);
        eff.setTranslation(1, yForm);
        eff.setTranslation(2, zForm);
        eff.setSwivel(sForm);
        eff.setLocal(isLocal);
    }

    public void setRotations(HashMap<String, Rotation> rots) {
        this.rotations.clear();
        for (Rotation r : rots.values()) {
            Rotation rNew = new Rotation(this.parser);
            rNew.set(r);
            this.rotations.put(rNew.getTarget(), rNew);
        }
    }

    @Override
    public void setFloatParameterValue(String sid, float value) {
        for (IKParameter p : this.parameters) {
            if (!p.param.getSid().equals(sid)) continue;
            p.param.setValue(value);
            p.tParam.setValue((Object)Float.valueOf(value));
        }
    }

    public void setKeyframes(HashMap<String, Keyframes> frs) {
        this.keyframes.clear();
        for (Keyframes fr : frs.values()) {
            Keyframes fNew = new Keyframes(this.parser);
            fNew.set(fr);
            this.keyframes.put(fr.getTarget(), fNew);
        }
    }

    public void setRotations(ProcAnimationMU ik) {
        for (Rotation rotSrc : ik.rotations.values()) {
            Rotation rotDst = this.rotations.get(rotSrc.getTarget());
            rotDst.set(rotSrc);
        }
    }

    private void setParameterValues() {
        for (IKParameter ikp : this.parameters) {
            ikp.tParam.setValue((Object)ikp.param.getValue());
        }
    }

    public void setParameters(Collection<Parameter> ps) {
        ArrayList<IKParameter> paramsToRemove = new ArrayList<IKParameter>();
        for (Parameter p : ps) {
            IKParameter ikp = this.getIKParameter(p.getSid());
            if (ikp == null) continue;
            paramsToRemove.add(ikp);
        }
        this.parameters.removeAll(paramsToRemove);
        for (Parameter p : ps) {
            this.addParameter(p);
        }
    }

    private IKParameter getIKParameter(String paramId) {
        for (IKParameter p : this.parameters) {
            if (!p.param.getSid().equals(paramId)) continue;
            return p;
        }
        return null;
    }

    public void addKeyframes(Keyframes kf) {
        this.keyframes.put(kf.getTarget(), kf);
    }

    public void addParameter(Parameter p) {
        IKParameter ikp = new IKParameter();
        ikp.param = p;
        this.parser.addVariable(p.getSid(), p.getValue());
        ikp.tParam = this.parser.getVar(p.getSid());
        ikp.tParam.setValue((Object)p.getValue());
        this.parameters.add(ikp);
    }

    public void setEffectors(ProcAnimationMU ik) {
        block0: for (EndEffector effSrc : ik.endeffector) {
            for (EndEffector effDst : this.endeffector) {
                if (!effSrc.getTarget().equals(effDst.getTarget())) continue;
                effDst.set(effSrc);
                continue block0;
            }
        }
    }

    public void setEndEffectors(ArrayList<EndEffector> newEndEffectors) {
        this.endeffector.clear();
        for (EndEffector eff : newEndEffectors) {
            EndEffector e = new EndEffector(this.parser, eff.getTarget());
            e.set(eff);
            this.endeffector.add(e);
        }
        this.setupEndEffectors();
    }

    public EndEffector getEndEffector(String target) {
        for (EndEffector eff : this.endeffector) {
            if (!eff.getTarget().equals(target)) continue;
            return eff;
        }
        return null;
    }

    public List<EndEffector> getAllEndEffectors() {
        return this.endeffector;
    }

    public void addEndEffector(EndEffector eff) {
        this.endeffector.add(eff);
    }

    public void removeEndEffector(String name) {
        ArrayList<EndEffector> remove = new ArrayList<EndEffector>();
        for (EndEffector eff : this.endeffector) {
            if (!eff.getTarget().equals(name)) continue;
            remove.add(eff);
            if (eff == this.rootEff) {
                this.rootEff = null;
            }
            if (eff == this.rightFootEff) {
                this.rightFootEff = null;
            }
            if (eff == this.rightHandEff) {
                this.rightHandEff = null;
            }
            if (eff == this.leftFootEff) {
                this.leftFootEff = null;
            }
            if (eff != this.leftHandEff) continue;
            this.leftHandEff = null;
        }
        this.endeffector.removeAll(remove);
    }

    public HashMap<String, Rotation> getRotations() {
        return this.rotations;
    }

    public Rotation getRotation(String target) {
        return this.rotations.get(target);
    }

    public void getPositions(float[] lf, float[] rf, float[] lh, float[] rh, float[] root, double[] swivels) {
        if (this.rootEff != null) {
            this.rootEff.evaluateTrans(root);
        } else {
            VJoint hRoot = this.body.getHuman().getPart("HumanoidRoot");
            hRoot.getPathTranslation(null, root);
        }
        if (this.leftFootEff != null) {
            swivels[0] = this.leftFootEff.evaluateSwivel();
            this.leftFootEff.evaluateTrans(lf);
        } else {
            VJoint lAnkle = this.body.getHuman().getPart("l_ankle");
            lAnkle.getPathTranslation(null, lf);
            swivels[0] = this.body.getSwivelLeftFoot();
        }
        if (this.rightFootEff != null) {
            swivels[1] = this.rightFootEff.evaluateSwivel();
            this.rightFootEff.evaluateTrans(rf);
        } else {
            VJoint rAnkle = this.body.getHuman().getPart("r_ankle");
            rAnkle.getPathTranslation(null, rf);
            swivels[1] = this.body.getSwivelRightFoot();
        }
        if (this.leftHandEff != null) {
            swivels[2] = this.leftHandEff.evaluateSwivel();
            this.leftHandEff.evaluateTrans(lh);
            if (this.leftHandEff.isLocal()) {
                VJoint lShoulder = this.body.getHuman().getPart("l_shoulder");
                lShoulder.getParent().pathTransform(null, lh);
            }
        } else {
            VJoint lWrist = this.body.getHuman().getPart("l_wrist");
            lWrist.getPathTranslation(null, lh);
            swivels[2] = this.body.getSwivelLeftArm();
        }
        if (this.rightHandEff != null) {
            swivels[3] = this.rightHandEff.evaluateSwivel();
            this.rightHandEff.evaluateTrans(rh);
            if (this.rightHandEff.isLocal()) {
                VJoint rShoulder = this.body.getHuman().getPart("r_shoulder");
                float[] temp = new float[3];
                Vec3f.set((float[])temp, (float[])rh);
                rShoulder.getParent().pathTransform(null, temp);
                Vec3f.set((float[])rh, (float[])temp);
            }
        } else {
            VJoint rWrist = this.body.getHuman().getPart("r_wrist");
            rWrist.getPathTranslation(null, rh);
            swivels[3] = this.body.getSwivelRightArm();
        }
    }

    public Collection<Parameter> getParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (IKParameter p : this.parameters) {
            params.add(p.param);
        }
        return params;
    }

    private void setupEndEffectors() {
        this.rootEff = null;
        this.leftFootEff = null;
        this.rightFootEff = null;
        this.leftHandEff = null;
        this.rightHandEff = null;
        for (EndEffector eff : this.endeffector) {
            if (eff.getTarget().equals("root") || eff.getTarget().equals("HumanoidRoot")) {
                this.rootEff = eff;
                continue;
            }
            if (eff.getTarget().equals("l_ankle")) {
                this.leftFootEff = eff;
                continue;
            }
            if (eff.getTarget().equals("r_ankle")) {
                this.rightFootEff = eff;
                continue;
            }
            if (eff.getTarget().equals("l_wrist")) {
                this.leftHandEff = eff;
                continue;
            }
            if (!eff.getTarget().equals("r_wrist")) continue;
            this.rightHandEff = eff;
        }
    }

    public void setup(Collection<Parameter> params, IKBody b) {
        this.body = b;
        this.bodyParts = new ArrayList<VJoint>();
        this.bodyParts.addAll(this.body.getHuman().getParts());
        for (Rotation r : this.rotations.values()) {
            r.setTarget(this.body.getHuman());
        }
        for (Keyframes fr : this.keyframes.values()) {
            fr.setTarget(this.body.getHuman());
        }
        for (KeyframeMU kmu : this.keyFrameMUs) {
            kmu.setTarget(this.body.getHuman());
        }
        this.setupEndEffectors();
        this.setParameters(params);
        this.findMissingParameters();
        this.filterBodyParts();
    }

    private void filterBodyParts() {
        if (this.bodyPartFilter.size() > 0) {
            for (KeyframeMU kmu : this.keyFrameMUs) {
                kmu.filterJoints(this.bodyPartFilter);
            }
        }
        ArrayList<VJoint> deleteList = new ArrayList<VJoint>();
        for (VJoint v : this.bodyParts) {
            boolean found = false;
            for (KeyframeMU kmu : this.keyFrameMUs) {
                if (!kmu.getJoints().contains(v.getSid())) continue;
                found = true;
            }
            if (found || this.rotations.get(v.getSid()) != null || this.keyframes.get(v.getSid()) != null || (v.getSid() == "r_shoulder" || v.getSid() == "r_elbow") && this.rightHandEff != null || (v.getSid() == "l_shoulder" || v.getSid() == "l_elbow") && this.leftHandEff != null || (v.getSid() == "r_hip" || v.getSid() == "r_knee" || v.getSid() == "r_ankle") && this.rightFootEff != null || (v.getSid() == "l_hip" || v.getSid() == "l_knee" || v.getSid() == "l_ankle") && this.leftFootEff != null) continue;
            deleteList.add(v);
        }
        if (this.bodyPartFilter.size() > 0) {
            for (VJoint v : this.bodyParts) {
                if (this.bodyPartFilter.contains(v.getSid())) continue;
                deleteList.add(v);
            }
        }
        this.bodyParts.removeAll(deleteList);
        this.sortBodyParts();
    }

    private void sortBodyParts() {
        Collections.sort(this.bodyParts, new Comparator<VJoint>(){

            @Override
            public int compare(VJoint vj1, VJoint vj2) {
                int pl2;
                int pl1 = ProcAnimationMU.this.body.getHuman().getPath(vj1).size();
                if (pl1 < (pl2 = ProcAnimationMU.this.body.getHuman().getPath(vj2).size())) {
                    return -1;
                }
                if (pl2 < pl1) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void findMissingParameters() {
        Vector v = new Vector();
        for (Rotation r : this.rotations.values()) {
            v = r.findParameters(v);
        }
        for (Keyframes fr : this.keyframes.values()) {
            v = fr.findParameters(v);
        }
        for (EndEffector eff : this.endeffector) {
            v = eff.findParameters(v);
        }
        for (int i = 0; i < v.size(); ++i) {
            String par = v.get(i).toString();
            if (!this.containsOnlyLetters(par = par.substring(0, par.indexOf(":"))) || this.parameterExists(par) || par.equals("t") || this.isConstantParameter(par)) continue;
            Parameter p = new Parameter();
            p.setSid(par);
            p.setValue(0.0);
            this.addParameter(p);
        }
    }

    private boolean containsOnlyLetters(String str) {
        char[] charList;
        for (char ch : charList = str.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean isConstantParameter(String str) {
        Variable v = this.parser.getVar(str);
        return v != null && v.isConstant();
    }

    private boolean parameterExists(String str) {
        for (IKParameter p : this.parameters) {
            if (!p.param.getSid().equals(str)) continue;
            return true;
        }
        return false;
    }

    private void play(double t, VJoint v) {
        if ((v.getSid() == "r_hip" || v.getSid() == "r_knee" || v.getSid() == "r_ankle") && this.rightFootEff != null) {
            if (v.getSid() == "r_hip") {
                this.body.setSwivelRightFoot(this.rightFootEff.evaluateSwivel());
                this.rightFootEff.evaluateTrans(this.rf);
                this.body.setRightFoot(this.rf, true);
            }
        } else if ((v.getSid() == "l_hip" || v.getSid() == "l_knee" || v.getSid() == "l_ankle") && this.leftFootEff != null) {
            if (v.getSid() == "l_hip") {
                this.leftFootEff.evaluateTrans(this.lf);
                this.body.setSwivelLeftFoot(this.leftFootEff.evaluateSwivel());
                this.body.setLeftFoot(this.lf, true);
            }
        } else if ((v.getSid() == "r_shoulder" || v.getSid() == "r_elbow") && this.rightHandEff != null) {
            if (v.getSid() == "r_shoulder") {
                this.body.setSwivelRightHand(this.rightHandEff.evaluateSwivel());
                this.rightHandEff.evaluateTrans(this.rh);
                if (this.rightHandEff.isLocal()) {
                    this.body.setLocalRightHand(this.rh);
                } else {
                    this.body.setRightHand(this.rh);
                }
            }
        } else if ((v.getSid() == "l_shoulder" || v.getSid() == "l_elbow") && this.leftHandEff != null) {
            if (v.getSid() == "l_shoulder") {
                this.body.setSwivelLeftHand(this.leftHandEff.evaluateSwivel());
                this.leftHandEff.evaluateTrans(this.lh);
                if (this.leftHandEff.isLocal()) {
                    this.body.setLocalLeftHand(this.lh);
                } else {
                    this.body.setLeftHand(this.lh);
                }
            }
        } else {
            Rotation r = this.rotations.get(v.getSid());
            Keyframes kfs = this.keyframes.get(v.getSid());
            if (r != null) {
                if (r.evaluate(this.ro)) {
                    Quat4f.setFromRollPitchYaw((float[])this.q, (float)this.ro[2], (float)this.ro[0], (float)this.ro[1]);
                    if (!r.isLocal()) {
                        v.setPathRotation(this.q, this.body.getHuman());
                    } else {
                        v.setRotation(this.q);
                    }
                }
            } else if (kfs != null) {
                kfs.evaluate(t, this.q, this.body.getHuman());
                v.setRotation(this.q);
            }
        }
    }

    @Override
    public void play(double t) {
        this.tVar.setValue((Object)t);
        this.setParameterValues();
        for (KeyframeMU kmu : this.keyFrameMUs) {
            kmu.play(t);
        }
        if (this.rootEff != null) {
            this.rootEff.evaluateTrans(this.goal);
            this.body.setRoot(this.goal);
        }
        for (VJoint v : this.bodyParts) {
            this.play(t, v);
        }
    }

    public double getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(double maxDuration) {
        this.maxDuration = maxDuration;
    }

    public double getMinDuration() {
        return this.minDuration;
    }

    public void setMinDuration(double minDuration) {
        this.minDuration = minDuration;
    }

    public double getPrefDuration() {
        return this.prefDuration;
    }

    public void setPrefDuration(double prefDuration) {
        this.prefDuration = prefDuration;
    }

    public String toString() {
        if (this.id != null) {
            return this.id.toString();
        }
        return "";
    }

    private void setupParser() {
        this.parser = new XJep();
        this.parser.addStandardFunctions();
        this.parser.addStandardConstants();
        this.parser.addFunction("noise", (PostfixMathCommandI)new PerlinNoiseJEP());
        this.parser.addFunction("hermite", (PostfixMathCommandI)new HermiteSplineJEP());
        this.parser.addFunction("tcbspline", (PostfixMathCommandI)new TCBSplineJEP());
        this.parser.addVariable("t", 0.0);
        this.parser.setAllowUndeclared(true);
        this.tVar = this.parser.getVar("t");
    }

    public EndEffector getLeftFootEff() {
        return this.leftFootEff;
    }

    public EndEffector getLeftHandEff() {
        return this.leftHandEff;
    }

    public EndEffector getRightFootEff() {
        return this.rightFootEff;
    }

    public EndEffector getRightHandEff() {
        return this.rightHandEff;
    }

    public EndEffector getRootEff() {
        return this.rootEff;
    }

    @Override
    public ProcAnimationMU copy(AnimationPlayer p) {
        return this.copy(p.getVNext());
    }

    public void setup(VJoint vNext) {
        this.body = new IKBody(vNext);
        this.setup(this.getParameters(), this.body);
    }

    public ProcAnimationMU copy(VJoint v) {
        ProcAnimationMU copy = this.deepCopy();
        copy.setup(v);
        for (Keyframes kf : copy.keyframes.values()) {
            kf.setJoint(v.getPart(kf.getTarget()));
        }
        for (Rotation r : copy.rotations.values()) {
            r.setJoint(v.getPart(r.getTarget()));
        }
        for (KeyframeMU kmu : copy.keyFrameMUs) {
            kmu.setTarget(v);
        }
        return copy;
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        ProcAnimationMU copy = this.copy(predict);
        copy.setParameters(this.getParameters());
        return copy;
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("prefDuration")) {
            this.prefDuration = Double.parseDouble(attrValue);
        } else if (attrName.equals("minDuration")) {
            this.minDuration = Double.parseDouble(attrValue);
        } else if (attrName.equals("maxDuration")) {
            this.maxDuration = Double.parseDouble(attrValue);
        } else {
            return false;
        }
        return true;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (tokenizer.atSTag("EndEffector")) {
                EndEffector eff = new EndEffector(this.parser);
                eff.readXML(tokenizer);
                this.endeffector.add(eff);
                continue;
            }
            if (tokenizer.atSTag("Rotation")) {
                Rotation rot = new Rotation(this.parser);
                rot.readXML(tokenizer);
                if (rot.getRotationFormula(0) == null && rot.getRotationFormula(1) == null && rot.getRotationFormula(2) == null || rot.getRotationFormula(0).equals("") && rot.getRotationFormula(1).equals("") && rot.getRotationFormula(2).equals("")) continue;
                this.rotations.put(rot.getTarget(), rot);
                continue;
            }
            if (tokenizer.atSTag("Keyframes")) {
                Keyframes frames = new Keyframes(this.parser);
                frames.readXML(tokenizer);
                this.addKeyframes(frames);
                continue;
            }
            if (tokenizer.atSTag("SkeletonInterpolator")) {
                SkeletonInterpolator ip = new SkeletonInterpolator(tokenizer);
                this.addSkeletonInterpolator(ip);
                continue;
            }
            if (tokenizer.atSTag("Parameter")) {
                Parameter param = new Parameter();
                param.readXML(tokenizer);
                this.addParameter(param);
                continue;
            }
            if (tokenizer.atSTag("KeyPosition")) {
                KeyPosition k = new KeyPosition();
                k.readXML(tokenizer);
                this.addKeyPosition(k);
                continue;
            }
            if (!tokenizer.atSTag("CutPosition")) continue;
            throw new RuntimeException("CutPositions have been deprecated, please remove from XML file");
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        for (Keyframes kf : this.keyframes.values()) {
            kf.appendXML(buf, fmt);
        }
        for (EndEffector ef : this.endeffector) {
            ef.appendXML(buf, fmt);
        }
        for (Rotation r : this.rotations.values()) {
            r.appendXML(buf, fmt);
        }
        for (KeyframeMU kmu : this.keyFrameMUs) {
            kmu.getSkeletonInterpolator().appendXML(buf, fmt);
        }
        for (KeyPosition k : this.getKeyPositions()) {
            k.appendXML(buf, fmt);
        }
        for (IKParameter par : this.parameters) {
            par.param.appendXML(buf, fmt);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        ProcAnimationMU.appendAttribute((StringBuilder)buf, (String)"prefDuration", (double)this.prefDuration);
        ProcAnimationMU.appendAttribute((StringBuilder)buf, (String)"minDuration", (double)this.minDuration);
        ProcAnimationMU.appendAttribute((StringBuilder)buf, (String)"maxDuration", (double)this.maxDuration);
        return buf;
    }

    public String getXMLTag() {
        return "ProcAnimation";
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("mirror")) {
            if (Boolean.parseBoolean(value)) {
                this.mirror();
            }
        } else if (name.equals("joints")) {
            String[] joints;
            for (String joint : joints = value.split("\\s")) {
                this.bodyPartFilter.add(joint);
            }
            this.filterBodyParts();
        } else if (name.equals("replacementgroup")) {
            this.replacementGroup.set(value);
        } else if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(name, Float.parseFloat(value));
        } else {
            throw new InvalidParameterException(name, value);
        }
    }

    @Override
    public String getParameterValue(String name) throws ParameterNotFoundException {
        for (Parameter p : this.getParameters()) {
            if (!p.getSid().equals(name)) continue;
            return "" + p.getValue();
        }
        throw new ParameterNotFoundException(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterNotFoundException {
        for (Parameter p : this.getParameters()) {
            if (!p.getSid().equals(name)) continue;
            return (float)p.getValue();
        }
        throw new ParameterNotFoundException(name);
    }

    @Override
    public TimedMotionUnit createTMU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new TimedMotionUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return this.replacementGroup.get();
    }

    static class IKParameter {
        Parameter param;
        Variable tParam;

        IKParameter() {
        }
    }
}

