/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.animation.SkeletonInterpolator;
import hmi.elckerlyc.animationengine.controller.CompoundController;
import hmi.elckerlyc.animationengine.controller.ControllerMU;
import hmi.elckerlyc.animationengine.keyframe.KeyframeMU;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.procanimation.GestureUnit;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationMU;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.physics.controller.PhysicalController;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.Reader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MotionUnitAssembler
extends XMLStructureAdapter {
    private static Logger logger = LoggerFactory.getLogger((String)MotionUnitAssembler.class.getName());
    private Resources resources;
    private MotionUnit motionUnit = null;
    private static final String XMLTAG = "MotionUnit";

    public MotionUnitAssembler(Resources r) {
        this.resources = r;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String type = this.getRequiredAttribute("type", attrMap, tokenizer);
        String file = this.getOptionalAttribute("file", attrMap, null);
        String className = this.getOptionalAttribute("class", attrMap, null);
        if (type.equals("ProcAnimation")) {
            ProcAnimationMU p = new ProcAnimationMU();
            if (file != null) {
                try {
                    p.readXML(this.resources.getReader(file));
                    this.motionUnit = p;
                }
                catch (Exception e) {
                    this.motionUnit = null;
                    logger.warn("Cannot read ProcAnimation from file \"{}\"", (Object)file);
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        } else if (type.equals("CompoundController")) {
            CompoundController cc = new CompoundController();
            if (file != null) {
                try {
                    cc.readXML(this.resources.getReader(file));
                    ControllerMU p = new ControllerMU(cc, null);
                    this.motionUnit = p;
                }
                catch (Exception e) {
                    this.motionUnit = null;
                    logger.warn("Cannot read CompoundController from file \"{}\"", (Object)file);
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        } else if (type.equals("Keyframe")) {
            try {
                SkeletonInterpolator si = new SkeletonInterpolator(new XMLTokenizer((Reader)this.resources.getReader(file)));
                this.motionUnit = new KeyframeMU(si);
            }
            catch (Exception e) {
                this.motionUnit = null;
                logger.warn("Cannot read KeyFrame animation from file \"{}\"", (Object)file);
                logger.warn("Exception: ", (Throwable)e);
            }
        } else if (type.equals("PhysicalController")) {
            PhysicalController pc = null;
            if (className != null) {
                try {
                    pc = (PhysicalController)Class.forName(className).newInstance();
                    ControllerMU p = new ControllerMU(pc, null);
                    this.motionUnit = p;
                }
                catch (InstantiationException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate PhysicalController \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate PhysicalController \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate PhysicalController \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        } else if (type.equals("Gesture")) {
            if (className != null) {
                try {
                    GestureUnit gu = (GestureUnit)Class.forName(className).newInstance();
                    gu.setResource(this.resources);
                    this.motionUnit = gu;
                }
                catch (InstantiationException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate GestureUnit \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate GestureUnit \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate GestureUnit \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        } else if (type.equals("Transition")) {
            TransitionMU t = null;
            if (className != null) {
                try {
                    t = (TransitionMU)Class.forName(className).newInstance();
                    this.motionUnit = t;
                }
                catch (InstantiationException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate Transition \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate Transition \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    this.motionUnit = null;
                    logger.warn("Cannot instantiate Transition \"{}\"", (Object)className);
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        } else if (type.equals("class") && className != null) {
            Class<?> muClass;
            try {
                muClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                this.motionUnit = null;
                logger.warn("Cannot instantiate MotionUnit \"{}\"", (Object)className);
                logger.warn("Exception: ", (Throwable)e);
                return;
            }
            if (!MotionUnit.class.isAssignableFrom(muClass)) {
                this.motionUnit = null;
                logger.warn("{} does not implement the MotionUnit interface", (Object)className);
                return;
            }
            try {
                this.motionUnit = (MotionUnit)muClass.newInstance();
            }
            catch (InstantiationException e) {
                this.motionUnit = null;
                logger.warn("Cannot instantiate MotionUnit \"{}\"", (Object)className);
                logger.warn("Exception: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.motionUnit = null;
                logger.warn("Cannot instantiate MotionUnit \"{}\"", (Object)className);
                logger.warn("Exception: ", (Throwable)e);
            }
        }
    }

    public MotionUnit getMotionUnit() {
        return this.motionUnit;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

