/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.animation.VObjectTransformCopier;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.PhysicsCallback;
import hmi.physics.PhysicsSync;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.GuardedBy;

public class AnimationPlayerManager {
    @GuardedBy(value="this")
    private VObjectTransformCopier votc;
    @GuardedBy(value="this")
    private ArrayList<AnimationPlayer> players = new ArrayList();
    @GuardedBy(value="this")
    private double prevTime = 0.0;
    @GuardedBy(value="PhysicsSync.getSync(),AnimationSync.getSync()")
    private PhysicsCallback physicsCallback;
    private static final float PHYSICS_STEPTIME = 0.003f;
    private VJoint animationRootJoint;
    private VJoint currentRootJoint;

    public AnimationPlayerManager(PhysicsCallback pb, VJoint animationRoot, VJoint currRoot) {
        this.votc = VObjectTransformCopier.newInstanceFromMatchingVObjectLists((List)currRoot.getParts(), (List)animationRoot.getParts(), (String)"TR");
        this.physicsCallback = pb;
        this.animationRootJoint = animationRoot;
        this.currentRootJoint = currRoot;
    }

    public synchronized void removeAnimationPlayer(AnimationPlayer p) {
        this.players.remove(p);
        this.votc = VObjectTransformCopier.newInstanceFromMatchingVObjectLists((List)this.currentRootJoint.getParts(), (List)this.animationRootJoint.getParts(), (String)"TR");
    }

    public synchronized void addAnimationPlayer(AnimationPlayer p) {
        this.players.add(p);
        this.votc = VObjectTransformCopier.newInstanceFromMatchingVObjectLists((List)this.currentRootJoint.getParts(), (List)this.animationRootJoint.getParts(), (String)"TR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void time(double currentTime) {
        float time = (float)(currentTime - this.prevTime);
        if (time < 0.0f) {
            this.prevTime = currentTime;
            return;
        }
        if (time > 0.003f) {
            while (time > 0.003f) {
                for (AnimationPlayer p : this.players) {
                    p.play(this.prevTime);
                }
                Object i$ = PhysicsSync.getSync();
                synchronized (i$) {
                    this.physicsCallback.time(0.003f);
                }
                time -= 0.003f;
                this.prevTime += (double)0.003f;
            }
        } else {
            return;
        }
        for (AnimationPlayer p : this.players) {
            p.copyPhysics();
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.votc.copyConfig();
        }
    }

    public static float getH() {
        return 0.003f;
    }

    public synchronized double getPrevTime() {
        return this.prevTime;
    }
}

