/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableList;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.util.RuntimeExceptionLoggingRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedPlanPlayer
implements PlanPlayer {
    private Object syncObject = new Object();
    @GuardedBy(value="syncObject")
    private double time;
    private final PlanManager planManager;
    private final FeedbackManager fbManager;
    private volatile boolean doStop = false;
    private Future<?> planRunner = null;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private static Logger logger = LoggerFactory.getLogger((String)MultiThreadedPlanPlayer.class.getName());

    public MultiThreadedPlanPlayer(FeedbackManager bbm, PlanManager planManager) {
        this.fbManager = bbm;
        this.planManager = planManager;
    }

    public MultiThreadedPlanPlayer(PlanManager planManager) {
        this(NullFeedbackManager.getInstance(), planManager);
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.planManager.setBMLBlockState(bmlId, state);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.planManager.interruptBehaviourBlock(bmlId, time);
    }

    public int getNumberOfPlanUnits() {
        return this.planManager.getNumberOfPlanUnits();
    }

    @Override
    public void interruptPlanUnit(String bmlId, String id, double globalTime) {
        this.planManager.interruptPlanUnit(bmlId, id, globalTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) {
        Object object = this.syncObject;
        synchronized (object) {
            this.time = t;
        }
        if (this.planRunner == null || this.planRunner.isDone()) {
            logger.debug("Creating new SpeechRunner");
            if (this.planRunner != null) {
                logger.debug("speechRunner.iDone(): {}", (Object)this.planRunner.isDone());
            }
            this.planRunner = this.exec.submit((Runnable)new RuntimeExceptionLoggingRunnable((Runnable)new SpeechRunner()));
        }
    }

    @Override
    public void shutdown() {
        this.scheduleStop();
        this.exec.shutdown();
        try {
            this.exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("InterruptedException on MultiThreadedPlanPlayer shutdown:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.doStop = true;
        }
        if (this.planRunner != null) {
            try {
                this.planRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                logger.warn("Execution Exception when trying to stop VerbalPlanPlayer thread: {}", (Throwable)e);
            }
        }
        object = this.syncObject;
        synchronized (object) {
            this.doStop = false;
        }
    }

    @Override
    public void reset(double time) {
        this.planManager.removeAllPlanUnits(time);
        logger.debug("Schedule VPP stop");
        this.scheduleStop();
        logger.debug("VPP cleared");
    }

    private void suException(TimedPlanUnit su, String message, double time) {
        logger.debug("suException with {}:{}", (Object)su.getBMLId(), (Object)su.getId());
        String bmlId = su.getBMLId();
        String id = "w-" + su.getId();
        HashSet<String> droppedBehaviours = new HashSet<String>();
        droppedBehaviours.add(su.getId());
        HashSet modifiedConstraints = new HashSet();
        String warningText = message + "\nBehavior " + su.getBMLId() + ":" + su.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(id, bmlId, time, droppedBehaviours, modifiedConstraints, warningText, false));
    }

    protected void playUnit(TimedPlanUnit su, double t) throws TimedPlanUnitPlayException {
        if (su.getState().isLurking()) {
            su.start(t);
        }
        if (su.getState().isPlaying()) {
            su.play(t);
        }
    }

    public void exception(BMLExceptionFeedback e) {
        this.fbManager.exception(e);
    }

    public void addExceptionListener(BMLExceptionListener ws) {
        this.fbManager.addExceptionListener(ws);
    }

    public void removeAllExceptionListeners() {
        this.fbManager.removeAllExceptionListeners();
    }

    class SpeechRunner
    implements Runnable {
        SpeechRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("start verbalplanplayer");
            double oldTime = -1.0;
            ArrayList<TimedPlanUnit> planUnitsRemove = new ArrayList<TimedPlanUnit>();
            while (!MultiThreadedPlanPlayer.this.doStop) {
                double t;
                Object object = MultiThreadedPlanPlayer.this.syncObject;
                synchronized (object) {
                    t = MultiThreadedPlanPlayer.this.time;
                }
                if (t == oldTime) continue;
                oldTime = t;
                ImmutableList<TimedPlanUnit> planUnitsCache = MultiThreadedPlanPlayer.this.planManager.getPlanUnits();
                planUnitsRemove.clear();
                for (TimedPlanUnit su : planUnitsCache) {
                    if (!(t >= su.getStartTime())) continue;
                    try {
                        MultiThreadedPlanPlayer.this.playUnit(su, MultiThreadedPlanPlayer.this.time);
                    }
                    catch (TimedPlanUnitPlayException e) {
                        logger.debug("TimedPlanUnitPlayException!");
                        MultiThreadedPlanPlayer.this.suException(su, e.getLocalizedMessage(), t);
                        planUnitsRemove.add(su);
                    }
                }
                MultiThreadedPlanPlayer.this.planManager.removePlanUnits(planUnitsRemove, MultiThreadedPlanPlayer.this.time);
                MultiThreadedPlanPlayer.this.planManager.removeFinishedPlanUnits();
            }
            logger.debug("stopped verbalplanplayer");
        }
    }
}

