/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.parametervaluechange;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTParameterValueChangeBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.parametervaluechange.ParameterValueInfo;
import hmi.elckerlyc.parametervaluechange.ParameterValueTrajectory;
import hmi.elckerlyc.parametervaluechange.TimedParameterValueChangeUnit;
import hmi.elckerlyc.parametervaluechange.TrajectoryBinding;
import hmi.elckerlyc.parametervaluechange.TrajectoryBindingException;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.List;

public class ParameterValueChangePlanner
extends AbstractPlanner {
    private BMLScheduler scheduler;
    private final TrajectoryBinding trajectoryBinding;

    public ParameterValueChangePlanner(FeedbackManager bfm, BMLScheduler scheduler, TrajectoryBinding trajBinding, PlanManager planManager) {
        this(bfm, trajBinding, planManager);
        this.scheduler = scheduler;
    }

    public ParameterValueChangePlanner(FeedbackManager bfm, TrajectoryBinding trajBinding, PlanManager planManager) {
        super(bfm, planManager);
        this.trajectoryBinding = trajBinding;
    }

    public void setScheduler(BMLScheduler s) {
        this.scheduler = s;
    }

    private TimedParameterValueChangeUnit createTimedParameterValueChangeUnit(BMLBlockPeg bbPeg, Behaviour b) throws BehaviourPlanningException {
        ParameterValueTrajectory traj;
        String[] target = b.getStringParameterValue("target").split(":");
        ParameterValueInfo paramValInfo = b.getStringParameterValue("initialValue") == null ? new ParameterValueInfo(target[0], target[1], b.getStringParameterValue("paramId"), b.getFloatParameterValue("targetValue")) : new ParameterValueInfo(target[0], target[1], b.getStringParameterValue("paramId"), b.getFloatParameterValue("initialValue"), b.getFloatParameterValue("targetValue"));
        try {
            traj = this.trajectoryBinding.getTrajectory(b.getStringParameterValue("type"));
        }
        catch (TrajectoryBindingException e) {
            BehaviourPlanningException ex = new BehaviourPlanningException(b, "Error binding trajectory type");
            ex.initCause(e);
            throw ex;
        }
        return new TimedParameterValueChangeUnit(this.fbManager, bbPeg, b.getBmlId(), b.id, this.scheduler, paramValInfo, traj);
    }

    private void setupPegs(TimedParameterValueChangeUnit tpvu, List<TimePegAndConstraint> sac) {
        if (this.getSacStart(sac) != null) {
            TimePeg start = this.getSacStart(sac).offset == 0.0 ? this.getSacStart(sac).peg : new OffsetPeg(this.getSacStart(sac).peg, -this.getSacStart(sac).offset);
            tpvu.setStartPeg(start);
            if (start.getGlobalValue() == -1.7976931348623157E308) {
                start.setLocalValue(0.0);
            }
        } else {
            tpvu.setStartPeg(this.getSacStroke(sac).peg);
        }
        if (this.getSacStroke(sac) != null) {
            TimePeg stroke = this.getSacStroke(sac).offset == 0.0 ? this.getSacStroke(sac).peg : new OffsetPeg(this.getSacStroke(sac).peg, -this.getSacStroke(sac).offset);
            tpvu.setStrokePeg(stroke);
        } else {
            tpvu.setStrokePeg(this.getSacStart(sac).peg);
        }
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedParameterValueChangeUnit pvcu = planElement == null ? this.createTimedParameterValueChangeUnit(bbPeg, b) : (TimedParameterValueChangeUnit)planElement;
        this.validateSacs(b, sac);
        this.setupPegs(pvcu, sac);
        this.planManager.addPlanUnit(pvcu);
        ArrayList<SyncAndTimePeg> list = new ArrayList<SyncAndTimePeg>();
        list.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", pvcu.getTimePeg("start")));
        list.add(new SyncAndTimePeg(b.getBmlId(), b.id, "stroke", pvcu.getTimePeg("stroke")));
        return list;
    }

    @Override
    public TimedParameterValueChangeUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        TimedParameterValueChangeUnit tpvu = this.createTimedParameterValueChangeUnit(bbPeg, b);
        this.validateSacs(b, sac);
        this.setupPegs(tpvu, sac);
        return tpvu;
    }

    private TimePegAndConstraint getSacStart(List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.syncId.equals("start")) continue;
            return sac;
        }
        return null;
    }

    private TimePegAndConstraint getSacStroke(List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.syncId.equals("stroke")) continue;
            return sac;
        }
        return null;
    }

    private void validateSacs(Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        if (sacs.size() > 2) {
            throw new BehaviourPlanningException(b, "Multiple synchronization constraints: " + sacs + " on to ParameterValueChange behavior " + b);
        }
        if (sacs.size() < 1) {
            throw new BehaviourPlanningException(b, "No synchronization constraints on to ParameterValueChange behavior " + b);
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start") || sac.syncId.equals("stroke")) continue;
            throw new BehaviourPlanningException(b, "ParameterValueChange behavior " + b + " has a synchronization constraint other than start or stroke.");
        }
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTParameterValueChangeBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        return new ArrayList<Class<? extends Behaviour>>();
    }
}

