/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import com.google.common.collect.ImmutableSet;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.interrupt.InterruptSpec;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedInterruptUnit
extends TimedAbstractPlanUnit {
    private static final Logger logger = LoggerFactory.getLogger((String)TimedInterruptUnit.class.getName());
    private TimePeg startPeg;
    private final BMLScheduler scheduler;
    private final String target;
    private ConcurrentHashMap<String, InterruptSpec> interruptSpecMap = new ConcurrentHashMap();

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    public TimedInterruptUnit(FeedbackManager bfm, BMLBlockPeg bmlPeg, String bmlId, String id, String iTarget, BMLScheduler s) {
        super(bfm, bmlPeg, bmlId, id);
        this.scheduler = s;
        this.target = iTarget;
        logger.debug("Created interrupt unit {} {} {}", (Object[])new String[]{this.getBMLId(), this.getId(), this.target});
    }

    public void addInterruptSpec(InterruptSpec s) {
        this.interruptSpecMap.put(s.getBehaviour(), s);
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("Starting interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        HashSet<String> stopBehs = new HashSet<String>();
        stopBehs.addAll(this.scheduler.getBehaviours(this.target));
        stopBehs.removeAll(this.interruptSpecMap.keySet());
        for (String beh : stopBehs) {
            logger.debug("Immidiatly interrupting behavior {}:{}", (Object)this.target, (Object)beh);
            this.scheduler.interruptBehavior(this.target, beh);
        }
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
        ArrayList<InterruptTarget> interruptTargets = new ArrayList<InterruptTarget>();
        ConcurrentHashMap<String, InterruptSpec> concurrentHashMap = this.interruptSpecMap;
        synchronized (concurrentHashMap) {
            for (String beh : this.interruptSpecMap.keySet()) {
                if (!this.scheduler.getBehaviours(this.target).contains(beh)) {
                    logger.debug("Behavior {}:{} not planned, prematurely removed from interrupt unit", (Object)this.target, (Object)beh);
                    this.interruptSpecMap.remove(beh);
                    break;
                }
                ImmutableSet<String> syncsFinished = this.scheduler.getSyncsPassed(this.target, beh);
                InterruptSpec is = this.interruptSpecMap.get(beh);
                if (is == null || !syncsFinished.contains((Object)is.getSyncPoint())) continue;
                logger.debug("Adding interrupt for {}:{}", (Object)this.target, (Object)beh);
                interruptTargets.add(new InterruptTarget(this.target, beh));
            }
        }
        for (InterruptTarget iTarget : interruptTargets) {
            logger.debug("Interrupting {}:{}", (Object)iTarget.getBmlId(), (Object)iTarget.getBehaviorId());
            this.scheduler.interruptBehavior(iTarget.getBmlId(), iTarget.getBehaviorId());
            logger.debug("Interrupt finished");
            InterruptSpec is = this.interruptSpecMap.get(iTarget.getBehaviorId());
            if (is == null) continue;
            for (String onStartBlock : is.getOnStartList()) {
                logger.debug("Starting {}", (Object)onStartBlock);
                this.scheduler.startBlock(onStartBlock);
            }
            this.interruptSpecMap.remove(iTarget.getBehaviorId());
            logger.debug("interruptSpecMap {}", this.interruptSpecMap);
        }
        if (this.interruptSpecMap.isEmpty()) {
            this.stop(time);
        }
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("stopping interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (syncId.equals("start")) {
            this.startPeg = peg;
        } else {
            logger.warn("Can't set TimePeg for sync {}, only setting start is allowed", (Object)syncId);
        }
    }

    private static class InterruptTarget {
        private final String bmlId;
        private final String behaviorId;

        public String getBmlId() {
            return this.bmlId;
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }

        public InterruptTarget(String bmlId, String behaviorId) {
            this.bmlId = bmlId;
            this.behaviorId = behaviorId;
        }
    }
}

