/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacePlayer
implements Player {
    private static Logger logger = LoggerFactory.getLogger((String)FacePlayer.class.getName());
    private PlanPlayer fpp;
    private FaceController faceController;
    private EmotionConverter emotionConverter;
    private FACSConverter facsConverter;

    public FacePlayer(BMLBlockManager bbm, FaceController fc, PlanPlayer planPlayer) {
        this(bbm, fc, new EmotionConverter(), new FACSConverter(), planPlayer);
    }

    public FacePlayer(BMLBlockManager bbm, FaceController fc, EmotionConverter ec, FACSConverter facsc, PlanPlayer planPlayer) {
        this.faceController = fc;
        this.emotionConverter = ec;
        this.facsConverter = facsc;
        this.fpp = planPlayer;
    }

    public FaceController getFaceController() {
        return this.faceController;
    }

    public EmotionConverter getEmotionConverter() {
        return this.emotionConverter;
    }

    public FACSConverter getFACSConverter() {
        return this.facsConverter;
    }

    @Override
    public synchronized void play(double time) {
        this.fpp.play(time);
    }

    @Override
    public synchronized void reset(double time) {
        this.fpp.reset(time);
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.fpp.setBMLBlockState(bmlId, state);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.fpp.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void interruptBehaviour(String behaviourId, String bmlId, double time) {
        this.fpp.interruptPlanUnit(bmlId, behaviourId, time);
    }
}

