/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.audioengine.TimedAudioUnitPlayException;
import hmi.elckerlyc.audioengine.WavClipUnit;
import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWavAudioUnit
extends TimedAbstractAudioUnit {
    private static Logger logger = LoggerFactory.getLogger((String)TimedWavAudioUnit.class.getName());
    protected WavUnit wavUnit;

    public TimedWavAudioUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, InputStream inputStream, String bmlId, String id) {
        super(bfm, bbPeg, inputStream, bmlId, id);
    }

    @Override
    public void sendProgress(double playTime, double time) {
    }

    @Override
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        if (!this.isPlaying()) {
            this.start(time);
            this.sendStartProgress(time);
            this.bmlStartTime = time;
            this.systemStartTime = (double)System.nanoTime() / 1.0E9;
        }
        double playTime = time - this.getStartTime();
        try {
            this.wavUnit.play(playTime);
        }
        catch (WavUnitPlayException e) {
            throw new TimedAudioUnitPlayException(e.getLocalizedMessage(), this, (Exception)e);
        }
        this.sendProgress(playTime, time);
    }

    @Override
    public void stopUnit(double time) {
        this.sendEndProgress(time);
        if (this.wavUnit != null) {
            this.wavUnit.stop();
        }
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        if (this.wavUnit == null) {
            throw new TimedAudioUnitPlayException("Null wavUnit unit", this);
        }
        this.wavUnit.setPlaying(true);
        this.sendStartProgress(time);
    }

    @Override
    protected void setupCache() throws AudioUnitPlanningException {
        try {
            this.wavUnit = new WavClipUnit(this.inputStream);
        }
        catch (WavUnitPlanningException e) {
            throw new AudioUnitPlanningException(e.getLocalizedMessage(), this, e);
        }
        this.setPrefferedDuration(this.wavUnit.getDuration());
        logger.debug("WAVUNIT DURATION: {}", (Object)this.wavUnit.getDuration());
    }

    @Override
    public void setFloatParameterValue(String paramId, float value) throws ParameterException {
        logger.debug("Setting wav parameter {}, value: {}", (Object)paramId, (Object)Float.valueOf(value));
        try {
            this.wavUnit.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.wavUnit.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }
}

