/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.AnalyticalIKSolver;
import hmi.animation.VJoint;
import hmi.math.Mat3f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;

public class IKBody {
    private VJoint human;
    private VJoint root;
    private VJoint lhip;
    private VJoint lknee;
    private VJoint lankle;
    private VJoint rhip;
    private VJoint rknee;
    private VJoint rankle;
    private VJoint lshoulder;
    private VJoint lelbow;
    private VJoint lwrist;
    private VJoint rshoulder;
    private VJoint relbow;
    private VJoint rwrist;
    private AnalyticalIKSolver solverRFeet;
    private AnalyticalIKSolver solverLFeet;
    private AnalyticalIKSolver solverLHand;
    private AnalyticalIKSolver solverRHand;
    private float[] leftFoot = new float[3];
    private float[] rightFoot = new float[3];
    private float[] temp = new float[3];
    private float[] q = new float[4];
    private float[] qW = new float[4];
    private float[] qWDes = new float[9];
    private float[] mW = new float[9];
    private float[] mWDes = new float[9];
    private float[] zAxis = new float[3];
    private float[] yAxis = new float[3];
    private float[] xAxis = new float[3];
    private float[] qSho = new float[4];
    private float[] qElb = new float[4];

    public IKBody(VJoint h) {
        this.human = h;
        this.lhip = this.human.getPart("l_hip");
        this.lknee = this.human.getPart("l_knee");
        this.lankle = this.human.getPart("l_ankle");
        this.rhip = this.human.getPart("r_hip");
        this.rknee = this.human.getPart("r_knee");
        this.rankle = this.human.getPart("r_ankle");
        this.lshoulder = this.human.getPart("l_shoulder");
        this.lelbow = this.human.getPart("l_elbow");
        this.lwrist = this.human.getPart("l_wrist");
        this.rshoulder = this.human.getPart("r_shoulder");
        this.relbow = this.human.getPart("r_elbow");
        this.rwrist = this.human.getPart("r_wrist");
        this.root = this.human.getPart("HumanoidRoot");
        float[] sv = new float[3];
        float[] tv = new float[3];
        this.lknee.getPathTranslation(this.lhip, tv);
        this.lankle.getPathTranslation(this.lknee, sv);
        this.solverLFeet = new AnalyticalIKSolver(sv, tv, AnalyticalIKSolver.LimbPosition.LEG, (Vec3f.length((float[])sv) + Vec3f.length((float[])tv)) * 0.999f);
        this.rknee.getPathTranslation(this.rhip, tv);
        this.rankle.getPathTranslation(this.rknee, sv);
        this.solverRFeet = new AnalyticalIKSolver(sv, tv, AnalyticalIKSolver.LimbPosition.LEG, (Vec3f.length((float[])sv) + Vec3f.length((float[])tv)) * 0.999f);
        this.lelbow.getPathTranslation(this.lshoulder, tv);
        this.lwrist.getPathTranslation(this.lelbow, sv);
        this.solverLHand = new AnalyticalIKSolver(sv, tv, AnalyticalIKSolver.LimbPosition.ARM, (Vec3f.length((float[])sv) + Vec3f.length((float[])tv)) * 0.999f);
        this.relbow.getPathTranslation(this.rshoulder, tv);
        this.rwrist.getPathTranslation(this.relbow, sv);
        this.solverRHand = new AnalyticalIKSolver(sv, tv, AnalyticalIKSolver.LimbPosition.ARM, (Vec3f.length((float[])sv) + Vec3f.length((float[])tv)) * 0.999f);
    }

    public void setRoot(float[] rootPos) {
        this.root.setTranslation(rootPos);
    }

    public void placeFeet() {
        this.setFeet(this.leftFoot, this.rightFoot, true);
    }

    private void setFoot(float[] pos, boolean keepFlat, VJoint hip, VJoint knee, VJoint ankle, AnalyticalIKSolver solver) {
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)hip, (float[])pos, (float[])this.temp);
        solver.solve(this.temp, this.qSho, this.qElb);
        hip.setRotation(this.qSho);
        knee.setRotation(this.qElb);
        if (keepFlat) {
            knee.getPathRotation(null, this.qW);
            Mat3f.setFromQuatScale((float[])this.mW, (float[])this.qW, (float)1.0f);
            Mat3f.getRow((float[])this.mW, (int)0, (float[])this.xAxis);
            Mat3f.getRow((float[])this.mW, (int)1, (float[])this.yAxis);
            Mat3f.getRow((float[])this.mW, (int)2, (float[])this.zAxis);
            Vec3f.set((float[])this.xAxis, (float)this.xAxis[0], (float)0.0f, (float)this.xAxis[2]);
            if ((double)Vec3f.lengthSq((float[])this.xAxis) < 0.01) {
                Vec3f.set((float[])this.xAxis, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                Vec3f.normalize((float[])this.xAxis);
            }
            Vec3f.set((float[])this.zAxis, (float)this.zAxis[0], (float)0.0f, (float)this.zAxis[2]);
            if ((double)Vec3f.lengthSq((float[])this.xAxis) < 0.01) {
                Vec3f.set((float[])this.zAxis, (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                Vec3f.normalize((float[])this.zAxis);
            }
            Vec3f.cross((float[])this.yAxis, (float[])this.zAxis, (float[])this.xAxis);
            Mat3f.setRow((float[])this.mWDes, (int)0, (float[])this.xAxis);
            Mat3f.setRow((float[])this.mWDes, (int)1, (float[])this.yAxis);
            Mat3f.setRow((float[])this.mWDes, (int)2, (float[])this.zAxis);
            Quat4f.set((float[])this.qWDes, (float[])this.mWDes);
            Quat4f.inverse((float[])this.qW);
            Quat4f.mul((float[])this.q, (float[])this.qW, (float[])this.qWDes);
            ankle.setRotation(this.q);
        }
    }

    public void setLeftFoot(float[] l, boolean keepFlat) {
        if (l != null) {
            this.leftFoot = l;
        }
        this.setFoot(l, keepFlat, this.lhip, this.lknee, this.lankle, this.solverLFeet);
    }

    public void setRightFoot(float[] r, boolean keepFlat) {
        if (r != null) {
            this.rightFoot = r;
        }
        this.setFoot(r, keepFlat, this.rhip, this.rknee, this.rankle, this.solverRFeet);
    }

    public void setFeet(float[] l, float[] r, boolean keepFlat) {
        this.setLeftFoot(l, keepFlat);
        this.setRightFoot(r, keepFlat);
    }

    public void setLeftHand(float[] l) {
        float[] left = new float[3];
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lshoulder, (float[])l, (float[])left);
        this.setLocalLeftHand(left);
    }

    public void setRightHand(float[] r) {
        float[] right = new float[3];
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rshoulder, (float[])r, (float[])right);
        this.setLocalRightHand(right);
    }

    public void setLocalRightHand(float[] r) {
        this.solverRHand.solve(r, this.qSho, this.qElb);
        this.rshoulder.setRotation(this.qSho);
        this.relbow.setRotation(this.qElb);
    }

    public void setSwivelRightHand(double sw) {
        this.solverRHand.setSwivel(sw);
    }

    public void setSwivelLeftHand(double sw) {
        this.solverLHand.setSwivel(sw);
    }

    public void setSwivelRightFoot(double sw) {
        this.solverRFeet.setSwivel(sw);
    }

    public void setSwivelLeftFoot(double sw) {
        this.solverLFeet.setSwivel(sw);
    }

    public double getSwivelRightFoot() {
        float[] e = new float[3];
        float[] g = new float[3];
        float[] rAnkle = new float[3];
        float[] rKnee = new float[3];
        this.rankle.getPathTranslation(null, rAnkle);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rhip, (float[])rAnkle, (float[])g);
        this.rknee.getPathTranslation(null, rKnee);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rhip, (float[])rKnee, (float[])e);
        return -this.solverRFeet.getSwivel(e, g);
    }

    public double getSwivelLeftFoot() {
        float[] e = new float[3];
        float[] g = new float[3];
        float[] lAnkle = new float[3];
        float[] lKnee = new float[3];
        this.lankle.getPathTranslation(null, lAnkle);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lhip, (float[])lAnkle, (float[])g);
        this.lknee.getPathTranslation(null, lKnee);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lhip, (float[])lKnee, (float[])e);
        return -this.solverLFeet.getSwivel(e, g);
    }

    public double getSwivelLeftArm() {
        float[] e = new float[3];
        float[] g = new float[3];
        float[] lWrist = new float[3];
        float[] lElbow = new float[3];
        this.lwrist.getPathTranslation(null, lWrist);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lshoulder, (float[])lWrist, (float[])g);
        this.lelbow.getPathTranslation(null, lElbow);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lshoulder, (float[])lElbow, (float[])e);
        return this.solverLHand.getSwivel(e, g);
    }

    public double getSwivelRightArm() {
        float[] e = new float[3];
        float[] g = new float[3];
        float[] rWrist = new float[3];
        float[] rElbow = new float[3];
        this.rwrist.getPathTranslation(null, rWrist);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rshoulder, (float[])rWrist, (float[])g);
        this.relbow.getPathTranslation(null, rElbow);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rshoulder, (float[])rElbow, (float[])e);
        return this.solverRHand.getSwivel(e, g);
    }

    public void getLeftFootRotation(double swivel, float[] lf, float[] qh, float[] qk) {
        float[] left = new float[3];
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.lhip, (float[])lf, (float[])left);
        this.solverLFeet.setSwivel(swivel);
        this.solverLFeet.solve(left, qh, qk);
    }

    public void getRootPosition(float[] root) {
        VJoint hRoot = this.human.getPart("HumanoidRoot");
        hRoot.getPathTranslation(null, root);
    }

    public void getRightFootRotation(double swivel, float[] rf, float[] qh, float[] qk) {
        float[] right = new float[3];
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.rhip, (float[])rf, (float[])right);
        this.solverRFeet.setSwivel(swivel);
        this.solverRFeet.solve(right, qh, qk);
    }

    public void setLocalLeftHand(float[] l) {
        this.solverLHand.solve(l, this.qSho, this.qElb);
        this.lshoulder.setRotation(this.qSho);
        this.lelbow.setRotation(this.qElb);
    }

    public VJoint getHuman() {
        return this.human;
    }
}

