/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.motionunit;

import com.google.common.base.Objects;
import hmi.bml.BMLSync;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class KeyPosition
extends XMLStructureAdapter
implements Comparable<KeyPosition> {
    public double time;
    public double weight;
    public String id = "";

    public KeyPosition() {
    }

    public KeyPosition(String id, double t, double w) {
        this.id = id;
        this.time = t;
        this.weight = w;
    }

    public String toString() {
        return this.id + " " + this.time + " " + this.weight;
    }

    private int bmlIdCompareTo(String otherId) {
        BMLSync bs = BMLSync.get((String)this.id);
        BMLSync bsOther = BMLSync.get((String)otherId);
        if (bs != null && bsOther != null) {
            if (bs.ordinal() < bsOther.ordinal()) {
                return -1;
            }
            if (bs.ordinal() > bsOther.ordinal()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(KeyPosition o) {
        if (this.time < o.time) {
            return -1;
        }
        if (this.time > o.time) {
            return 1;
        }
        int idcompare = this.bmlIdCompareTo(o.id);
        if (idcompare != 0) {
            return idcompare;
        }
        if (this.weight < o.weight) {
            return -1;
        }
        if (this.weight > o.weight) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.weight, this.time});
    }

    public boolean equals(Object o) {
        if (o instanceof KeyPosition) {
            KeyPosition pos = (KeyPosition)o;
            return pos.weight == this.weight && pos.time == this.time && pos.id.equals(this.id);
        }
        return false;
    }

    public boolean isEqual(KeyPosition o) {
        return this.id.equals(o.id);
    }

    public KeyPosition deepCopy() {
        KeyPosition copy = new KeyPosition();
        copy.time = this.time;
        copy.weight = this.weight;
        copy.id = this.id;
        return copy;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        KeyPosition.appendAttribute((StringBuilder)buf, (String)"time", (double)this.time);
        KeyPosition.appendAttribute((StringBuilder)buf, (String)"weight", (double)this.weight);
        KeyPosition.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.time = this.getRequiredDoubleAttribute("time", attrMap, tokenizer);
        this.weight = this.getOptionalDoubleAttribute("weight", attrMap, 1.0);
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
    }

    public String getXMLTag() {
        return "KeyPosition";
    }
}

