/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gaze;

import hmi.bml.BMLSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.gaze.GazeMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;

public class GazeTMU
extends TimedMotionUnit {
    private GazeMU gmu;

    public GazeTMU(FeedbackManager bfm, BMLBlockPeg bmlBlockPeg, String bmlId, String id, GazeMU mu) {
        super(bfm, bmlBlockPeg, bmlId, id, mu);
        this.gmu = mu;
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        try {
            double relaxDuration;
            double readyDuration;
            double readyTime = this.getTime("ready");
            double relaxTime = this.getTime("relax");
            if (readyTime != -1.7976931348623157E308) {
                readyDuration = readyTime - this.getStartTime();
            } else {
                TimePeg startPeg;
                double duration;
                readyDuration = 1.0;
                if (this.getEndTime() != -1.7976931348623157E308 && this.getStartTime() != -1.7976931348623157E308 && (duration = this.getEndTime() - this.getStartTime()) <= readyDuration * 2.0) {
                    readyDuration = duration * 0.5;
                }
                if ((startPeg = this.getTimePeg(BMLSync.START.getId())) == null) {
                    throw new TimedPlanUnitPlayException("Start peg is null", this);
                }
                OffsetPeg tpReady = new OffsetPeg(startPeg, readyDuration);
                this.setTimePeg("ready", (TimePeg)tpReady);
            }
            if (relaxTime != -1.7976931348623157E308) {
                relaxDuration = readyTime - this.getStartTime();
            } else {
                relaxDuration = readyDuration;
                TimePeg endPeg = this.getTimePeg("end");
                if (endPeg != null && this.getEndTime() != -1.7976931348623157E308) {
                    OffsetPeg tpRelax = new OffsetPeg(endPeg, -relaxDuration);
                    this.setTimePeg("relax", (TimePeg)tpRelax);
                }
            }
            this.gmu.setStartPose(readyDuration, relaxDuration);
        }
        catch (MUPlayException ex) {
            throw new TMUPlayException(ex.getLocalizedMessage(), this, (Exception)ex);
        }
    }
}

