/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gaze;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gaze.GazeMU;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.util.timemanipulator.SigmoidManipulator;
import hmi.math.Quat4f;

public class DynamicGazeMU
extends GazeMU {
    private float[] targetPosCurr = new float[3];
    private float[] qCurr = new float[4];
    private float[] qEndCurr = new float[4];

    public DynamicGazeMU() {
        this.qGaze = new float[4];
        this.qTemp = new float[4];
        this.qStart = new float[4];
        this.vecTemp = new float[3];
        this.ready = new KeyPosition("ready", 0.25, 1.0);
        this.relax = new KeyPosition("relax", 0.75, 1.0);
        this.addKeyPosition(this.ready);
        this.addKeyPosition(this.relax);
        this.target = "";
        this.tmp = new SigmoidManipulator(5.0, 1.0);
    }

    @Override
    public DynamicGazeMU copy(AnimationPlayer p) {
        DynamicGazeMU gmu = new DynamicGazeMU();
        gmu.neck = p.getVNext().getPart("skullbase");
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        gmu.player = p;
        return gmu;
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    @Override
    public void play(double t) throws MUPlayException {
        this.woTarget.getTranslation2(this.targetPosCurr, this.neck);
        Quat4f.transformVec3f((float[])this.getOffsetRotation(), (float[])this.targetPosCurr);
        if (t < 0.25) {
            double remDuration = (0.25 - t) / 0.25 * this.preparationDuration;
            this.setEndRotation(this.targetPosCurr, this.qEndCurr);
            this.neck.getRotation(this.qCurr);
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            Quat4f.interpolate((float[])this.qGaze, (float[])this.qCurr, (float[])this.qEndCurr, (float)deltaT);
            this.neck.setRotation(this.qGaze);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qGaze, (float[])this.qStart, (float)tManip);
            this.neck.setRotation(this.qTemp);
        } else {
            this.setEndRotation(this.targetPosCurr);
            this.neck.setRotation(this.qGaze);
        }
    }
}

