/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.controller;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.PhysicalTMU;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import java.util.List;

public class ControllerMU
implements MotionUnit {
    private PhysicalController controller;
    private List<PhysicalController> controllerList;
    private String replacementgroup = null;
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();

    public ControllerMU(PhysicalController pc, List<PhysicalController> pcl) {
        this.controller = pc;
        this.controllerList = pcl;
        this.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    @Override
    public void play(double t) {
        if (!this.controllerList.contains(this.controller)) {
            this.controllerList.add(this.controller);
        }
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    public ControllerMU copy(PhysicalHumanoid ph) {
        PhysicalController pc = this.controller.copy(ph);
        ControllerMU c = new ControllerMU(pc, this.controllerList);
        return c;
    }

    @Override
    public MotionUnit copy(AnimationPlayer p) {
        PhysicalController pc = this.controller.copy(p.getPHuman());
        ControllerMU c = new ControllerMU(pc, p.getControllers());
        return c;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
        try {
            this.controller.setParameterValue(name, value);
        }
        catch (ControllerParameterNotFoundException e) {
            throw new ParameterNotFoundException(e.getParamId(), (Exception)((Object)e));
        }
        catch (ControllerParameterException e) {
            throw new InvalidParameterException(name, "" + value, (Exception)((Object)e));
        }
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("replacementgroup")) {
            this.replacementgroup = value;
        } else {
            try {
                this.controller.setParameterValue(name, value);
            }
            catch (ControllerParameterNotFoundException e) {
                throw new ParameterNotFoundException(e.getParamId(), (Exception)((Object)e));
            }
            catch (ControllerParameterException e) {
                throw new InvalidParameterException(name, value, (Exception)((Object)e));
            }
        }
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        if (name.equals("replacementgroup")) {
            return this.replacementgroup;
        }
        try {
            return this.controller.getParameterValue(name);
        }
        catch (ControllerParameterNotFoundException e) {
            throw new ParameterNotFoundException(e.getParamId(), (Exception)((Object)e));
        }
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterNotFoundException {
        try {
            return this.controller.getFloatParameterValue(name);
        }
        catch (ControllerParameterNotFoundException e) {
            throw new ParameterNotFoundException(e.getParamId(), (Exception)((Object)e));
        }
    }

    @Override
    public TimedMotionUnit createTMU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new PhysicalTMU(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return this.replacementgroup;
    }

    public void reset() {
        this.controller.reset();
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

