/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.GazeBehaviour;
import hmi.bml.core.GestureBehaviour;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.core.PostureBehaviour;
import hmi.bml.ext.bmlt.BMLTControllerBehaviour;
import hmi.bml.ext.bmlt.BMLTKeyframeBehaviour;
import hmi.bml.ext.bmlt.BMLTNoiseBehaviour;
import hmi.bml.ext.bmlt.BMLTProcAnimationBehaviour;
import hmi.bml.ext.bmlt.BMLTTransitionBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.LinearStretchResolver;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.scheduler.UniModalResolver;
import java.util.ArrayList;
import java.util.List;

public class AnimationPlanner
extends AbstractPlanner {
    private final AnimationPlayer player;
    private GestureBinding gestureBinding;
    private SpeechBinding speechBinding;
    private final PlanManager predictedPlanManager;
    private final UniModalResolver resolver;

    public AnimationPlanner(FeedbackManager bfm, AnimationPlayer p, GestureBinding g, SpeechBinding s, PlanManager planManager, PlanManager predictedPlanManager) {
        super(bfm, planManager);
        this.gestureBinding = g;
        this.speechBinding = s;
        this.player = p;
        this.predictedPlanManager = predictedPlanManager;
        this.resolver = new LinearStretchResolver();
    }

    public void setGestureBinding(GestureBinding g) {
        this.gestureBinding = g;
    }

    public void setSpeechBinding(SpeechBinding s) {
        this.speechBinding = s;
    }

    public boolean hasSpeechBinding() {
        return this.speechBinding != null;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedMotionUnit tmu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(bbPeg, b, this.player);
            if (tmus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
            }
            tmu = tmus.get(0);
        } else {
            tmu = (TimedMotionUnit)planElement;
        }
        tmu.resolveDefaultBMLKeyPositions();
        this.linkSynchs(tmu, sacs);
        this.planManager.addPlanUnit(tmu);
        TimedMotionUnit tmuPred = tmu.getPredictor(this.player.getVPredict());
        if (tmuPred != null) {
            this.predictedPlanManager.addPlanUnit(tmuPred);
        }
        for (KeyPosition kp : tmu.getPegs().keySet()) {
            TimePeg p = tmu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(b.getBmlId(), b.id, kp.id, p));
        }
        return satps;
    }

    @Override
    public TimedMotionUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(bbPeg, b, this.player);
        if (tmus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
        }
        TimedMotionUnit tmu = tmus.get(0);
        tmu.resolveDefaultBMLKeyPositions();
        this.resolver.resolveSynchs(bbPeg, b, sac, tmu);
        return tmu;
    }

    private void linkSynchs(TimedMotionUnit tmu, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tmu.getMotionUnit().getKeyPositions()) {
                if (!s.syncId.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tmu.setTimePeg(kp, s.peg);
                    continue;
                }
                tmu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(HeadBehaviour.class);
        list.add(GazeBehaviour.class);
        list.add(GestureBehaviour.class);
        list.add(PostureBehaviour.class);
        list.add(BMLTProcAnimationBehaviour.class);
        list.add(BMLTControllerBehaviour.class);
        list.add(BMLTTransitionBehaviour.class);
        list.add(BMLTKeyframeBehaviour.class);
        list.add(BMLTNoiseBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTProcAnimationBehaviour.class);
        list.add(BMLTControllerBehaviour.class);
        list.add(BMLTTransitionBehaviour.class);
        list.add(BMLTKeyframeBehaviour.class);
        return list;
    }
}

