/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import com.google.common.base.Objects;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PegBoard {
    private final ConcurrentHashMap<PegKey, TimePeg> pegs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BMLBlockPeg> bmlBlockPegs = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger((String)PegBoard.class.getName());

    public PegBoard() {
        this.bmlBlockPegs.put(BMLBlockPeg.GLOBALPEG.getId(), BMLBlockPeg.GLOBALPEG);
    }

    public void clear() {
        this.pegs.clear();
        this.bmlBlockPegs.clear();
        this.bmlBlockPegs.put(BMLBlockPeg.GLOBALPEG.getId(), BMLBlockPeg.GLOBALPEG);
    }

    public void addBMLBlockPeg(BMLBlockPeg p) {
        this.bmlBlockPegs.put(p.getId(), p);
    }

    public BMLBlockPeg getBMLBlockPeg(String bmlId) {
        return this.bmlBlockPegs.get(bmlId);
    }

    public double getRelativePegTime(String bmlTargetId, TimePeg p) {
        if (p == null) {
            return -1.7976931348623157E308;
        }
        BMLBlockPeg bmlP = this.bmlBlockPegs.get(bmlTargetId);
        if (bmlP == null) {
            this.logger.warn("getRelativePegTime with invalid bmlTargetId {}", (Object)bmlTargetId);
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue() - bmlP.getValue();
    }

    public double getRelativePegTime(String bmlTargetId, String bmlId, String behId, String syncId) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, behId, syncId));
        if (p == null) {
            return -1.7976931348623157E308;
        }
        BMLBlockPeg bmlP = this.bmlBlockPegs.get(bmlTargetId);
        if (bmlP == null) {
            this.logger.warn("getRelativePegTime with invalid bmlTargetId {}", (Object)bmlTargetId);
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue() - bmlP.getValue();
    }

    public double getPegTime(String bmlId, String id, String syncId) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, id, syncId));
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public void setPegTime(String bmlId, String id, String syncId, double time) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, id, syncId));
        if (p != null) {
            p.setGlobalValue(time);
        }
    }

    public void setBMLBlockTime(String bmlId, double time) {
        BMLBlockPeg bp = this.bmlBlockPegs.get(bmlId);
        if (bp != null) {
            bp.setValue(time);
        }
    }

    public void addTimePegs(List<SyncAndTimePeg> satps) {
        for (SyncAndTimePeg satp : satps) {
            this.pegs.put(new PegKey(satp.bmlId, satp.id, satp.sync), satp.peg);
        }
    }

    public void addTimePeg(String bmlId, String id, String syncId, TimePeg p) {
        this.pegs.put(new PegKey(bmlId, id, syncId), p);
    }

    public TimePeg getTimePeg(String bmlId, String id, String syncId) {
        return this.pegs.get(new PegKey(bmlId, id, syncId));
    }

    public Set<String> getTimedSyncs(String bmlId, String behId) {
        HashSet<String> syncs = new HashSet<String>();
        for (PegKey p : this.pegs.keySet()) {
            if (!p.id.equals(behId) || !p.bmlId.equals(bmlId) || this.getPegTime(p.bmlId, p.id, p.syncId) == -1.7976931348623157E308) continue;
            syncs.add(p.syncId);
        }
        return syncs;
    }

    public void removeBehaviour(String bmlId, String id) {
        Iterator iter = this.pegs.keySet().iterator();
        while (iter.hasNext()) {
            PegKey p = (PegKey)iter.next();
            if (!p.id.equals(id) || !p.bmlId.equals(bmlId)) continue;
            iter.remove();
        }
    }

    private static class PegKey {
        final String syncId;
        final String id;
        final String bmlId;

        public PegKey(String bmlId, String id, String syncId) {
            this.syncId = syncId;
            this.id = id;
            this.bmlId = bmlId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PegKey)) {
                return false;
            }
            PegKey pk = (PegKey)o;
            return pk.bmlId.equals(this.bmlId) && pk.id.equals(this.id) && pk.syncId.equals(this.syncId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.syncId, this.id, this.bmlId});
        }
    }
}

