/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.BMLInfo;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningListener;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.BehaviorNotFoundException;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ElckerlycRealizer.class.getName());
    private final SchedulingClock schedulingClock;
    private final BMLParser parser;
    private final BMLScheduler scheduler;
    private final FeedbackManager fbManager;

    public ElckerlycRealizer(BMLParser bmlparser, FeedbackManager fbm, SchedulingClock c, BMLScheduler bmlScheduler, Engine ... engines) {
        this.schedulingClock = c;
        this.fbManager = fbm;
        this.parser = bmlparser;
        LOGGER.info("Initializing Elckerlyc Scheduler");
        this.scheduler = bmlScheduler;
        for (Engine e : engines) {
            if (e == null) continue;
            this.addEngine(e);
        }
        this.initBMLInfo();
    }

    public ElckerlycRealizer(BMLParser p, FeedbackManager fbm, SchedulingClock c, BMLBlockManager bbm, Engine ... engines) {
        this(p, fbm, c, new BMLScheduler(p, fbm, c, new SmartBodySchedulingStrategy(), bbm), engines);
    }

    public ElckerlycRealizer(FeedbackManager fbm, SchedulingClock c, BMLBlockManager bbm, Engine ... engines) {
        this(new BMLParser(), fbm, c, bbm, engines);
    }

    public void setParameterValue(String behId, String bmlId, String paramId, float value) throws ParameterException, BehaviorNotFoundException {
        this.scheduler.setParameterValue(bmlId, behId, paramId, value);
    }

    public void setParameterValue(String behId, String bmlId, String paramId, String value) throws ParameterException, BehaviorNotFoundException {
        this.scheduler.setParameterValue(bmlId, behId, paramId, value);
    }

    public void setFeedbackListener(BMLFeedbackListener f) {
        this.fbManager.removeAllFeedbackListeners();
        this.fbManager.addFeedbackListener(f);
    }

    public void setWarningListener(BMLWarningListener w) {
        this.scheduler.removeAllWarningListeners();
        this.scheduler.addWarningListener(w);
    }

    public void setExceptionListener(BMLExceptionListener e) {
        this.scheduler.removeAllExceptionListeners();
        this.scheduler.addExceptionListener(e);
    }

    public void addExceptionListener(BMLExceptionListener newListener) {
        this.scheduler.addExceptionListener(newListener);
    }

    public void addPlanningListener(BMLTPlanningListener bp) {
        this.scheduler.addPlanningListener(bp);
    }

    public void addWarningListener(BMLWarningListener newListener) {
        this.scheduler.addWarningListener(newListener);
    }

    public void addFeedbackListener(BMLFeedbackListener newListener) {
        this.scheduler.addFeedbackListener(newListener);
    }

    private void initBMLInfo() {
        for (Engine e : this.scheduler.getEngines()) {
            for (Class<? extends Behaviour> beh : e.getSupportedDescriptionExtensions()) {
                if (BMLInfo.supportedExtensions.contains(beh)) continue;
                BMLInfo.supportedExtensions.add(beh);
            }
        }
    }

    public void addEngine(Class<? extends Behaviour> beh, Engine e) {
        this.scheduler.addEngine(beh, e);
    }

    public void addEngine(Engine e) {
        for (Class<? extends Behaviour> beh : e.getSupportedBehaviours()) {
            this.addEngine(beh, e);
        }
        for (Class<? extends Behaviour> beh : e.getSupportedDescriptionExtensions()) {
            this.addEngine(beh, e);
        }
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.scheduler.addAnticipator(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.scheduler.removeAnticipator(aid);
    }

    public void scheduleBML(Reader in) throws IOException {
        this.scheduleBML(new XMLTokenizer(in));
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public void scheduleBML(XMLTokenizer in) {
        BehaviourBlock block = new BehaviourBlock();
        try {
            block.readXML(in);
        }
        catch (XMLScanException e) {
            String id = block.id;
            String bmlId = block.id;
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Parsing XML failed: see stack trace for more info. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        catch (IOException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "IO Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        catch (Exception e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception reading the XML. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        try {
            this.parser.addBehaviourBlock(block);
        }
        catch (Exception e) {
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception parsing the BML. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback("e-" + block.id, block.id, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        try {
            this.scheduler.schedule();
        }
        catch (Exception e) {
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception scheduling the BML. " + e + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback("e-" + block.id, block.id, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
    }

    public void scheduleBML(String blockContent) {
        XMLTokenizer in = new XMLTokenizer(blockContent);
        this.scheduleBML(in);
    }

    public void reset() {
        this.parser.clear();
        this.scheduler.reset();
    }

    public Engine getEngine(Class<? extends Behaviour> c) {
        return this.scheduler.getEngine(c);
    }

    public BMLScheduler getScheduler() {
        return this.scheduler;
    }
}

